/*
 * Decompiled with CFR 0.152.
 */
package com.github.iant89.ultimatenmz.drivers;

import com.github.iant89.ultimatenmz.drivers.ValueDriver;

public class StepDriver
extends ValueDriver<Integer> {
    private int minimum;
    private int maximum;
    private int value;
    private long delay;
    private boolean driveDown = false;
    private long nextStepTimer = -1L;

    public StepDriver(int min, int max, long delay) {
        this.minimum = min;
        this.maximum = max;
        this.delay = delay;
        this.value = min;
        this.calculateValue();
    }

    public int getMinimum() {
        return this.minimum;
    }

    public void setMinimum(int minimum) {
        this.minimum = minimum;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public void setMaximum(int maximum) {
        this.maximum = maximum;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public long getDelay() {
        return this.delay;
    }

    @Override
    public void setValue(Integer value) {
        this.value = value;
    }

    @Override
    public void calculateValue() {
        if (this.nextStepTimer == -1L) {
            this.nextStepTimer = System.currentTimeMillis() + this.getDelay();
        } else if (System.currentTimeMillis() >= this.nextStepTimer) {
            this.nextStepTimer = System.currentTimeMillis() + this.getDelay();
        } else {
            return;
        }
        if (this.driveDown) {
            --this.value;
            if (this.value <= this.getMinimum()) {
                this.value = this.getMinimum();
                this.driveDown = false;
            }
        } else {
            ++this.value;
            if (this.value >= this.getMaximum()) {
                this.value = this.getMaximum();
                this.driveDown = true;
            }
        }
    }

    @Override
    public Integer getValue() {
        this.calculateValue();
        return this.value;
    }
}

