/*
 * Decompiled with CFR 0.152.
 */
package com.github.iant89.ultimatenmz.drivers;

import com.github.iant89.ultimatenmz.drivers.ValueDriver;

public class SineDriver
extends ValueDriver<Float> {
    private float minimum;
    private float maximum;
    private float value;
    private long duration;
    private boolean driveDown = false;
    private long nextStepTimer = -1L;

    public SineDriver(float min, float max, long duration) {
        this.minimum = min;
        this.maximum = max;
        this.duration = duration;
        this.value = min;
        this.calculateValue();
    }

    public float getMinimum() {
        return this.minimum;
    }

    public void setMinimum(float minimum) {
        this.minimum = minimum;
    }

    public float getMaximum() {
        return this.maximum;
    }

    public void setMaximum(float maximum) {
        this.maximum = maximum;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public long getDuration() {
        return this.duration;
    }

    public float getStep() {
        return (this.getMaximum() - this.getMinimum()) / (float)this.getDuration();
    }

    @Override
    public void setValue(Float value) {
        this.value = value.floatValue();
    }

    @Override
    public void calculateValue() {
        if (this.nextStepTimer == -1L) {
            this.nextStepTimer = System.currentTimeMillis() + this.getDuration();
        } else if (System.currentTimeMillis() >= this.nextStepTimer) {
            this.nextStepTimer = System.currentTimeMillis() + this.getDuration();
        } else {
            return;
        }
        float step = (this.getMaximum() - this.getMinimum()) / (float)this.getDuration();
        if (this.driveDown) {
            this.value -= step;
            if (this.value <= this.getMinimum()) {
                this.value = this.getMinimum();
                this.driveDown = false;
            }
        } else {
            this.value += step;
            if (this.value >= this.getMaximum()) {
                this.value = this.getMaximum();
                this.driveDown = true;
            }
        }
    }

    @Override
    public Float getValue() {
        this.calculateValue();
        return Float.valueOf(this.value);
    }
}

