/*
 * Decompiled with CFR 0.152.
 */
package com.github.iant89.ultimatenmz;

import com.github.iant89.ultimatenmz.UltimateNMZConfig;
import com.github.iant89.ultimatenmz.notifications.VisualNotificationManager;
import com.github.iant89.ultimatenmz.notifications.VisualNotificationType;
import com.github.iant89.ultimatenmz.overlays.CountdownOverlay;
import com.github.iant89.ultimatenmz.overlays.PowerUpOverlay;
import com.github.iant89.ultimatenmz.overlays.UltimateNMZOverlay;
import com.github.iant89.ultimatenmz.overlays.VisualNotificationOverlay;
import com.github.iant89.ultimatenmz.utils.InventoryUtils;
import com.google.inject.Provides;
import java.awt.TrayIcon;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Skill;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameTick;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.Notifier;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.SkillIconManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Ultimate NMZ", description="AFK at Nightmare Zone, While watching youtube or playing a game? Say no more!", tags={"nmz", "afk", "nightmare", "nightmare zone", "info", "alert", "overlay", "combat", "boosts"})
public class UltimateNMZPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(UltimateNMZPlugin.class);
    private static final int[] NMZ_MAP_REGION = new int[]{9033};
    private static final Duration HOUR = Duration.ofHours(1L);
    private static final Duration OVERLOAD_DURATION = Duration.ofMinutes(5L);
    @Inject
    private Client client;
    @Inject
    private Notifier notifier;
    @Inject
    private ClientThread clientThread;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private UltimateNMZConfig config;
    @Inject
    private SkillIconManager iconManager;
    @Inject
    private UltimateNMZOverlay ultimateNmzOverlay;
    @Inject
    private VisualNotificationManager notificationManager;
    @Inject
    private VisualNotificationOverlay notificationOverlay;
    @Inject
    private CountdownOverlay countdownOverlay;
    @Inject
    private PowerUpOverlay powerUpOverlay;
    public int pointsPerHour;
    private Instant nmzSessionStartTime;
    private boolean nmzStarted = false;
    private boolean absorptionNotificationSend = true;
    private boolean overloadNotificationSend = true;
    private Instant lastHPAboveThresholdNotification;
    private Instant lastHPBelowThresholdNotification;
    private Instant lastAbsorptionBelowThresholdNotification;
    private Instant lastOverloadWarningNotification;
    private Instant lastOverloadExpiredNotification;
    private Instant lastZapperNotification;
    private Instant lastRecurrentDamageNotification;
    private Instant lastUltimateForceNotification;
    private Instant lastPowerSurgeNotification;
    private Instant lastOverload;
    private long overloadTimer = -1L;
    private Instant sessionStart;
    private Duration sessionDuration;
    private Instant sessionEnd;

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.countdownOverlay);
        this.overlayManager.add((Overlay)this.powerUpOverlay);
        this.overlayManager.add((Overlay)this.notificationOverlay);
        this.overlayManager.add((Overlay)this.ultimateNmzOverlay);
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            this.clientThread.invoke(this::start);
        }
    }

    private void start() {
    }

    public VisualNotificationManager getNotificationManager() {
        return this.notificationManager;
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.countdownOverlay);
        this.overlayManager.remove((Overlay)this.ultimateNmzOverlay);
        this.overlayManager.remove((Overlay)this.notificationOverlay);
        this.overlayManager.remove((Overlay)this.powerUpOverlay);
        Widget nmzWidget = this.client.getWidget(WidgetInfo.NIGHTMARE_ZONE);
        if (nmzWidget != null) {
            nmzWidget.setHidden(false);
        }
    }

    @Subscribe
    private void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals("ultimatenmz")) {
            return;
        }
        this.getNotificationManager().configUpdated();
        this.ultimateNmzOverlay.updateConfig();
    }

    @Provides
    UltimateNMZConfig provideConfig(ConfigManager configManager) {
        return (UltimateNMZConfig)configManager.getConfig(UltimateNMZConfig.class);
    }

    public UltimateNMZOverlay getUltimateNmzOverlay() {
        return this.ultimateNmzOverlay;
    }

    public Duration getOverloadDurationLeft() {
        if (this.overloadTimer == -1L) {
            return null;
        }
        if (System.currentTimeMillis() >= this.overloadTimer) {
            return null;
        }
        return Duration.ofSeconds((this.overloadTimer - System.currentTimeMillis()) / 1000L);
    }

    public Instant getSessionStart() {
        return this.sessionStart;
    }

    public Instant getSessionEnd() {
        return this.sessionEnd;
    }

    public Duration getSessionDuration() {
        if (this.sessionEnd != null) {
            return Duration.between(this.sessionStart, this.sessionEnd);
        }
        return Duration.between(this.sessionStart, Instant.now());
    }

    @Subscribe
    private void onChatMessage(ChatMessage event) {
        String msg = Text.removeTags((String)event.getMessage());
        if (msg.contains("You drink some of your overload potion.")) {
            int hpLeft;
            Instant now;
            log.debug("Player drank a overload potion");
            this.overloadTimer = System.currentTimeMillis() + 300000L;
            this.lastOverload = now = Instant.now();
            this.overloadNotificationSend = true;
            this.getNotificationManager().removeNotification(VisualNotificationType.OVERLOAD_ALMOST_EXPIRED);
            this.getNotificationManager().removeNotification(VisualNotificationType.OVERLOAD_EXPIRED);
            if (this.config.maximumHPNotification() && (hpLeft = this.client.getBoostedSkillLevel(Skill.HITPOINTS) - 50) <= this.config.maximumHPThresholdValue()) {
                this.getNotificationManager().removeNotification(VisualNotificationType.HP_ABOVE_THRESHOLD);
                this.getNotificationManager().blockNotification(VisualNotificationType.HP_ABOVE_THRESHOLD, 15);
            }
            return;
        }
        if (!this.isInNightmareZone()) {
            return;
        }
        if (msg.contains("effects of overload have worn off")) {
            this.getNotificationManager().blockNotification(VisualNotificationType.HP_ABOVE_THRESHOLD, 2);
            this.overloadTimer = -1L;
            if (this.config.overloadExpiredNotification()) {
                if (InventoryUtils.hasOneOfItems(this.client, 11730, 11731, 11732, 11733)) {
                    this.notificationManager.removeNotification(VisualNotificationType.OVERLOAD_ALMOST_EXPIRED);
                    if (this.config.visualAlerts()) {
                        this.getNotificationManager().createNotification(VisualNotificationType.OVERLOAD_EXPIRED);
                    }
                } else {
                    this.getNotificationManager().removeNotification(VisualNotificationType.OVERLOAD_ALMOST_EXPIRED);
                    this.getNotificationManager().removeNotification(VisualNotificationType.OVERLOAD_EXPIRED);
                }
            }
            this.sendNativeNotification(VisualNotificationType.OVERLOAD_EXPIRED);
            this.lastOverload = null;
        } else if (msg.contains("You wake up feeling refreshed")) {
            this.endSession();
        } else if (msg.contains("25 secs to")) {
            this.startSession();
        } else if (msg.contains("You activate the")) {
            if (msg.contains("zapper")) {
                this.getNotificationManager().removeNotification(VisualNotificationType.ZAPPER_SPAWNED);
            }
        } else if (msg.contains("You now have")) {
            if (msg.contains("recurrent damage")) {
                this.getNotificationManager().removeNotification(VisualNotificationType.RECURRENT_DAMAGE_SPAWNED);
            }
        } else if (msg.contains("You feel a surge of special")) {
            this.getNotificationManager().removeNotification(VisualNotificationType.POWER_SURGE_SPAWNED);
        } else if (msg.contains("A power-up has spawned:")) {
            if (msg.contains("Power surge")) {
                if (this.config.powerSurgeNotification() && this.config.visualAlerts()) {
                    this.getNotificationManager().createNotification(VisualNotificationType.POWER_SURGE_SPAWNED);
                }
                this.sendNativeNotification(VisualNotificationType.POWER_SURGE_SPAWNED);
            } else if (msg.contains("Recurrent damage")) {
                if (this.config.recurrentDamageNotification() && this.config.visualAlerts()) {
                    this.getNotificationManager().createNotification(VisualNotificationType.RECURRENT_DAMAGE_SPAWNED);
                }
                this.sendNativeNotification(VisualNotificationType.RECURRENT_DAMAGE_SPAWNED);
            } else if (msg.contains("Zapper")) {
                if (this.config.zapperNotification() && this.config.visualAlerts()) {
                    this.getNotificationManager().createNotification(VisualNotificationType.ZAPPER_SPAWNED);
                }
                this.sendNativeNotification(VisualNotificationType.ZAPPER_SPAWNED);
            } else if (msg.contains("Ultimate force")) {
                if (this.config.ultimateForceNotification() && this.config.visualAlerts()) {
                    this.getNotificationManager().createNotification(VisualNotificationType.ULTIMATE_FORCE_SPAWNED);
                }
                this.sendNativeNotification(VisualNotificationType.ULTIMATE_FORCE_SPAWNED);
            }
        }
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned event) {
        switch (event.getGameObject().getId()) {
            case 26264: {
                this.getNotificationManager().removeNotification(VisualNotificationType.POWER_SURGE_SPAWNED);
                break;
            }
            case 26265: {
                this.getNotificationManager().removeNotification(VisualNotificationType.RECURRENT_DAMAGE_SPAWNED);
                break;
            }
            case 26256: {
                this.getNotificationManager().removeNotification(VisualNotificationType.ZAPPER_SPAWNED);
                break;
            }
            case 26266: {
                this.getNotificationManager().removeNotification(VisualNotificationType.ULTIMATE_FORCE_SPAWNED);
            }
        }
    }

    private int getAbsorptionPoints() {
        return this.client.getVar(3956);
    }

    private void checkAbsorption() {
        int absorptionPoints = this.client.getVar(3956);
        if (absorptionPoints < this.config.absorptionThreshold() && this.config.absorptionNotification()) {
            if (InventoryUtils.hasOneOfItems(this.client, 11737, 11736, 11735, 11734)) {
                this.notificationManager.createNotification(VisualNotificationType.ABSORPTION_BELOW_THRESHOLD);
                this.sendNativeNotification(VisualNotificationType.ABSORPTION_BELOW_THRESHOLD);
            } else {
                this.notificationManager.removeNotification(VisualNotificationType.ABSORPTION_BELOW_THRESHOLD);
            }
        }
    }

    private void checkOverload() {
        if (this.overloadTimer == -1L) {
            return;
        }
        if (System.currentTimeMillis() >= this.overloadTimer) {
            this.overloadTimer = -1L;
            if (InventoryUtils.hasOneOfItems(this.client, 11737, 11736, 11735, 11734)) {
                if (this.config.overloadExpiredNotification()) {
                    this.notificationManager.removeNotification(VisualNotificationType.OVERLOAD_ALMOST_EXPIRED);
                    this.notificationManager.createNotification(VisualNotificationType.OVERLOAD_EXPIRED);
                    this.sendNativeNotification(VisualNotificationType.OVERLOAD_EXPIRED);
                }
            } else {
                this.notificationManager.removeNotification(VisualNotificationType.OVERLOAD_EXPIRED);
                this.notificationManager.removeNotification(VisualNotificationType.OVERLOAD_ALMOST_EXPIRED);
            }
            return;
        }
        if (System.currentTimeMillis() >= this.overloadTimer - (long)(this.config.overloadRunoutTime() * 1000) && this.config.overloadRunoutNotification() && !this.notificationManager.hasNotificationType(VisualNotificationType.OVERLOAD_ALMOST_EXPIRED)) {
            this.notificationManager.createNotification(VisualNotificationType.OVERLOAD_ALMOST_EXPIRED);
            this.sendNativeNotification(VisualNotificationType.OVERLOAD_ALMOST_EXPIRED);
        }
    }

    public boolean isInNightmareZone() {
        if (this.client.getLocalPlayer() == null) {
            return false;
        }
        return this.client.getLocalPlayer().getWorldLocation().getPlane() > 0 && Arrays.equals(this.client.getMapRegions(), NMZ_MAP_REGION);
    }

    private int calculatePointsPerHour() {
        Duration timeSinceStart;
        Instant now = Instant.now();
        int currentPoints = this.client.getVar(3949);
        if (this.nmzSessionStartTime == null) {
            this.nmzSessionStartTime = now;
        }
        if (!(timeSinceStart = Duration.between(this.nmzSessionStartTime, now)).isZero()) {
            return (int)((double)currentPoints * (double)HOUR.toMillis() / (double)timeSinceStart.toMillis());
        }
        return 0;
    }

    private void resetPointsPerHour() {
        this.nmzSessionStartTime = null;
        this.pointsPerHour = 0;
    }

    @Subscribe
    private void onGameTick(GameTick event) {
        if (!this.isInNightmareZone()) {
            if (!this.absorptionNotificationSend) {
                this.absorptionNotificationSend = true;
            }
            if (!this.overloadNotificationSend) {
                this.overloadNotificationSend = true;
            }
            if (this.nmzSessionStartTime != null) {
                this.resetPointsPerHour();
            }
            return;
        }
        if (this.config.absorptionNotification()) {
            this.checkAbsorption();
        }
        if (this.config.overloadExpiredNotification() || this.config.overloadRunoutNotification()) {
            this.checkOverload();
        }
        this.pointsPerHour = this.calculatePointsPerHour();
        int currentHP = this.client.getBoostedSkillLevel(Skill.HITPOINTS);
        boolean aboveHPThreshold = false;
        boolean belowHPThreshold = false;
        if (this.config.minimumHPNotification() && this.config.maximumHPNotification()) {
            if (currentHP < this.config.minimumHPThresholdValue() && this.config.minimumHPThresholdValue() != -1) {
                belowHPThreshold = true;
            } else if (currentHP > this.config.maximumHPThresholdValue() && this.config.maximumHPThresholdValue() != -1) {
                aboveHPThreshold = true;
            }
        } else if (this.config.minimumHPNotification()) {
            if (currentHP < this.config.minimumHPThresholdValue() && this.config.minimumHPThresholdValue() != -1) {
                belowHPThreshold = true;
            }
        } else if (this.config.maximumHPNotification() && currentHP > this.config.maximumHPThresholdValue() && this.config.maximumHPThresholdValue() != -1) {
            aboveHPThreshold = true;
        }
        if (this.config.visualAlerts()) {
            if (this.config.absorptionNotification()) {
                if (this.getAbsorptionPoints() <= this.config.absorptionThreshold()) {
                    this.getNotificationManager().createNotification(VisualNotificationType.ABSORPTION_BELOW_THRESHOLD);
                } else {
                    this.getNotificationManager().removeNotification(VisualNotificationType.ABSORPTION_BELOW_THRESHOLD);
                }
            } else {
                this.getNotificationManager().removeNotification(VisualNotificationType.ABSORPTION_BELOW_THRESHOLD);
            }
            if (this.config.overloadExpiredNotification()) {
                // empty if block
            }
            if (this.config.overloadRunoutNotification()) {
                // empty if block
            }
            if (this.config.minimumHPNotification() && this.config.maximumHPNotification()) {
                if (belowHPThreshold) {
                    this.getNotificationManager().createNotification(VisualNotificationType.HP_BELOW_THRESHOLD);
                } else {
                    this.getNotificationManager().removeNotification(VisualNotificationType.HP_BELOW_THRESHOLD);
                }
                if (aboveHPThreshold) {
                    this.getNotificationManager().createNotification(VisualNotificationType.HP_ABOVE_THRESHOLD);
                } else {
                    this.getNotificationManager().removeNotification(VisualNotificationType.HP_ABOVE_THRESHOLD);
                }
            } else if (this.config.minimumHPNotification()) {
                if (belowHPThreshold) {
                    this.getNotificationManager().createNotification(VisualNotificationType.HP_BELOW_THRESHOLD);
                } else {
                    this.getNotificationManager().removeNotification(VisualNotificationType.HP_BELOW_THRESHOLD);
                }
            } else if (this.config.maximumHPNotification()) {
                if (aboveHPThreshold) {
                    this.getNotificationManager().createNotification(VisualNotificationType.HP_ABOVE_THRESHOLD);
                } else {
                    this.getNotificationManager().removeNotification(VisualNotificationType.HP_ABOVE_THRESHOLD);
                }
            }
        } else {
            this.getNotificationManager().clearNotifications();
        }
    }

    private void startSession() {
        this.sessionStart = Instant.now();
        this.sessionEnd = null;
        this.ultimateNmzOverlay.nightmareZoneStarted();
        this.countdownOverlay.triggerCountdown(Instant.now().plus(Duration.ofSeconds(25L)));
        if (this.config.nativeAlerts()) {
            this.notifier.notify("Nightmare Zone has started!", TrayIcon.MessageType.INFO);
        }
        this.resetPointsPerHour();
    }

    private void endSession() {
        this.sessionEnd = Instant.now();
        this.ultimateNmzOverlay.nightmareZoneEnded();
        this.lastOverload = null;
        this.getNotificationManager().removeAll();
        if (this.config.nativeAlerts()) {
            this.notifier.notify("You have left the Nightmare Zone.", TrayIcon.MessageType.INFO);
        }
    }

    private boolean checkDurationForNotification(Instant instant, Duration duration) {
        if (instant == null) {
            return true;
        }
        return Duration.between(Instant.now(), instant).getSeconds() > duration.getSeconds();
    }

    private void sendNativeNotification(VisualNotificationType type) {
        if (!this.config.nativeAlerts()) {
            return;
        }
        switch (type) {
            case HP_BELOW_THRESHOLD: {
                if (!this.config.minimumHPNotification() || !this.checkDurationForNotification(this.lastHPBelowThresholdNotification, Duration.ofSeconds(30L))) break;
                this.lastHPBelowThresholdNotification = Instant.now();
                this.notifier.notify("Your Hitpoints are below " + this.config.minimumHPThresholdValue(), TrayIcon.MessageType.INFO);
                break;
            }
            case HP_ABOVE_THRESHOLD: {
                if (!this.config.maximumHPNotification() || !this.checkDurationForNotification(this.lastHPAboveThresholdNotification, Duration.ofSeconds(30L))) break;
                this.lastHPAboveThresholdNotification = Instant.now();
                this.notifier.notify("Your Hitpoints are above " + this.config.maximumHPThresholdValue(), TrayIcon.MessageType.INFO);
                break;
            }
            case ABSORPTION_BELOW_THRESHOLD: {
                if (!this.config.absorptionNotification() || !InventoryUtils.hasOneOfItems(this.client, 11734, 11735, 11736, 11737) || !this.checkDurationForNotification(this.lastAbsorptionBelowThresholdNotification, Duration.ofSeconds(30L))) break;
                this.lastAbsorptionBelowThresholdNotification = Instant.now();
                this.notifier.notify("Absorption Points is below threshold: " + this.getAbsorptionPoints(), TrayIcon.MessageType.INFO);
                break;
            }
            case OVERLOAD_ALMOST_EXPIRED: {
                if (!this.config.overloadRunoutNotification() || !InventoryUtils.hasOneOfItems(this.client, 11730, 11731, 11732, 11733) || !this.checkDurationForNotification(this.lastOverloadWarningNotification, Duration.ofSeconds(30L))) break;
                this.lastOverloadWarningNotification = Instant.now();
                this.notifier.notify("Your Overload Potion is about to expire.", TrayIcon.MessageType.INFO);
                break;
            }
            case OVERLOAD_EXPIRED: {
                if (!this.config.overloadExpiredNotification() || !InventoryUtils.hasOneOfItems(this.client, 11730, 11731, 11732, 11733) || !this.checkDurationForNotification(this.lastOverloadExpiredNotification, Duration.ofSeconds(60L))) break;
                this.lastOverloadExpiredNotification = Instant.now();
                this.notifier.notify("Your Overload Potion has expired.", TrayIcon.MessageType.INFO);
                break;
            }
            case ZAPPER_SPAWNED: {
                if (!this.config.zapperNotification() || !this.checkDurationForNotification(this.lastZapperNotification, Duration.ofSeconds(60L))) break;
                this.lastZapperNotification = Instant.now();
                this.notifier.notify("A Zapper Power-Up has Spawned!", TrayIcon.MessageType.INFO);
                break;
            }
            case POWER_SURGE_SPAWNED: {
                if (!this.config.powerSurgeNotification() || !this.checkDurationForNotification(this.lastPowerSurgeNotification, Duration.ofSeconds(60L))) break;
                this.lastPowerSurgeNotification = Instant.now();
                this.notifier.notify("A Power Surge Power-Up has Spawned!", TrayIcon.MessageType.INFO);
                break;
            }
            case RECURRENT_DAMAGE_SPAWNED: {
                if (!this.config.recurrentDamageNotification() || !this.checkDurationForNotification(this.lastRecurrentDamageNotification, Duration.ofSeconds(60L))) break;
                this.lastRecurrentDamageNotification = Instant.now();
                this.notifier.notify("A Recurrent Damage Power-Up has Spawned!", TrayIcon.MessageType.INFO);
                break;
            }
            case ULTIMATE_FORCE_SPAWNED: {
                if (!this.config.ultimateForceNotification() || !this.checkDurationForNotification(this.lastUltimateForceNotification, Duration.ofSeconds(60L))) break;
                this.lastUltimateForceNotification = Instant.now();
                this.notifier.notify("A Ultimate Force Power-Up has Spawned!", TrayIcon.MessageType.INFO);
            }
        }
    }

    public int getPointsPerHour() {
        return this.pointsPerHour;
    }
}

