/*
 * Decompiled with CFR 0.152.
 */
package com.github.iant89.ultimatenmz;

import com.github.iant89.ultimatenmz.notifications.VisualNotificationEffectType;
import com.github.iant89.ultimatenmz.notifications.VisualNotificationSpeed;
import java.awt.Color;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.Range;

@ConfigGroup(value="ultimatenmz")
public interface UltimateNMZConfig
extends Config {
    @ConfigSection(name="General", description="General Configuration", position=50, closedByDefault=false)
    public static final String generalSection = "general";
    @ConfigSection(name="Minimum Hitpoints", description="Options pertaining to Minimum Hitpoints.", position=51, closedByDefault=false)
    public static final String minimumHitpointsSection = "minimumHitpoints";
    @ConfigSection(name="Maximum Hitpoints", description="Options pertaining to Maximum Hitpoints.", position=52, closedByDefault=false)
    public static final String maximumHitpointsSection = "maximumHitpoints";
    @ConfigSection(name="Recurrent Damage Power-Up", description="Options pertaining to Recurrent Damage Power-Ups.", position=53, closedByDefault=false)
    public static final String recurrentDamagePowerupSection = "recurrentDamagePowerup";
    @ConfigSection(name="Zapper Power-Up", description="Options pertaining to Zapper Power-Ups.", position=54, closedByDefault=false)
    public static final String zapperPowerupSection = "zapperPowerup";
    @ConfigSection(name="Power Surge Power-Up", description="Options pertaining to Power Surge Power-Ups.", position=55, closedByDefault=false)
    public static final String powerSurgePowerupSection = "powerSurgePowerup";
    @ConfigSection(name="Ultimate Force Power-Up", description="Options pertaining to Ultimate Force Power-Ups.", position=56, closedByDefault=false)
    public static final String ultimateForcePowerupSection = "ultimateForcePowerup";
    @ConfigSection(name="Absorption", description="Options pertaining to Absorption Potions.", position=57, closedByDefault=false)
    public static final String absorptionSection = "absorption";
    @ConfigSection(name="Overload", description="Options pertaining to Overloads Potions.", position=58, closedByDefault=false)
    public static final String overloadSection = "overloads";
    @ConfigSection(name="Paint", description="Options pertaining to the Paint.", position=59, closedByDefault=false)
    public static final String paintSection = "paint";

    @ConfigItem(keyName="visualAlerts", name="Visual Notifications", description="Toggles visual notifications.", position=0, section="general")
    default public boolean visualAlerts() {
        return true;
    }

    @ConfigItem(keyName="nativeAlerts", name="Native Notifications", description="Toggles native notifications.", position=1, section="general")
    default public boolean nativeAlerts() {
        return true;
    }

    @ConfigItem(keyName="minimumHPNotification", name="Show Notifications", description="Enables notifications when your HP gets below the threshold.", position=0, section="minimumHitpoints")
    default public boolean minimumHPNotification() {
        return true;
    }

    @ConfigItem(keyName="minimumHPThresholdValue", name="Threshold", description="The Minimum HP before triggering a alert.", position=1, section="minimumHitpoints")
    default public int minimumHPThresholdValue() {
        return 1;
    }

    @ConfigItem(keyName="showMinimumHPIcon", name="Show Icon", description="Toggles if the Hitpoints icon is drawn on the visual notification.", position=2, section="minimumHitpoints")
    default public boolean showMinimumHPIcon() {
        return true;
    }

    @ConfigItem(keyName="minimumHPAlertColor", name="Color", description="The color of the Hitpoints BELOW Threshold Notification.", position=3, section="minimumHitpoints")
    default public Color minimumHPAlertColor() {
        return new Color(221, 79, 1);
    }

    @ConfigItem(keyName="minimumHPEffectType", name="Effect", description="The type of effect for Hitpoints BELOW Threshold Notification.", position=4, section="minimumHitpoints")
    default public VisualNotificationEffectType minimumHPEffectType() {
        return VisualNotificationEffectType.FADE_IN_OUT;
    }

    @ConfigItem(keyName="minimumHPEffectSpeed", name="Speed", description="The speed of the notification effect, This does nothing if effect type is `SOLID`.", position=5, section="minimumHitpoints")
    default public VisualNotificationSpeed minimumHPEffectSpeed() {
        return VisualNotificationSpeed.DEFAULT;
    }

    @ConfigItem(keyName="maximumHPNotification", name="Show Notifications", description="Enables notifications when your HP gets above the threshold.", position=0, section="maximumHitpoints")
    default public boolean maximumHPNotification() {
        return true;
    }

    @ConfigItem(keyName="maximumHPThreshold", name="Threshold", description="The Maximum HP before triggering a alert.", position=1, section="maximumHitpoints")
    default public int maximumHPThresholdValue() {
        return 2;
    }

    @ConfigItem(keyName="showMaximumHPIcon", name="Show Icon", description="Toggles if the Hitpoints icon is drawn on the visual notification.", position=2, section="maximumHitpoints")
    default public boolean showMaximumHPIcon() {
        return true;
    }

    @ConfigItem(keyName="maximumHPAlertColor", name="Color", description="The color of the Hitpoints ABOVE Threshold Notification.", position=3, section="maximumHitpoints")
    default public Color maximumHPAlertColor() {
        return new Color(221, 79, 1);
    }

    @ConfigItem(keyName="maximumHPEffectType", name="Effect", description="The type of effect for Hitpoints ABOVE Threshold Notification.", position=4, section="maximumHitpoints")
    default public VisualNotificationEffectType maximumHPEffectType() {
        return VisualNotificationEffectType.FADE_IN_OUT;
    }

    @ConfigItem(keyName="maximumHPEffectSpeed", name="Speed", description="The speed of the notification effect, This does nothing if effect type is `SOLID`.", position=5, section="maximumHitpoints")
    default public VisualNotificationSpeed maximumHPEffectSpeed() {
        return VisualNotificationSpeed.DEFAULT;
    }

    @ConfigItem(keyName="drawrecurrentdamagelocation", name="Show Spawn Location", description="Toggles highlighting the tile where the Recurrent Damage Spawned.", position=0, section="recurrentDamagePowerup")
    default public boolean drawRecurrentDamageLocation() {
        return true;
    }

    @ConfigItem(keyName="recurrentdamagenotification", name="Recurrent Damage Notification", description="Toggles notifications when a Recurrent Damage Power-up is Spawned.", position=1, section="recurrentDamagePowerup")
    default public boolean recurrentDamageNotification() {
        return true;
    }

    @ConfigItem(keyName="recurrentdamageAlertColor", name="Color", description="The color of the Recurrent Damage Power-Up Notification.", position=2, section="recurrentDamagePowerup")
    default public Color recurrentDamageAlertColor() {
        return new Color(255, 0, 21);
    }

    @ConfigItem(keyName="recurrentDamageEffectType", name="Effect", description="The type of effect for Recurrent Damage Power-Up Notification.", position=3, section="recurrentDamagePowerup")
    default public VisualNotificationEffectType recurrentDamageEffectType() {
        return VisualNotificationEffectType.FADE_IN_OUT;
    }

    @ConfigItem(keyName="recurrentDamageEffectSpeed", name="Speed", description="The speed of the notification effect, This does nothing if effect type is `SOLID`.", position=4, section="recurrentDamagePowerup")
    default public VisualNotificationSpeed recurrentDamageEffectSpeed() {
        return VisualNotificationSpeed.DEFAULT;
    }

    @ConfigItem(keyName="drawzapperlocation", name="Show Spawn Location", description="Toggles highlighting the tile where the Zapper Spawned.", position=0, section="zapperPowerup")
    default public boolean drawZapperLocation() {
        return true;
    }

    @ConfigItem(keyName="zappernotification", name="Zapper Notification", description="Toggles notifications when a Zapper Power-up is Spawned.", position=1, section="zapperPowerup")
    default public boolean zapperNotification() {
        return true;
    }

    @ConfigItem(keyName="zapperAlertColor", name="Color", description="The color of the Zapper Power-Up Notification.", position=2, section="zapperPowerup")
    default public Color zapperAlertColor() {
        return new Color(161, 0, 255);
    }

    @ConfigItem(keyName="zapperEffectType", name="Effect", description="The type of effect for Zapper Power-Up Notification.", position=3, section="zapperPowerup")
    default public VisualNotificationEffectType zapperEffectType() {
        return VisualNotificationEffectType.FADE_IN_OUT;
    }

    @ConfigItem(keyName="zapperEffectSpeed", name="Speed", description="The speed of the notification effect, This does nothing if effect type is `SOLID`.", position=4, section="zapperPowerup")
    default public VisualNotificationSpeed zapperEffectSpeed() {
        return VisualNotificationSpeed.DEFAULT;
    }

    @ConfigItem(keyName="drawpowersurgelocation", name="Show Spawn Location", description="Toggles highlighting the tile where the Power Surge Spawned.", position=0, section="powerSurgePowerup")
    default public boolean drawPowerSurgeLocation() {
        return true;
    }

    @ConfigItem(keyName="powersurgenotification", name="Power Surge Notification", description="Toggles notifications when a Power Surge Power-up is Spawned.", position=1, section="powerSurgePowerup")
    default public boolean powerSurgeNotification() {
        return true;
    }

    @ConfigItem(keyName="powerSurgeAlertColor", name="Color", description="The color of the Power Surge Power-Up Notification.", position=2, section="powerSurgePowerup")
    default public Color powerSurgeAlertColor() {
        return new Color(255, 221, 0);
    }

    @ConfigItem(keyName="powerSurgeEffectType", name="Effect", description="The type of effect for Power Surge Power-Up Notification.", position=3, section="powerSurgePowerup")
    default public VisualNotificationEffectType powerSurgeEffectType() {
        return VisualNotificationEffectType.FADE_IN_OUT;
    }

    @ConfigItem(keyName="powerSurgeEffectSpeed", name="Speed", description="The speed of the notification effect, This does nothing if effect type is `SOLID`.", position=4, section="powerSurgePowerup")
    default public VisualNotificationSpeed powerSurgeEffectSpeed() {
        return VisualNotificationSpeed.DEFAULT;
    }

    @ConfigItem(keyName="ultimateforcelocation", name="Show Spawn Location", description="Toggles highlighting the tile where the Ultimate Force Spawned.", position=0, section="ultimateForcePowerup")
    default public boolean drawUltimateForceLocation() {
        return true;
    }

    @ConfigItem(keyName="ultimateforcenotification", name="Ultimate Force Notification", description="Toggles notifications when a Ultimate Force Power-up is Spawned.", position=1, section="ultimateForcePowerup")
    default public boolean ultimateForceNotification() {
        return true;
    }

    @ConfigItem(keyName="ultimateForceAlertColor", name="Color", description="The color of the Ultimate Force Power-Up Notification.", position=2, section="ultimateForcePowerup")
    default public Color ultimateForceAlertColor() {
        return new Color(255, 255, 255);
    }

    @ConfigItem(keyName="ultimateForceEffectType", name="Effect", description="The type of effect for Ultimate Force Power-Up Notification.", position=3, section="ultimateForcePowerup")
    default public VisualNotificationEffectType ultimateForceEffectType() {
        return VisualNotificationEffectType.FADE_IN_OUT;
    }

    @ConfigItem(keyName="ultimateForceEffectSpeed", name="Speed", description="The speed of the notification effect, This does nothing if effect type is `SOLID`.", position=4, section="ultimateForcePowerup")
    default public VisualNotificationSpeed ultimateForceEffectSpeed() {
        return VisualNotificationSpeed.DEFAULT;
    }

    @ConfigItem(keyName="overloadRunoutNotification", name="Warning Notification", description="Toggles notifications when your overload is about to run out.", position=0, section="overloads")
    default public boolean overloadRunoutNotification() {
        return true;
    }

    @Range(min=0, max=120)
    @ConfigItem(keyName="overloadRunoutTime", name="Warning Seconds", description="The length in seconds before your Overload runs out, to notify you.", position=1, section="overloads")
    default public int overloadRunoutTime() {
        return 20;
    }

    @ConfigItem(keyName="showOverloadIcon", name="Show Icon", description="Toggles if a Overload Potion icon is drawn on the visual notification.", position=2, section="overloads")
    default public boolean showOverloadIcon() {
        return true;
    }

    @ConfigItem(keyName="overloadRunOutColor", name="Warning Color", description="The color of the Overload Run-out Warning Notification.", position=3, section="overloads")
    default public Color overloadRunOutColor() {
        return new Color(93, 91, 91);
    }

    @ConfigItem(keyName="overloadRunOutEffectType", name="Warning Effect", description="The type of effect for Overload Run-out Warning Notification.", position=4, section="overloads")
    default public VisualNotificationEffectType overloadRunOutEffectType() {
        return VisualNotificationEffectType.FADE_IN_OUT;
    }

    @ConfigItem(keyName="overloadRunOutEffectSpeed", name="Warning Speed", description="The speed of the notification effect, This does nothing if effect type is `SOLID`.", position=5, section="overloads")
    default public VisualNotificationSpeed overloadRunOutEffectSpeed() {
        return VisualNotificationSpeed.DEFAULT;
    }

    @ConfigItem(keyName="overloadExpiredNotification", name="Expired Notification", description="Toggles notifications when your overload is has run out.", position=6, section="overloads")
    default public boolean overloadExpiredNotification() {
        return true;
    }

    @ConfigItem(keyName="overloadExpiredColor", name="Expired Color", description="The color of the Overload Expired Notification.", position=7, section="overloads")
    default public Color overloadExpiredColor() {
        return new Color(35, 35, 35);
    }

    @ConfigItem(keyName="overloadExpiredEffectType", name="Expired Effect", description="The type of effect for Overload Expired Notification.", position=8, section="overloads")
    default public VisualNotificationEffectType overloadExpiredEffectType() {
        return VisualNotificationEffectType.FADE_IN_OUT;
    }

    @ConfigItem(keyName="overloadExpiredEffectSpeed", name="Expired Speed", description="The speed of the notification effect, This does nothing if effect type is `SOLID`.", position=9, section="overloads")
    default public VisualNotificationSpeed overloadExpiredEffectSpeed() {
        return VisualNotificationSpeed.DEFAULT;
    }

    @ConfigItem(keyName="absorptionnotification", name="Absorption Notification", description="Toggles notifications when your absorption points gets below your threshold", position=0, section="absorption")
    default public boolean absorptionNotification() {
        return true;
    }

    @ConfigItem(keyName="absorptionthreshold", name="Minimum Threshold", description="The Minimum Absorption before triggering a alert.", position=1, section="absorption")
    default public int absorptionThreshold() {
        return 50;
    }

    @ConfigItem(keyName="showAbsorptionIcon", name="Show Icon", description="Toggles if a Absorption Potion icon is drawn on the visual notification.", position=2, section="absorption")
    default public boolean showAbsorptionIcon() {
        return true;
    }

    @ConfigItem(keyName="absorptionAlertColor", name="Color", description="The color of the Absorption BELOW Threshold Notification.", position=3, section="absorption")
    default public Color absorptionAlertColor() {
        return new Color(0, 179, 255);
    }

    @ConfigItem(keyName="absorptionEffectType", name="Effect", description="The type of effect for Absorption BELOW Threshold Notification.", position=4, section="absorption")
    default public VisualNotificationEffectType absorptionEffectType() {
        return VisualNotificationEffectType.FADE_IN_OUT;
    }

    @ConfigItem(keyName="absorptionEffectSpeed", name="Speed", description="The speed of the notification effect, This does nothing if effect type is `SOLID`.", position=5, section="absorption")
    default public VisualNotificationSpeed absorptionEffectSpeed() {
        return VisualNotificationSpeed.DEFAULT;
    }

    @ConfigItem(keyName="removeNMZOverlay", name="Override NMZ overlay", description="Removes the Nightmare Zone Point overlay.", position=0, section="paint")
    default public boolean removeNMZOverlay() {
        return true;
    }

    @ConfigItem(keyName="showPointsPerHour", name="Show Points Per Hour", description="Shows the Estimated Points Per Hour", position=1, section="paint")
    default public boolean showPointsPerHour() {
        return true;
    }

    @ConfigItem(keyName="showTotalPoints", name="Show Total Points Earned", description="Shows the total points you have earned.", position=2, section="paint")
    default public boolean showTotalPoints() {
        return true;
    }
}

