/*
 * Decompiled with CFR 0.152.
 */
package com.nexsplits;

import com.nexsplits.NexSplitsConfig;
import com.nexsplits.NexSplitsPlugin;
import com.nexsplits.config.KillTimerMode;
import java.awt.Color;
import java.awt.image.BufferedImage;
import net.runelite.api.Client;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxPriority;

public class NexTimerBox
extends InfoBox {
    private final NexSplitsConfig config;
    private final NexSplitsPlugin plugin;
    private final Client client;

    NexTimerBox(BufferedImage image, NexSplitsConfig config, NexSplitsPlugin plugin, Client client) {
        super(image, (Plugin)plugin);
        this.config = config;
        this.plugin = plugin;
        this.client = client;
        this.setPriority(InfoBoxPriority.LOW);
    }

    public String getText() {
        return this.plugin.isChickenDead() ? this.plugin.getTime(this.plugin.getP5Tick() - this.plugin.getStartTick()) : this.plugin.getTime(this.client.getTickCount() - this.plugin.getStartTick());
    }

    public Color getTextColor() {
        return this.plugin.isChickenDead() ? Color.GREEN : Color.WHITE;
    }

    public String getTooltip() {
        return this.plugin.getPhaseTimes();
    }

    public boolean render() {
        return (this.config.killTimer() == KillTimerMode.INFOBOX || this.config.killTimer() == KillTimerMode.BOTH) && this.plugin.inNexBossArea();
    }

    public NexSplitsConfig getConfig() {
        return this.config;
    }

    public NexSplitsPlugin getPlugin() {
        return this.plugin;
    }

    public Client getClient() {
        return this.client;
    }
}

