/*
 * Decompiled with CFR 0.152.
 */
package com.nexsplits;

import com.google.inject.Provides;
import com.nexsplits.NexDimmerOverlay;
import com.nexsplits.NexSplitsConfig;
import com.nexsplits.NexSplitsOverlay;
import com.nexsplits.NexTimerBox;
import com.nexsplits.config.CoughMode;
import com.nexsplits.config.KillTimerMode;
import com.nexsplits.config.PhaseNameTypeMode;
import com.nexsplits.config.TimeStyle;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import javax.inject.Inject;
import javax.inject.Singleton;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.OverheadTextChanged;
import net.runelite.client.RuneLite;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.ui.overlay.infobox.InfoBox;
import net.runelite.client.ui.overlay.infobox.InfoBoxManager;
import net.runelite.client.util.AsyncBufferedImage;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Nex Splits", description="Detailed time tracking for Nex", tags={"nex", "godwars", "dungeon", "gwd", "splits", "torva", "zaros", "zaryte", "ancient", "time", "timer"})
@Singleton
public class NexSplitsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(NexSplitsPlugin.class);
    @Inject
    private Client client;
    @Inject
    private NexSplitsConfig config;
    @Inject
    private NexSplitsOverlay overlay;
    @Inject
    private NexDimmerOverlay dimmer;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private InfoBoxManager infoBoxManager;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ChatMessageManager chatMessageManager;
    private static final int[] nexRegions = new int[]{11345, 11601, 11857};
    private final ArrayList<Integer> nexIds = new ArrayList<Integer>(Arrays.asList(11278, 11279, 11280, 11281, 11282));
    private boolean chickenDead = false;
    private int playerCount = 0;
    private NexTimerBox timerBox;
    private int splitTicks = 0;
    private String exportSplits = "";
    private static final String KC_MESSAGE = "Your Nex kill count is:";
    private int startTick = -1;
    private int p1Tick = -1;
    private int p1Boss = -1;
    private int p2Tick = -1;
    private int p2Boss = -1;
    private int p3Tick = -1;
    private int p3Boss = -1;
    private int p4Tick = -1;
    private int p4Boss = -1;
    private int p5Tick = -1;
    private static final File TIMES_DIR = new File(RuneLite.RUNELITE_DIR.getPath() + File.separator + "nex-splits");

    @Provides
    NexSplitsConfig provideConfig(ConfigManager configManager) {
        return (NexSplitsConfig)configManager.getConfig(NexSplitsConfig.class);
    }

    protected void startUp() {
        this.reset();
        this.resetTimes();
        this.overlayManager.add((Overlay)this.overlay);
        this.overlayManager.add((Overlay)this.dimmer);
        if (!TIMES_DIR.exists()) {
            TIMES_DIR.mkdirs();
        }
    }

    protected void shutDown() {
        this.reset();
        this.resetTimes();
        this.overlayManager.remove((Overlay)this.overlay);
        this.overlayManager.remove((Overlay)this.dimmer);
        this.infoBoxManager.removeInfoBox((InfoBox)this.timerBox);
    }

    private void reset() {
        this.chickenDead = false;
        this.playerCount = 0;
        this.infoBoxManager.removeInfoBox((InfoBox)this.timerBox);
    }

    private void resetTimes() {
        this.startTick = -1;
        this.p1Tick = -1;
        this.p1Boss = -1;
        this.p2Tick = -1;
        this.p2Boss = -1;
        this.p3Tick = -1;
        this.p3Boss = -1;
        this.p4Tick = -1;
        this.p4Boss = -1;
        this.p5Tick = -1;
        this.splitTicks = 0;
        this.exportSplits = "";
    }

    @Subscribe
    private void onConfigChanged(ConfigChanged e) {
        if (e.getGroup().equals("nexSplits") && e.getKey().equals("killTimer")) {
            if ((this.config.killTimer() == KillTimerMode.INFOBOX || this.config.killTimer() == KillTimerMode.BOTH) && this.inNexBossArea() && this.startTick > -1) {
                this.infoBoxManager.removeInfoBox((InfoBox)this.timerBox);
                AsyncBufferedImage image = this.itemManager.getImage(26348);
                this.timerBox = new NexTimerBox((BufferedImage)image, this.config, this, this.client);
                this.infoBoxManager.addInfoBox((InfoBox)this.timerBox);
            } else {
                this.infoBoxManager.removeInfoBox((InfoBox)this.timerBox);
            }
        }
    }

    @Subscribe
    private void onGameStateChanged(GameStateChanged e) {
        if (this.client.getLocalPlayer() != null && !this.inNexBossArea()) {
            this.resetTimes();
            this.infoBoxManager.removeInfoBox((InfoBox)this.timerBox);
        }
    }

    @Subscribe(priority=-10.0f)
    public void onOverheadTextChanged(OverheadTextChanged e) {
        if (this.config.replaceCough() != CoughMode.OFF && this.inNexBossArea()) {
            if (e.getActor() instanceof Player) {
                String msg = "";
                if (e.getActor().getOverheadText().equalsIgnoreCase("*Cough*")) {
                    switch (this.config.replaceCough()) {
                        case OLM: {
                            msg = new Random().nextInt(2) == 0 ? "Burn with me!" : "I will burn with you!";
                            break;
                        }
                        case CAT: {
                            msg = "*Meow*";
                        }
                    }
                    e.getActor().setOverheadText(msg);
                }
            } else if (e.getActor().getName() != null && e.getActor().getName().equals("Nex") && e.getOverheadText().contains("Let the virus flow through you!")) {
                e.getActor().setOverheadText(this.config.replaceCough() == CoughMode.OLM ? "Let the burn flow through you!" : "Let the meow flow through you!");
            }
        }
    }

    @Subscribe
    private void onChatMessage(ChatMessage e) throws Exception {
        String text = e.getMessage();
        String strippedText = Text.removeTags((String)e.getMessage());
        if (e.getType() == ChatMessageType.GAMEMESSAGE) {
            if (strippedText.startsWith(KC_MESSAGE)) {
                String trimKcMsg = strippedText.substring(text.indexOf(":")).replace(".", "");
                if (strippedText.startsWith(KC_MESSAGE)) {
                    this.exportSplits = this.exportSplits + "Nex KC" + trimKcMsg + " | Players: " + this.playerCount + "<br>";
                    this.chickenDead = true;
                }
            } else if (strippedText.startsWith("Fight duration:")) {
                this.exportSplits = this.exportSplits + strippedText;
                if (this.config.timeExporter()) {
                    this.exportTimes();
                }
            } else if (text.contains("Nex: <col=9090ff>") || text.contains("Nex: <col=0000ff>")) {
                if ((text.contains("Fumus") || text.contains("Umbra") || text.contains("Cruor") || text.contains("Glacies")) && text.contains(", don't fail me!")) {
                    if (text.contains("Fumus")) {
                        this.splitTicks = this.p1Boss = this.client.getTickCount();
                        if (this.config.phaseChatMessages() && this.config.showMinionSplit()) {
                            String phaseText = this.config.phaseNameType() == PhaseNameTypeMode.NUMBER ? "P1" : "Smoke Phase";
                            this.printTime(phaseText, this.getTime(this.p1Boss - this.startTick), false);
                            this.exportSplits = this.exportSplits + phaseText + " Boss: " + this.getTime(this.p1Boss - this.startTick) + "<br>";
                        }
                    } else if (text.contains("Umbra")) {
                        this.splitTicks = this.p2Boss = this.client.getTickCount();
                        if (this.config.phaseChatMessages() && this.config.showMinionSplit()) {
                            String phaseText = this.config.phaseNameType() == PhaseNameTypeMode.NUMBER ? "P2" : "Shadow Phase";
                            this.printTime(phaseText, this.getTime(this.p2Boss - this.p1Tick), false);
                            this.exportSplits = this.exportSplits + phaseText + " Boss: " + this.getTime(this.p2Boss - this.p1Tick) + "<br>";
                        }
                    } else if (text.contains("Cruor")) {
                        this.splitTicks = this.p3Boss = this.client.getTickCount();
                        if (this.config.phaseChatMessages() && this.config.showMinionSplit()) {
                            String phaseText = this.config.phaseNameType() == PhaseNameTypeMode.NUMBER ? "P3" : "Blood Phase";
                            this.printTime(phaseText, this.getTime(this.p3Boss - this.p2Tick), false);
                            this.exportSplits = this.exportSplits + phaseText + " Boss: " + this.getTime(this.p3Boss - this.p2Tick) + "<br>";
                        }
                    } else if (text.contains("Glacies")) {
                        this.splitTicks = this.p4Boss = this.client.getTickCount();
                        if (this.config.phaseChatMessages() && this.config.showMinionSplit()) {
                            String phaseText = this.config.phaseNameType() == PhaseNameTypeMode.NUMBER ? "P4" : "Ice Phase";
                            this.printTime(phaseText, this.getTime(this.p4Boss - this.p3Tick), false);
                            this.exportSplits = this.exportSplits + phaseText + " Boss: " + this.getTime(this.p4Boss - this.p3Tick) + "<br>";
                        }
                    }
                } else if (text.contains("Fill my soul with smoke!")) {
                    this.resetTimes();
                    this.chickenDead = false;
                    this.playerCount = this.client.getPlayers().size();
                    if (this.startTick == -1) {
                        this.splitTicks = this.startTick = this.client.getTickCount();
                        if (this.config.killTimer() == KillTimerMode.INFOBOX || this.config.killTimer() == KillTimerMode.BOTH) {
                            this.infoBoxManager.removeInfoBox((InfoBox)this.timerBox);
                            AsyncBufferedImage image = this.itemManager.getImage(26348);
                            this.timerBox = new NexTimerBox((BufferedImage)image, this.config, this, this.client);
                            this.infoBoxManager.addInfoBox((InfoBox)this.timerBox);
                        }
                    }
                } else if (text.contains("Darken my shadow!")) {
                    this.splitTicks = this.p1Tick = this.client.getTickCount();
                    if (this.config.phaseChatMessages()) {
                        String phaseText = this.config.phaseNameType() == PhaseNameTypeMode.NUMBER ? "P1" : "Smoke Phase";
                        this.printTime(phaseText, this.getTime(this.p1Tick - this.startTick), true);
                        this.exportSplits = this.exportSplits + phaseText + ": " + this.getTime(this.p1Tick - this.startTick) + "<br>";
                    }
                } else if (text.contains("Flood my lungs with blood!")) {
                    this.splitTicks = this.p2Tick = this.client.getTickCount();
                    if (this.config.phaseChatMessages()) {
                        String phaseText = this.config.phaseNameType() == PhaseNameTypeMode.NUMBER ? "P2" : "Shadow Phase";
                        this.printTime(phaseText, this.getTime(this.p2Tick - this.p1Tick), true);
                        this.exportSplits = this.exportSplits + phaseText + ": " + this.getTime(this.p2Tick - this.p1Tick) + "<br>";
                    }
                } else if (text.contains("Infuse me with the power of ice!")) {
                    this.splitTicks = this.p3Tick = this.client.getTickCount();
                    if (this.config.phaseChatMessages()) {
                        String phaseText = this.config.phaseNameType() == PhaseNameTypeMode.NUMBER ? "P3" : "Blood Phase";
                        this.printTime(phaseText, this.getTime(this.p3Tick - this.p2Tick), true);
                        this.exportSplits = this.exportSplits + phaseText + ": " + this.getTime(this.p3Tick - this.p2Tick) + "<br>";
                    }
                } else if (text.contains("NOW, THE POWER OF ZAROS!")) {
                    this.splitTicks = this.p4Tick = this.client.getTickCount();
                    if (this.config.phaseChatMessages()) {
                        String phaseText = this.config.phaseNameType() == PhaseNameTypeMode.NUMBER ? "P4" : "Ice Phase";
                        this.printTime(phaseText, this.getTime(this.p4Tick - this.p3Tick), true);
                        this.exportSplits = this.exportSplits + phaseText + ": " + this.getTime(this.p4Tick - this.p3Tick) + "<br>";
                    }
                } else if (text.contains("Taste my wrath!")) {
                    this.splitTicks = this.p5Tick = this.client.getTickCount();
                    if (this.config.phaseChatMessages()) {
                        String phaseText = this.config.phaseNameType() == PhaseNameTypeMode.NUMBER ? "P5" : "Zaros Phase";
                        this.printTime(phaseText, this.getTime(this.p5Tick - this.p4Tick), true);
                        this.exportSplits = this.exportSplits + phaseText + ": " + this.getTime(this.p5Tick - this.p4Tick) + "<br>";
                    }
                }
            }
        }
    }

    private void printTime(String phase, String time, boolean isPhase) {
        ChatMessageBuilder chatMessageBuilder = isPhase ? new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Nex " + phase + " Complete! Duration: ").append(ChatColorType.HIGHLIGHT).append(time) : new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Nex " + phase + " Boss Complete! Duration: ").append(ChatColorType.HIGHLIGHT).append(time);
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(chatMessageBuilder.build()).build());
    }

    public String getPhaseTimes() {
        StringBuilder sb = new StringBuilder();
        Object bossText = "";
        if (this.p1Tick > -1) {
            String phaseText;
            String string = phaseText = this.config.phaseNameType() == PhaseNameTypeMode.NUMBER ? "P1: " : "Smoke: ";
            if (this.config.showMinionSplit() && this.p1Boss > -1) {
                bossText = " (" + this.getTime(this.p1Boss - this.startTick) + ")";
            }
            sb.append(phaseText).append(this.getTime(this.p1Tick - this.startTick)).append((String)bossText).append("</br>");
            if (this.p2Tick > -1) {
                String string2 = phaseText = this.config.phaseNameType() == PhaseNameTypeMode.NUMBER ? "P2: " : "Shadow: ";
                if (this.config.showMinionSplit() && this.p2Boss > -1) {
                    bossText = " (" + this.getTime(this.p2Boss - this.p1Tick) + ")";
                }
                sb.append(phaseText).append(this.getTime(this.p2Tick - this.p1Tick)).append((String)bossText).append("</br>");
                if (this.p3Tick > -1) {
                    String string3 = phaseText = this.config.phaseNameType() == PhaseNameTypeMode.NUMBER ? "P3: " : "Blood: ";
                    if (this.config.showMinionSplit() && this.p3Boss > -1) {
                        bossText = " (" + this.getTime(this.p3Boss - this.p2Tick) + ")";
                    }
                    sb.append(phaseText).append(this.getTime(this.p3Tick - this.p2Tick)).append((String)bossText).append("</br>");
                    if (this.p4Tick > -1) {
                        String string4 = phaseText = this.config.phaseNameType() == PhaseNameTypeMode.NUMBER ? "P4: " : "Ice: ";
                        if (this.config.showMinionSplit() && this.p4Boss > -1) {
                            bossText = " (" + this.getTime(this.p4Boss - this.p3Tick) + ")";
                        }
                        sb.append(phaseText).append(this.getTime(this.p4Tick - this.p3Tick)).append((String)bossText).append("</br>");
                        if (this.p5Tick > -1) {
                            phaseText = this.config.phaseNameType() == PhaseNameTypeMode.NUMBER ? "P5: " : "Zaros: ";
                            sb.append(phaseText).append(this.getTime(this.p5Tick - this.p4Tick)).append("</br>");
                        }
                    }
                }
            }
        }
        return sb.toString();
    }

    public String getTime(int ticks) {
        boolean ingame_setting;
        TimeStyle setting = this.config.timerStyle();
        boolean bl = ingame_setting = this.client.getVarbitValue(11866) == 1;
        if (setting == TimeStyle.TICKS || setting == TimeStyle.VARBIT && ingame_setting) {
            return NexSplitsPlugin.to_mmss_precise(ticks);
        }
        return NexSplitsPlugin.to_mmss(ticks);
    }

    public static String to_mmss(int ticks) {
        int m;
        int s = (ticks - (m = ticks / 100) * 100) * 6 / 10;
        return m + (s < 10 ? ":0" : ":") + s;
    }

    public static String to_mmss_precise(int ticks) {
        int min = ticks / 100;
        int tmp = (ticks - min * 100) * 6;
        int sec = tmp / 10;
        int sec_tenth = tmp - sec * 10;
        return min + (sec < 10 ? ":0" : ":") + sec + "." + sec_tenth;
    }

    private void exportTimes() throws Exception {
        String fileName = TIMES_DIR + "\\" + this.client.getLocalPlayer().getName() + "_NexTimes.txt";
        FileWriter writer = new FileWriter(fileName, true);
        try {
            writer.write(this.exportSplits.replace("<br>", "\r\n") + "\r\n------------------------------------------------------------------------------------------------\r\n------------------------------------------------------------------------------------------------\r\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        writer.close();
    }

    public boolean inNexRegion() {
        LocalPoint player = this.client.getLocalPlayer().getLocalLocation();
        return this.client.isInInstancedRegion() ? Arrays.stream(nexRegions).anyMatch(r -> WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)player).getRegionID() == r) : Arrays.stream(nexRegions).anyMatch(r -> WorldPoint.fromLocal((Client)this.client, (LocalPoint)player).getRegionID() == r);
    }

    public boolean inNexBossArea() {
        return this.client.isInInstancedRegion() && this.inNexRegion();
    }

    public boolean isChickenDead() {
        return this.chickenDead;
    }

    public int getPlayerCount() {
        return this.playerCount;
    }

    public int getSplitTicks() {
        return this.splitTicks;
    }

    public String getExportSplits() {
        return this.exportSplits;
    }

    public int getStartTick() {
        return this.startTick;
    }

    public int getP1Tick() {
        return this.p1Tick;
    }

    public int getP1Boss() {
        return this.p1Boss;
    }

    public int getP2Tick() {
        return this.p2Tick;
    }

    public int getP2Boss() {
        return this.p2Boss;
    }

    public int getP3Tick() {
        return this.p3Tick;
    }

    public int getP3Boss() {
        return this.p3Boss;
    }

    public int getP4Tick() {
        return this.p4Tick;
    }

    public int getP4Boss() {
        return this.p4Boss;
    }

    public int getP5Tick() {
        return this.p5Tick;
    }

    public static File getTIMES_DIR() {
        return TIMES_DIR;
    }
}

