/*
 * Decompiled with CFR 0.152.
 */
package com.nexsplits;

import com.nexsplits.NexSplitsConfig;
import com.nexsplits.NexSplitsPlugin;
import com.nexsplits.config.CustomOverlayInfo;
import com.nexsplits.config.KillTimerMode;
import com.nexsplits.config.PhaseNameTypeMode;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.components.ComponentConstants;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.tooltip.Tooltip;
import net.runelite.client.ui.overlay.tooltip.TooltipManager;

public class NexSplitsOverlay
extends OverlayPanel {
    private final NexSplitsPlugin plugin;
    private final NexSplitsConfig config;
    private final Client client;
    private final TooltipManager tooltipManager;

    @Inject
    public NexSplitsOverlay(NexSplitsPlugin plugin, NexSplitsConfig config, Client client, TooltipManager tooltipManager) {
        super((Plugin)plugin);
        this.plugin = plugin;
        this.config = config;
        this.client = client;
        this.tooltipManager = tooltipManager;
    }

    public Dimension render(Graphics2D graphics) {
        this.panelComponent.getChildren().clear();
        switch (this.config.fontType()) {
            case SMALL: {
                graphics.setFont(FontManager.getRunescapeSmallFont());
                break;
            }
            case REGULAR: {
                graphics.setFont(FontManager.getRunescapeFont());
                break;
            }
            case BOLD: {
                graphics.setFont(FontManager.getRunescapeBoldFont());
                break;
            }
            case CUSTOM: {
                if (this.config.fontName().isEmpty()) break;
                graphics.setFont(new Font(this.config.fontName(), this.config.fontWeight().getWeight(), this.config.fontSize()));
            }
        }
        if ((this.config.killTimer() == KillTimerMode.OVERLAY || this.config.killTimer() == KillTimerMode.BOTH) && this.plugin.inNexBossArea() && this.plugin.getStartTick() > -1) {
            Rectangle bounds;
            if (!this.config.overlayInfo().isEmpty()) {
                if (this.config.overlayInfo().contains((Object)CustomOverlayInfo.PLAYERS)) {
                    this.panelComponent.getChildren().add(LineComponent.builder().left("Players:").right(String.valueOf(this.plugin.getPlayerCount())).build());
                }
                if (this.config.overlayInfo().contains((Object)CustomOverlayInfo.ELAPSED)) {
                    this.panelComponent.getChildren().add(LineComponent.builder().left("Time:").rightColor(this.plugin.isChickenDead() ? Color.GREEN : Color.WHITE).right(this.plugin.isChickenDead() ? this.plugin.getTime(this.plugin.getP5Tick() - this.plugin.getStartTick()) : this.plugin.getTime(this.client.getTickCount() - this.plugin.getStartTick())).build());
                }
                if (this.config.overlayInfo().contains((Object)CustomOverlayInfo.PHASE) && this.plugin.getP1Tick() > -1) {
                    Object bossText;
                    String phaseText;
                    if (this.plugin.getP1Tick() != -1) {
                        phaseText = this.config.phaseNameType() == PhaseNameTypeMode.NUMBER ? "P1: " : "Smoke: ";
                        bossText = "";
                        if (this.config.showMinionSplit() && this.plugin.getP1Boss() > -1) {
                            bossText = " (" + this.plugin.getTime(this.plugin.getP1Boss() - this.plugin.getStartTick()) + ")";
                        }
                        this.panelComponent.getChildren().add(LineComponent.builder().left(phaseText).right(this.plugin.getTime(this.plugin.getP1Tick() - this.plugin.getStartTick()) + (String)bossText).build());
                    }
                    if (this.plugin.getP2Tick() != -1) {
                        phaseText = this.config.phaseNameType() == PhaseNameTypeMode.NUMBER ? "P2: " : "Shadow: ";
                        bossText = "";
                        if (this.config.showMinionSplit() && this.plugin.getP2Boss() > -1) {
                            bossText = " (" + this.plugin.getTime(this.plugin.getP2Boss() - this.plugin.getP1Tick()) + ")";
                        }
                        this.panelComponent.getChildren().add(LineComponent.builder().left(phaseText).right(this.plugin.getTime(this.plugin.getP2Tick() - this.plugin.getP1Tick()) + (String)bossText).build());
                    }
                    if (this.plugin.getP3Tick() != -1) {
                        phaseText = this.config.phaseNameType() == PhaseNameTypeMode.NUMBER ? "P3: " : "Blood: ";
                        bossText = "";
                        if (this.config.showMinionSplit() && this.plugin.getP3Boss() > -1) {
                            bossText = " (" + this.plugin.getTime(this.plugin.getP3Boss() - this.plugin.getP2Tick()) + ")";
                        }
                        this.panelComponent.getChildren().add(LineComponent.builder().left(phaseText).right(this.plugin.getTime(this.plugin.getP3Tick() - this.plugin.getP2Tick()) + (String)bossText).build());
                    }
                    if (this.plugin.getP4Tick() != -1) {
                        phaseText = this.config.phaseNameType() == PhaseNameTypeMode.NUMBER ? "P4: " : "Ice: ";
                        bossText = "";
                        if (this.config.showMinionSplit() && this.plugin.getP4Boss() > -1) {
                            bossText = " (" + this.plugin.getTime(this.plugin.getP4Boss() - this.plugin.getP3Tick()) + ")";
                        }
                        this.panelComponent.getChildren().add(LineComponent.builder().left(phaseText).right(this.plugin.getTime(this.plugin.getP4Tick() - this.plugin.getP3Tick()) + (String)bossText).build());
                    }
                    if (this.plugin.getP5Tick() != -1) {
                        phaseText = this.config.phaseNameType() == PhaseNameTypeMode.NUMBER ? "P5: " : "Zaros: ";
                        this.panelComponent.getChildren().add(LineComponent.builder().left(phaseText).right(this.plugin.getTime(this.plugin.getP5Tick() - this.plugin.getP4Tick())).build());
                    }
                }
                if (this.config.overlayInfo().contains((Object)CustomOverlayInfo.CURRENT) && !this.plugin.isChickenDead() && this.plugin.getSplitTicks() > -1) {
                    this.panelComponent.getChildren().add(LineComponent.builder().left("Current Split:").rightColor(Color.WHITE).right(this.plugin.getTime(this.client.getTickCount() - this.plugin.getSplitTicks())).build());
                }
            }
            if ((bounds = this.getBounds()).getX() > 0.0) {
                boolean timeEnabled = this.config.overlayInfo().contains((Object)CustomOverlayInfo.PHASE) || this.config.overlayInfo().contains((Object)CustomOverlayInfo.CURRENT) || this.config.overlayInfo().contains((Object)CustomOverlayInfo.ELAPSED);
                Point mousePosition = this.client.getMouseCanvasPosition();
                if (bounds.contains(mousePosition.getX(), mousePosition.getY()) && timeEnabled && this.plugin.getStartTick() != -1) {
                    this.tooltipManager.add(new Tooltip(this.plugin.getPhaseTimes()));
                }
            }
        }
        switch (this.config.backgroundStyle()) {
            case HIDE: {
                this.panelComponent.setBackgroundColor(null);
                break;
            }
            case STANDARD: {
                this.panelComponent.setBackgroundColor(ComponentConstants.STANDARD_BACKGROUND_COLOR);
                break;
            }
            case CUSTOM: {
                this.panelComponent.setBackgroundColor(this.config.backgroundColor());
            }
        }
        return super.render(graphics);
    }
}

