/*
 * Decompiled with CFR 0.152.
 */
package com.nexsplits;

import com.nexsplits.config.BackgroundMode;
import com.nexsplits.config.CoughMode;
import com.nexsplits.config.CustomOverlayInfo;
import com.nexsplits.config.FontType;
import com.nexsplits.config.FontWeight;
import com.nexsplits.config.KillTimerMode;
import com.nexsplits.config.PhaseNameTypeMode;
import com.nexsplits.config.TimeStyle;
import java.awt.Color;
import java.util.Collections;
import java.util.Set;
import net.runelite.client.config.Alpha;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.Range;

@ConfigGroup(value="nexSplits")
public interface NexSplitsConfig
extends Config {
    public static final String GROUP = "nexSplits";
    @ConfigSection(name="Timer", description="Configuration for Kill/Phase Timers", position=0, closedByDefault=true)
    public static final String timerSection = "Timer";
    @ConfigSection(name="Font", description="Configuration for Kill/Phase Timer Font", position=1, closedByDefault=true)
    public static final String fontSection = "Font";

    @ConfigItem(keyName="timerStyle", name="Timer Style", description="Changes how the time is displayed", position=0, section="Timer")
    default public TimeStyle timerStyle() {
        return TimeStyle.VARBIT;
    }

    @ConfigItem(keyName="killTimer", name="Kill Timer", description="Display either an infobox or panel with kill/phase times", position=1, section="Timer")
    default public KillTimerMode killTimer() {
        return KillTimerMode.OFF;
    }

    @ConfigItem(keyName="overlayInfo", name="Display Options", description="Options that can be displayed in the custom overlay", position=2, section="Timer")
    default public Set<CustomOverlayInfo> overlayInfo() {
        return Collections.emptySet();
    }

    @ConfigItem(keyName="phaseNameType", name="Phase Name Type", description="Display phases in timers and messages as either numbers(P1, P2, P3) or name(Smoke, shadow, blood)", position=3, section="Timer")
    default public PhaseNameTypeMode phaseNameType() {
        return PhaseNameTypeMode.NUMBER;
    }

    @ConfigItem(keyName="phaseChatMessages", name="Phase Chat Message", description="Puts message in chatbox for each phase", position=4, section="Timer")
    default public boolean phaseChatMessages() {
        return true;
    }

    @ConfigItem(keyName="showMinionSplit", name="Show Minion Split", description="Shows boss and minion times for each phase", position=5, section="Timer")
    default public boolean showMinionSplit() {
        return false;
    }

    @ConfigItem(name="Time Exporter", keyName="timeExporter", description="Exports Nex times to .txt files in .runelite/nex-splits", position=6, section="Timer")
    default public boolean timeExporter() {
        return false;
    }

    @ConfigItem(name="Font Type", keyName="fontType", description="", position=0, section="Font")
    default public FontType fontType() {
        return FontType.REGULAR;
    }

    @ConfigItem(name="Custom Font Name", keyName="fontName", description="Custom font override", position=1, section="Font")
    default public String fontName() {
        return "";
    }

    @ConfigItem(name="Custom Font Size", keyName="fontsSize", description="", position=2, section="Font")
    default public int fontSize() {
        return 11;
    }

    @ConfigItem(name="Custom Weight", keyName="fontWeight", description="Sets the custom font weight", position=3, section="Font")
    default public FontWeight fontWeight() {
        return FontWeight.PLAIN;
    }

    @ConfigItem(name="Background Style", keyName="backgroundStyle", description="Sets the background to the style you select", position=4, section="Font")
    default public BackgroundMode backgroundStyle() {
        return BackgroundMode.STANDARD;
    }

    @Alpha
    @ConfigItem(name="Background Color", keyName="backgroundColor", description="Sets the overlay color on the custom setting", position=5, section="Font")
    default public Color backgroundColor() {
        return new Color(23, 23, 23, 156);
    }

    @ConfigItem(keyName="replaceCough", name="Replace Cough", description="Replaces *Cough* during smoke phase", position=96)
    default public CoughMode replaceCough() {
        return CoughMode.OFF;
    }

    @Range(min=0, max=255)
    @ConfigItem(keyName="nexDimmer", name="Nex Region Dimmer", description="Saves your eyes while hard grinding. Does nothing if 0", position=97)
    default public int nexDimmer() {
        return 0;
    }
}

