/*
 * Decompiled with CFR 0.152.
 */
package com.nexsplits;

import com.nexsplits.NexSplitsConfig;
import com.nexsplits.NexSplitsPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;

public class NexDimmerOverlay
extends Overlay {
    private final NexSplitsPlugin plugin;
    private final NexSplitsConfig config;
    private final Client client;

    @Inject
    public NexDimmerOverlay(NexSplitsPlugin plugin, NexSplitsConfig config, Client client) {
        super((Plugin)plugin);
        this.plugin = plugin;
        this.config = config;
        this.client = client;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.LOW);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D graphics) {
        if (this.plugin.inNexRegion() && this.config.nexDimmer() > 0) {
            this.dimmerOverlay(graphics, new Color(0, 0, 0, this.config.nexDimmer()), this.client.getCanvas().getBounds());
        }
        return null;
    }

    private void dimmerOverlay(Graphics2D graphics, Color color, Shape shape) {
        graphics.setColor(color);
        graphics.fill(shape);
    }
}

