/*
 * Decompiled with CFR 0.152.
 */
package dekvall.bankdiff;

import com.google.inject.Inject;
import dekvall.bankdiff.BankDiffConfig;
import dekvall.bankdiff.BankDiffPlugin;
import java.awt.Color;
import java.awt.Graphics2D;
import net.runelite.api.Point;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.api.widgets.WidgetItem;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.overlay.WidgetItemOverlay;

public class NegativeOneItemOverlay
extends WidgetItemOverlay {
    private final BankDiffPlugin plugin;
    private final BankDiffConfig config;

    @Inject
    NegativeOneItemOverlay(BankDiffPlugin plugin, BankDiffConfig config) {
        this.plugin = plugin;
        this.config = config;
        this.showOnBank();
    }

    public void renderItemOverlay(Graphics2D g, int itemId, WidgetItem itemWidget) {
        if (!this.config.diffViewToggled() || !this.plugin.getNegativeOneCounts().contains(itemId) || itemWidget.getWidget().getParentId() != WidgetInfo.BANK_ITEM_CONTAINER.getId()) {
            return;
        }
        g.setFont(FontManager.getRunescapeSmallFont());
        Point location = itemWidget.getCanvasLocation();
        g.setColor(Color.BLACK);
        g.drawString("-1", location.getX() + 1, location.getY() + 11);
        g.setColor(Color.YELLOW);
        g.drawString("-1", location.getX(), location.getY() + 10);
    }
}

