/*
 * Decompiled with CFR 0.152.
 */
package dekvall.bankdiff;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Provides;
import dekvall.bankdiff.BankDiffConfig;
import dekvall.bankdiff.NegativeOneItemOverlay;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.MenuAction;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Bank Diff")
public class BankDiffPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(BankDiffPlugin.class);
    static final String CONFIG_GROUP = "bankdiff";
    private static final Gson gson = new Gson();
    private static final int BANKSPACE_ITEM = 6512;
    private static final int MAX_BANK_SLOTS = 816;
    @Inject
    private Client client;
    @Inject
    private BankDiffConfig config;
    @Inject
    private ItemManager itemManager;
    @Inject
    private ConfigManager configManager;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private NegativeOneItemOverlay negativeOneItemOverlay;
    private final Map<Integer, Integer> snapshot = new HashMap<Integer, Integer>();
    private final Set<Integer> negativeOneCounts = new HashSet<Integer>();
    private static final String CREATE_SNAPSHOT = "Take diff snapshot";
    private static final String TOGGLE_VIEW = "Toggle diff view";

    protected void startUp() throws Exception {
        log.info("Bank Diff started!");
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            this.grabSnapshot();
        }
        this.overlayManager.add((Overlay)this.negativeOneItemOverlay);
    }

    protected void shutDown() throws Exception {
        this.snapshot.clear();
        this.overlayManager.remove((Overlay)this.negativeOneItemOverlay);
        log.info("Bank Diff stopped!");
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGGING_IN) {
            this.grabSnapshot();
        } else if (event.getGameState() == GameState.LOGIN_SCREEN) {
            this.snapshot.clear();
        }
    }

    private void grabSnapshot() {
        String json = (String)this.configManager.getConfiguration(CONFIG_GROUP, this.getConfigKey(), String.class);
        Map fromConfig = (Map)gson.fromJson(json, new TypeToken<Map<Integer, Integer>>(){}.getType());
        this.snapshot.clear();
        if (fromConfig != null) {
            this.snapshot.putAll(fromConfig);
        } else {
            this.config.diffViewToggled(false);
        }
    }

    @Subscribe
    public void onMenuEntryAdded(MenuEntryAdded event) {
        if (event.getType() != MenuAction.CC_OP.getId() || !event.getOption().equals("Show menu") || event.getActionParam1() >> 16 != 12) {
            return;
        }
        int place = 1;
        if (!this.snapshot.isEmpty()) {
            this.createEntry(TOGGLE_VIEW, event, place++);
        }
        if (!this.config.diffViewToggled()) {
            this.createEntry(CREATE_SNAPSHOT, event, place);
        }
    }

    private void createEntry(String option, MenuEntryAdded event, int place) {
        this.client.createMenuEntry(-place).setOption(option).setTarget("").setType(MenuAction.RUNELITE).setIdentifier(event.getIdentifier()).setParam0(event.getActionParam0()).setParam1(event.getActionParam1());
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        if (event.getMenuAction() != MenuAction.RUNELITE || event.getWidgetId() >> 16 != 12 || !event.getMenuOption().equals(CREATE_SNAPSHOT) && !event.getMenuOption().equals(TOGGLE_VIEW)) {
            return;
        }
        if (event.getMenuOption().equals(CREATE_SNAPSHOT)) {
            ItemContainer bank = this.client.getItemContainer(InventoryID.BANK);
            this.snapshot.clear();
            for (Item item : bank.getItems()) {
                int id = this.itemManager.canonicalize(item.getId());
                Integer current = this.snapshot.getOrDefault(id, 0);
                this.snapshot.put(item.getId(), item.getQuantity() + current);
            }
            this.configManager.setConfiguration(CONFIG_GROUP, this.getConfigKey(), gson.toJson(this.snapshot));
        } else if (event.getMenuOption().equals(TOGGLE_VIEW)) {
            this.config.diffViewToggled(!this.config.diffViewToggled());
            this.layoutBank();
        }
    }

    private String getConfigKey() {
        return this.client.getUsername() + ".snapshot";
    }

    private void diffAgainstSnapshot() {
        Widget bankItems = this.client.getWidget(WidgetInfo.BANK_ITEM_CONTAINER);
        this.negativeOneCounts.clear();
        for (Widget widget : bankItems.getDynamicChildren()) {
            if (widget.getIndex() > 815) {
                return;
            }
            if (widget.getItemId() == 6512) continue;
            int id = this.itemManager.canonicalize(widget.getItemId());
            int origQuantity = this.snapshot.getOrDefault(id, 0);
            int newQuantity = widget.getItemQuantity();
            int diff = newQuantity - origQuantity;
            if (diff == 0) {
                widget.setHidden(true);
            } else {
                widget.setItemId(id);
                widget.setItemQuantity(diff);
                if (this.config.restoreOpacity()) {
                    widget.setOpacity(0);
                }
            }
            if (diff != -1) continue;
            this.negativeOneCounts.add(id);
        }
    }

    public void layoutBank() {
        Widget bankContainer = this.client.getWidget(WidgetInfo.BANK_ITEM_CONTAINER);
        if (bankContainer == null || bankContainer.isHidden()) {
            return;
        }
        Object[] scriptArgs = bankContainer.getOnInvTransmitListener();
        if (scriptArgs == null) {
            return;
        }
        this.client.runScript(scriptArgs);
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired event) {
        if (event.getScriptId() == 277 && this.config.diffViewToggled()) {
            this.diffAgainstSnapshot();
        }
    }

    @Provides
    BankDiffConfig provideConfig(ConfigManager configManager) {
        return (BankDiffConfig)configManager.getConfig(BankDiffConfig.class);
    }

    public Set<Integer> getNegativeOneCounts() {
        return this.negativeOneCounts;
    }
}

