/*
 * Decompiled with CFR 0.152.
 */
package frm.NMAutoSplitter;

import com.google.inject.Provides;
import frm.NMAutoSplitter.NMAutoSplitterConfig;
import frm.NMAutoSplitter.NMAutoSplitterPanel;
import java.awt.image.BufferedImage;
import java.io.PrintWriter;
import java.util.Arrays;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.NPC;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.NpcChanged;
import net.runelite.api.events.NpcSpawned;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="NM Auto Splitter")
public class NMAutoSplitter
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(NMAutoSplitter.class);
    @Inject
    private Client client;
    @Inject
    private NMAutoSplitterConfig config;
    @Inject
    private ClientToolbar clientToolbar;
    private NavigationButton navButton;
    private NMAutoSplitterPanel panel;
    PrintWriter writer;
    private static final int NM_ROOM_MASK = 66994112;
    private static final int NM_ROOM = 58205888;
    private static final int NIGHTMARE_P1 = 9425;
    private static final int NIGHTMARE_P2 = 9426;
    private static final int NIGHTMARE_P3 = 9427;
    private static final int NIGHTMARE_P1_PILLARS = 9428;
    private static final int NIGHTMARE_P2_PILLARS = 9429;
    private static final int NIGHTMARE_P3_PILLARS = 9430;
    private static final int NIGHTMARE_SLEEPWALKERS = 9431;
    private static final int NIGHTMARE_DOWN = 9432;
    private static final int NIGHTMARE_DEATH = 9433;
    private static final int PHOSANI_P1 = 9416;
    private static final int PHOSANI_P2 = 9417;
    private static final int PHOSANI_P3 = 9418;
    private static final int PHOSANI_P4 = 11153;
    private static final int PHOSANI_P5 = 11154;
    private static final int PHOSANI_P1_PILLARS = 9419;
    private static final int PHOSANI_P2_PILLARS = 9420;
    private static final int PHOSANI_P3_PILLARS = 9421;
    private static final int PHOSANI_P4_PILLARS = 11155;
    private static final int PHOSANI_SLEEPWALKERS = 9422;
    private static final int PHOSANI_DOWN = 9423;
    private static final int PHOSANI_DEATH = 9424;
    private NPC nm;
    private int phase;
    boolean dirty;
    int fight_timer = -1;
    int phase_timer = -1;
    int subph_timer = -1;
    int[] phase_splits = new int[6];

    @Provides
    NMAutoSplitterConfig provideConfig(ConfigManager configManager) {
        return (NMAutoSplitterConfig)configManager.getConfig(NMAutoSplitterConfig.class);
    }

    protected void shutDown() throws Exception {
        this.clientToolbar.removeNavigation(this.navButton);
        this.panel.disconnect();
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned e) {
        if (!this.is_in_noa()) {
            return;
        }
        NPC npc = e.getNpc();
        if (this.get_noa_npc_type(npc) == -1) {
            return;
        }
        this.nm = npc;
        this.phase_timer = this.subph_timer = this.client.getTickCount();
        this.fight_timer = this.subph_timer;
        Arrays.fill(this.phase_splits, -1);
        this.dirty = true;
        this.phase = -1;
    }

    @Subscribe
    public void onNpcChanged(NpcChanged e) {
        if (e.getNpc() != this.nm) {
            return;
        }
        this.onNightmareChanged(e.getOld().getId());
        this.send_split();
    }

    private void onNightmareChanged(int oldid) {
        int tick_count = this.client.getTickCount();
        switch (this.nm.getId()) {
            case 9416: 
            case 9417: 
            case 9418: 
            case 9425: 
            case 9426: 
            case 9427: 
            case 11153: 
            case 11154: {
                if (oldid == 9432 || oldid == 9423) {
                    Arrays.fill(this.phase_splits, -1);
                    this.phase = 1;
                    this.fight_timer = tick_count;
                    this.dirty = false;
                } else {
                    ++this.phase;
                }
                this.phase_timer = tick_count;
                this.subph_timer = tick_count;
                break;
            }
            case 9424: {
                this.phase_splits[5] = tick_count - this.phase_timer;
                this.phase_splits[0] = tick_count - this.fight_timer;
            }
            case 9419: 
            case 9420: 
            case 9421: 
            case 9428: 
            case 9429: 
            case 9430: 
            case 11155: {
                this.subph_timer = tick_count;
            }
        }
    }

    private int get_noa_npc_type(NPC npc) {
        if (npc == null) {
            return -1;
        }
        switch (npc.getId()) {
            case 9425: 
            case 9426: 
            case 9427: 
            case 9428: 
            case 9429: 
            case 9430: 
            case 9431: 
            case 9432: 
            case 9433: {
                return 0;
            }
            case 9416: 
            case 9417: 
            case 9418: 
            case 9419: 
            case 9420: 
            case 9421: 
            case 9422: 
            case 9423: 
            case 9424: 
            case 11153: 
            case 11154: 
            case 11155: {
                return 1;
            }
        }
        return -1;
    }

    @Subscribe
    public void onChatMessage(ChatMessage e) {
        String mes = e.getMessage();
        if (e.getType() == ChatMessageType.GAMEMESSAGE && mes.equals("The Nightmare will awaken in 10 seconds!")) {
            this.auto_reset();
        }
    }

    private boolean is_in_noa() {
        WorldPoint wp = this.client.getLocalPlayer().getWorldLocation();
        int x = wp.getX() - this.client.getBaseX();
        int y = wp.getY() - this.client.getBaseY();
        int template = this.client.getInstanceTemplateChunks()[this.client.getPlane()][x / 8][y / 8];
        return (template & 0x3FE3FC0) == 58205888;
    }

    private void send_split() {
        try {
            this.writer.write("startorsplit\r\n");
            this.writer.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void auto_reset() {
        try {
            this.writer.write("reset\r\n");
            this.writer.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void startUp() {
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/icon.png");
        this.panel = new NMAutoSplitterPanel(this.client, this.writer, this.config, this);
        this.navButton = NavigationButton.builder().tooltip("PNM controller").icon(icon).priority(6).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.navButton);
        this.panel.startPanel();
    }
}

