/*
 * Decompiled with CFR 0.152.
 */
package eu.jodelahithit;

import com.google.common.base.Strings;
import eu.jodelahithit.NotificationType;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import net.runelite.api.Client;
import net.runelite.api.EquipmentInventorySlot;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.ItemContainer;
import net.runelite.api.Player;
import net.runelite.api.Point;
import net.runelite.client.game.ItemManager;
import net.runelite.client.util.ColorUtil;
import net.runelite.http.api.item.ItemStats;

public class Utils {
    static boolean isInAnimation(NotificationType notificationType, Client client) {
        if (notificationType == NotificationType.NONE) {
            return false;
        }
        if (notificationType.animations == null) {
            return false;
        }
        Player player = client.getLocalPlayer();
        if (player == null) {
            return false;
        }
        int anim = player.getAnimation();
        return notificationType.animations.contains(anim);
    }

    public static int getStringWidth(Graphics graphics, String text) {
        FontMetrics metrics = graphics.getFontMetrics();
        return metrics.stringWidth(text);
    }

    public static int getStringHeight(Graphics graphics) {
        FontMetrics metrics = graphics.getFontMetrics();
        return metrics.getHeight();
    }

    public static void renderTextCentered(Graphics2D graphics, Point txtLoc, String text, Color color) {
        if (!Strings.isNullOrEmpty((String)text)) {
            int x = txtLoc.getX();
            int y = txtLoc.getY();
            int halfStringWidth = Utils.getStringWidth(graphics, text) / 2;
            graphics.setColor(Color.BLACK);
            graphics.drawString(text, x - halfStringWidth + 1, y + 1);
            graphics.setColor(ColorUtil.colorWithAlpha((Color)color, (int)255));
            graphics.drawString(text, x - halfStringWidth, y);
        }
    }

    public static int getAttackSpeed(Client client, ItemManager itemManager) {
        int weaponID;
        ItemStats stats;
        Item[] items;
        ItemContainer equipment = client.getItemContainer(InventoryID.EQUIPMENT);
        if (equipment != null && (items = equipment.getItems()).length >= 9 && (stats = itemManager.getItemStats(weaponID = items[EquipmentInventorySlot.WEAPON.getSlotIdx()].getId(), false)) != null) {
            return stats.getEquipment().getAspeed();
        }
        return 4;
    }

    public static float clamp(float val, float min, float max) {
        return Math.max(min, Math.min(max, val));
    }

    public static float clamp01(float val) {
        return Math.max(0.0f, Math.min(1.0f, val));
    }
}

