/*
 * Decompiled with CFR 0.152.
 */
package eu.jodelahithit;

import com.google.inject.Provides;
import eu.jodelahithit.Constants;
import eu.jodelahithit.NotificationType;
import eu.jodelahithit.Session;
import eu.jodelahithit.SkillingNotificationsConfig;
import eu.jodelahithit.SkillingNotificationsListener;
import eu.jodelahithit.SkillingNotificationsOverlay;
import eu.jodelahithit.SkillingNotificationsPanel;
import eu.jodelahithit.Utils;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.Hitsplat;
import net.runelite.api.Player;
import net.runelite.api.Skill;
import net.runelite.api.Tile;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ClientTick;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.HitsplatApplied;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.events.StatChanged;
import net.runelite.api.events.WorldChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.ItemManager;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.ImageUtil;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Skilling Notifications", tags={"notifications", "skilling"}, description="Provides visual notifications when no longer actively performing the selected skill")
public class SkillingNotificationsPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(SkillingNotificationsPlugin.class);
    private static final String WALK_HERE = "Walk here";
    private static final int MANIACAL_MONKEYS_REGION_ID = 11662;
    private LocalPoint lastPlayerLocation;
    private Session session;
    private NavigationButton navigationButton;
    private List<NotificationType> selectedNotificationTypes = new ArrayList<NotificationType>();
    public Tile lastManiacalMonkeyRockTile = null;
    private int[] xpCache;
    public SkillingNotificationsPanel panel;
    @Inject
    Client client;
    @Inject
    ConfigManager configManager;
    @Inject
    SkillingNotificationsConfig config;
    @Inject
    OverlayManager overlayManager;
    @Inject
    SkillingNotificationsOverlay overlay;
    @Inject
    SkillingNotificationsListener inputListener;
    @Inject
    ClientToolbar clientToolbar;
    @Inject
    ItemManager itemManager;
    @Inject
    KeyManager keyManager;
    public final BufferedImage ICON = ImageUtil.loadImageResource(SkillingNotificationsPlugin.class, (String)"icon.png");

    protected void startUp() throws Exception {
        this.xpCache = new int[Skill.values().length];
        this.keyManager.registerKeyListener((KeyListener)this.inputListener);
        this.updateSelectedSkills();
        this.panel = new SkillingNotificationsPanel(this.configManager);
        this.navigationButton = NavigationButton.builder().tooltip("Skilling Notifications").icon(this.ICON).priority(10).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.navigationButton);
        this.overlayManager.add((Overlay)this.overlay);
        this.session = new Session(this);
    }

    protected void shutDown() throws Exception {
        this.clientToolbar.removeNavigation(this.navigationButton);
        this.overlayManager.remove((Overlay)this.overlay);
        this.keyManager.unregisterKeyListener((KeyListener)this.inputListener);
    }

    @Provides
    SkillingNotificationsConfig provideConfig(ConfigManager configManager) {
        return (SkillingNotificationsConfig)configManager.getConfig(SkillingNotificationsConfig.class);
    }

    @Subscribe
    public void onClientTick(ClientTick clientTick) {
        if (!this.config.enabled()) {
            return;
        }
        for (NotificationType notificationType : this.selectedNotificationTypes) {
            if (!Utils.isInAnimation(notificationType, this.client)) continue;
            this.session.updateInstant(notificationType);
        }
        Player player = this.client.getLocalPlayer();
        if (player != null) {
            LocalPoint playerLocation = player.getLocalLocation();
            if (!playerLocation.equals((Object)this.lastPlayerLocation)) {
                this.session.updateWalkingInstant();
            }
            this.lastPlayerLocation = playerLocation;
        }
        boolean isInManiacalMonkeysArea = this.isInManiacalMonkeysArea();
        if (!this.isInManiacalMonkeysArea() || isInManiacalMonkeysArea && this.lastManiacalMonkeyRockTile != null) {
            this.session.updateInstant(NotificationType.MANIACALMONKEYS);
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged configChanged) {
        if (configChanged.getGroup().equals("Skilling Notifications")) {
            this.updateSelectedSkills();
        }
    }

    @Subscribe
    public void onStatChanged(StatChanged statChanged) {
        int xpAmount;
        Skill skill = statChanged.getSkill();
        int currentXp = statChanged.getXp();
        int skillIdx = skill.ordinal();
        int cachedXP = this.xpCache[skillIdx];
        if (cachedXP < currentXp && (xpAmount = currentXp - cachedXP) >= this.config.customXPValue()) {
            this.session.updateInstant(NotificationType.CUSTOMXP);
        }
        this.xpCache[skillIdx] = currentXp;
    }

    @Subscribe
    public void onHitsplatApplied(HitsplatApplied hitsplatApplied) {
        if (!this.config.enabled()) {
            return;
        }
        Actor actor = hitsplatApplied.getActor();
        Hitsplat hitsplat = hitsplatApplied.getHitsplat();
        if (hitsplat.isMine()) {
            this.session.updateInstant(NotificationType.COMBAT);
        }
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        GameObject gameObject = event.getGameObject();
        int id = gameObject.getId();
        WorldPoint trapLocation = gameObject.getWorldLocation();
        if (id == 28827 || id == 28825) {
            if (this.client.getLocalPlayer().getWorldLocation().distanceTo(trapLocation) <= 2) {
                this.lastManiacalMonkeyRockTile = event.getTile();
            }
            return;
        }
        if (Constants.MONKEY_ROCKS.contains(id) && this.lastManiacalMonkeyRockTile != null && event.getTile() == this.lastManiacalMonkeyRockTile) {
            this.lastManiacalMonkeyRockTile = null;
        }
    }

    @Subscribe
    private void onWorldChanged(WorldChanged ev) {
        this.lastManiacalMonkeyRockTile = null;
    }

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked event) {
        if (event.getMenuOption().equals(WALK_HERE)) {
            this.session.updateWalkingInstant();
        }
    }

    boolean areSelectedSkillsActive() {
        boolean isActive = false;
        for (NotificationType notificationType : this.selectedNotificationTypes) {
            isActive |= this.session.isSkillActive(notificationType);
        }
        return isActive;
    }

    boolean shouldRenderOverlay() {
        if (!this.config.enabled()) {
            return false;
        }
        boolean skills = !this.selectedNotificationTypes.isEmpty() && !this.areSelectedSkillsActive();
        boolean notWalking = !this.config.disableWhenWalking() || !this.session.isWalking(this.config.walkDelay());
        return skills && notWalking;
    }

    public List<NotificationType> getSelectedSkills() {
        return this.selectedNotificationTypes;
    }

    void updateSelectedSkills() {
        this.selectedNotificationTypes.clear();
        for (NotificationType notificationType : NotificationType.values()) {
            if (!Boolean.parseBoolean(this.configManager.getConfiguration("Skilling Notifications", notificationType.name().toUpperCase()))) continue;
            this.selectedNotificationTypes.add(notificationType);
        }
    }

    int getExtraSkillDelay(NotificationType notificationType) {
        int delay = Integer.parseInt(this.configManager.getConfiguration("Skilling Notifications", notificationType.name() + "DELAYV2"));
        if (notificationType == NotificationType.COMBAT) {
            return Utils.getAttackSpeed(this.client, this.itemManager) * 600 + delay;
        }
        return delay;
    }

    void setSkillInConfig(NotificationType notificationType) {
        this.configManager.setConfiguration("Skilling Notifications", "selectedSkill", (Object)notificationType);
    }

    boolean isInManiacalMonkeysArea() {
        return ArrayUtils.contains((int[])this.client.getMapRegions(), (int)11662);
    }
}

