/*
 * Decompiled with CFR 0.152.
 */
package eu.jodelahithit;

import eu.jodelahithit.NotificationType;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.inject.Inject;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import org.apache.commons.lang3.StringUtils;

public class SkillingNotificationsPanel
extends PluginPanel {
    private final Dictionary<String, BufferedImage> iconsCache = new Hashtable<String, BufferedImage>();
    private final ConfigManager configManager;
    private final JPanel skillsPanel;
    private final JPanel enabledPanel;
    private final JPanel flashingPanel;
    private final JPanel walkingPanel;
    private final JPanel customPanel;

    @Inject
    SkillingNotificationsPanel(ConfigManager configManager) {
        this.configManager = configManager;
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = new Insets(0, 0, 10, 0);
        JLabel welcomeText = new JLabel("Skilling Notifications");
        welcomeText.setFont(FontManager.getRunescapeBoldFont());
        welcomeText.setHorizontalAlignment(0);
        this.skillsPanel = new JPanel();
        this.skillsPanel.setLayout(new GridLayout(0, 2, 7, 7));
        this.enabledPanel = new JPanel();
        this.enabledPanel.setLayout(new GridLayout(1, 1, 0, 0));
        this.flashingPanel = new JPanel();
        this.flashingPanel.setLayout(new GridLayout(1, 1, 0, 0));
        this.walkingPanel = new JPanel();
        this.walkingPanel.setLayout(new GridLayout(1, 1, 0, 0));
        this.customPanel = new JPanel();
        this.customPanel.setLayout(new GridLayout(1, 2, 0, 0));
        JPanel descriptionPanel = new JPanel();
        descriptionPanel.setBackground(ColorScheme.DARKER_GRAY_COLOR);
        descriptionPanel.setBorder(new EmptyBorder(10, 10, 10, 10));
        JTextArea description = new JTextArea(0, 25);
        description.setText("This plugin will display an overlay when the player is not actively performing any of the following selected skills.\n\nExtra notification delays can be configured in the plugin configuration.");
        description.setWrapStyleWord(true);
        description.setLineWrap(true);
        description.setOpaque(false);
        description.setEditable(false);
        description.setFocusable(false);
        description.setBackground(ColorScheme.DARK_GRAY_COLOR);
        description.setFont(FontManager.getRunescapeSmallFont());
        description.setBorder(new EmptyBorder(0, 0, 0, 0));
        descriptionPanel.add(description);
        this.repaintConfigButtons();
        this.add(welcomeText, c);
        ++c.gridy;
        this.add(descriptionPanel, c);
        ++c.gridy;
        this.add(this.enabledPanel, c);
        ++c.gridy;
        this.add(this.walkingPanel, c);
        ++c.gridy;
        this.add(this.flashingPanel, c);
        ++c.gridy;
        this.add(this.skillsPanel, c);
        ++c.gridy;
        this.add(this.customPanel, c);
    }

    public void onActivate() {
        this.repaintConfigButtons();
    }

    public void repaintConfigButtons() {
        this.setVisible(false);
        this.skillsPanel.removeAll();
        for (NotificationType notificationType : NotificationType.values()) {
            if (notificationType == NotificationType.NONE || notificationType == NotificationType.CUSTOMXP) continue;
            String skillIcon = "/skill_icons/" + notificationType.name().toLowerCase() + ".png";
            ImageIcon icon = new ImageIcon(this.GetIcon((String)(notificationType.customImage == null ? skillIcon : notificationType.customImage)));
            boolean isActive = Boolean.parseBoolean(this.configManager.getConfiguration("Skilling Notifications", notificationType.name()));
            JToggleButton toggleButton = new JToggleButton(icon, isActive);
            toggleButton.setToolTipText(StringUtils.capitalize((String)notificationType.name().toLowerCase()));
            toggleButton.setFocusable(false);
            toggleButton.addItemListener(ev -> this.configManager.setConfiguration("Skilling Notifications", notificationType.name(), (Object)(ev.getStateChange() == 1 ? 1 : 0)));
            this.skillsPanel.add(toggleButton);
        }
        this.enabledPanel.removeAll();
        JToggleButton enabledButton = new JToggleButton("Enabled", Boolean.parseBoolean(this.configManager.getConfiguration("Skilling Notifications", "enabled")));
        enabledButton.setFocusable(false);
        enabledButton.setToolTipText("Toggles the overlay and plugin functionality");
        enabledButton.addItemListener(ev -> this.configManager.setConfiguration("Skilling Notifications", "enabled", (Object)(ev.getStateChange() == 1 ? 1 : 0)));
        this.enabledPanel.add(enabledButton);
        this.walkingPanel.removeAll();
        JToggleButton walkingButton = new JToggleButton("Disable overlay while walking", Boolean.parseBoolean(this.configManager.getConfiguration("Skilling Notifications", "disableWhenWalking")));
        walkingButton.setFocusable(false);
        walkingButton.setToolTipText("Forces the notification overlay to be disabled while walking or running");
        walkingButton.addItemListener(ev -> this.configManager.setConfiguration("Skilling Notifications", "disableWhenWalking", (Object)(ev.getStateChange() == 1 ? 1 : 0)));
        this.walkingPanel.add(walkingButton);
        this.flashingPanel.removeAll();
        JToggleButton flashingButton = new JToggleButton("Notification flash", Boolean.parseBoolean(this.configManager.getConfiguration("Skilling Notifications", "notificationFlash")));
        flashingButton.setFocusable(false);
        flashingButton.setToolTipText("Flashes notifications at the configured interval");
        flashingButton.addItemListener(ev -> this.configManager.setConfiguration("Skilling Notifications", "notificationFlash", (Object)(ev.getStateChange() == 1 ? 1 : 0)));
        this.flashingPanel.add(flashingButton);
        this.customPanel.removeAll();
        JToggleButton customXPButton = new JToggleButton("Custom XP", Boolean.parseBoolean(this.configManager.getConfiguration("Skilling Notifications", "CUSTOMXP")));
        customXPButton.setFocusable(false);
        customXPButton.setToolTipText("Displays notifications when XP drops of the configured threshold are not received");
        customXPButton.addItemListener(ev -> this.configManager.setConfiguration("Skilling Notifications", "CUSTOMXP", (Object)(ev.getStateChange() == 1 ? 1 : 0)));
        this.customPanel.add(customXPButton);
        SpinnerNumberModel model = new SpinnerNumberModel(Integer.parseInt(this.configManager.getConfiguration("Skilling Notifications", "customXPValue")), 1, Integer.MAX_VALUE, 10);
        JSpinner spinner = new JSpinner(model);
        spinner.addChangeListener(ev -> this.configManager.setConfiguration("Skilling Notifications", "customXPValue", spinner.getValue()));
        this.customPanel.add(spinner);
        this.setVisible(true);
    }

    private BufferedImage GetIcon(String path) {
        BufferedImage iconImage = this.iconsCache.get(path);
        if (iconImage != null) {
            return iconImage;
        }
        iconImage = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)path);
        this.iconsCache.put(path, iconImage);
        return iconImage;
    }
}

