/*
 * Decompiled with CFR 0.152.
 */
package eu.jodelahithit;

import com.google.inject.Inject;
import eu.jodelahithit.Session;
import eu.jodelahithit.SkillingNotificationsConfig;
import eu.jodelahithit.SkillingNotificationsPlugin;
import eu.jodelahithit.Utils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.time.Duration;
import java.time.Instant;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.util.ColorUtil;

public class SkillingNotificationsOverlay
extends Overlay {
    private final Client client;
    private final SkillingNotificationsPlugin plugin;
    private final SkillingNotificationsConfig config;
    private final float TEXT_COLOR_LERP = 0.75f;
    private Instant fadeInstant = Instant.now();
    private static Instant notificationInstant = Instant.now();
    private static String notificationText;
    float fadeValue = 0.0f;

    @Inject
    private SkillingNotificationsOverlay(Client client, SkillingNotificationsPlugin plugin, SkillingNotificationsConfig config) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.client = client;
        this.plugin = plugin;
        this.config = config;
    }

    private Color getFadedColor(Color input, boolean overlayEnabled) {
        int fadeDuration = this.config.notificationFade();
        if (fadeDuration == 0) {
            this.fadeValue = 0.0f;
            return input;
        }
        Instant now = Instant.now();
        float difference = (float)Duration.between(this.fadeInstant, now).toMillis() / (float)fadeDuration;
        this.fadeValue += overlayEnabled ? difference : -difference;
        this.fadeInstant = now;
        this.fadeValue = Utils.clamp01(this.fadeValue);
        int r = input.getRed();
        int g = input.getGreen();
        int b = input.getBlue();
        int a = input.getAlpha();
        return new Color(r, g, b, (int)((float)a * this.fadeValue));
    }

    public Dimension render(Graphics2D graphics) {
        boolean shouldRender = this.plugin.shouldRenderOverlay();
        Color fadedColor = this.getFadedColor(this.config.overlayColor(), shouldRender);
        if (shouldRender || this.fadeValue > 0.05f) {
            boolean canFlash;
            boolean bl = canFlash = this.fadeValue > 0.95f || this.config.notificationFade() == 0;
            if (canFlash && this.config.flash() && this.client.getGameCycle() % 40 >= 20) {
                return null;
            }
            Color color = graphics.getColor();
            graphics.setColor(fadedColor);
            graphics.fill(new Rectangle(this.client.getCanvas().getSize()));
            graphics.setColor(color);
            if (!this.config.disableOverlayText()) {
                Point locationOffset = new Point(this.client.getCanvasWidth() / 2, this.client.getCanvasHeight() / 8 + Utils.getStringHeight(graphics));
                Utils.renderTextCentered(graphics, locationOffset, "Skilling Notification", ColorUtil.colorLerp((Color)Color.white, (Color)this.config.overlayColor(), (double)0.75));
            }
        }
        if (Session.checkInstant(notificationInstant, 2000.0f)) {
            Point location = new Point(this.client.getCanvasWidth() / 2, this.client.getCanvasHeight() / 8);
            Utils.renderTextCentered(graphics, location, notificationText, ColorUtil.colorLerp((Color)Color.white, (Color)this.config.overlayColor(), (double)0.75));
        }
        return null;
    }

    public void Notify(String text) {
        notificationInstant = Instant.now();
        notificationText = text;
    }
}

