/*
 * Decompiled with CFR 0.152.
 */
package eu.jodelahithit;

import eu.jodelahithit.NotificationType;
import eu.jodelahithit.SkillingNotificationsPlugin;
import java.time.Duration;
import java.time.Instant;
import java.util.Dictionary;
import java.util.Hashtable;

public class Session {
    private Dictionary<NotificationType, Instant> skillInstants = new Hashtable<NotificationType, Instant>();
    private SkillingNotificationsPlugin plugin;
    private Instant walkingInstant = Instant.now();

    public Session(SkillingNotificationsPlugin plugin) {
        this.plugin = plugin;
    }

    public static boolean checkInstant(Instant instant, float timeout) {
        return (float)Duration.between(instant, Instant.now()).toMillis() < timeout;
    }

    public void updateInstant(NotificationType notificationType) {
        this.skillInstants.put(notificationType, Instant.now());
    }

    public boolean isSkillActive(NotificationType notificationType) {
        Instant instant = this.skillInstants.get((Object)notificationType);
        if (instant != null) {
            return Session.checkInstant(instant, 500 + Math.max(this.plugin.getExtraSkillDelay(notificationType), 0));
        }
        return false;
    }

    public void updateWalkingInstant() {
        this.walkingInstant = Instant.now();
    }

    public boolean isWalking(float extraTimeout) {
        return Session.checkInstant(this.walkingInstant, 1.0f + extraTimeout);
    }
}

