/*
 * Decompiled with CFR 0.152.
 */
package com.tim.tombshelper;

import com.google.inject.Provides;
import com.tim.tombshelper.TombsHelperConfig;
import com.tim.tombshelper.TombsHelperPanel;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.GameTick;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="ToA Puzzle Helper")
public class TombsHelperPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(TombsHelperPlugin.class);
    @Inject
    private Client client;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private TombsHelperConfig config;
    private TombsHelperPanel panel;
    private NavigationButton navButton;
    private boolean panelEnabled = false;
    private int lastRegionId = -1;
    private static final List<Integer> TOA_INSTANCE_IDS = Arrays.asList(13454, 14164, 14676, 15188, 15444, 15700, 15955, 13906, 14162, 14674, 15186, 15698, 15954, 15953, 14160, 14672, 15184, 15696);
    private static final List<Integer> TOA_PUZZLE_IDS = Arrays.asList(14674, 15186, 14162, 15698);
    private static final int TOA_PUZZLE_AKKHA = 14674;
    private static final int TOA_PUZZLE_BABA = 15186;
    private static final int TOA_PUZZLE_KEPHRI = 14162;
    private static final int TOA_PUZZLE_ZEBAK = 15698;
    private PuzzleRoom currentRoom = PuzzleRoom.NONE;

    protected void startUp() throws Exception {
        log.info("TombsHelper started!");
        this.panel = new TombsHelperPanel(this);
        this.navButton = NavigationButton.builder().tooltip("ToA Helper").icon(ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/com/tim/tombshelper/toa_nav_icon.png")).priority(50).panel((PluginPanel)this.panel).build();
        this.togglePanel(!this.config.autoHide());
        this.panel.update(this.currentRoom);
    }

    protected void shutDown() throws Exception {
        log.info("TombsHelper stopped!");
        this.clientToolbar.removeNavigation(this.navButton);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals("toahelper")) {
            return;
        }
        if (event.getKey().equals("Auto hide panel")) {
            boolean inToA = TOA_INSTANCE_IDS.contains(this.getRegionId());
            this.togglePanel(inToA || !this.config.autoHide());
        }
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        this.checkRegion();
    }

    public PuzzleRoom getRoom() {
        return this.currentRoom;
    }

    private void setRoom(int regionId) {
        switch (regionId) {
            case 14674: {
                this.currentRoom = PuzzleRoom.AKKHA;
                return;
            }
            case 15186: {
                this.currentRoom = PuzzleRoom.BABA;
                return;
            }
            case 14162: {
                this.currentRoom = PuzzleRoom.KEPHRI;
                return;
            }
            case 15698: {
                this.currentRoom = PuzzleRoom.ZEBAK;
                return;
            }
        }
        this.currentRoom = PuzzleRoom.NONE;
    }

    private void checkRegion() {
        int regionId = this.getRegionId();
        if (!TOA_INSTANCE_IDS.contains(regionId)) {
            if (this.config.autoHide()) {
                this.togglePanel(false);
            }
            this.lastRegionId = regionId;
            return;
        }
        if (!TOA_INSTANCE_IDS.contains(this.lastRegionId) && !this.panelEnabled && this.config.autoHide()) {
            this.togglePanel(true);
        }
        if (regionId != this.lastRegionId && TOA_INSTANCE_IDS.contains(regionId)) {
            this.setRoom(regionId);
            this.panel.update(this.currentRoom);
        }
        this.lastRegionId = regionId;
    }

    private int getRegionId() {
        Player player = this.client.getLocalPlayer();
        if (player == null) {
            return -1;
        }
        return WorldPoint.fromLocalInstance((Client)this.client, (LocalPoint)player.getLocalLocation()).getRegionID();
    }

    private void togglePanel(boolean enable) {
        this.panelEnabled = enable;
        if (enable) {
            this.clientToolbar.addNavigation(this.navButton);
        } else {
            this.clientToolbar.removeNavigation(this.navButton);
            this.navButton.setSelected(false);
        }
    }

    @Provides
    TombsHelperConfig provideConfig(ConfigManager configManager) {
        return (TombsHelperConfig)configManager.getConfig(TombsHelperConfig.class);
    }

    public static enum PuzzleRoom {
        NONE("Not in a puzzle room", 0),
        AKKHA("Akkha", 14674),
        BABA("Ba-Ba", 15186),
        KEPHRI("Kephri", 14162),
        ZEBAK("Zebak", 15698);

        private String roomName;
        private int roomId;

        private PuzzleRoom(String roomName, int roomId) {
            this.roomName = roomName;
            this.roomId = roomId;
        }

        public String getRoomName() {
            return this.roomName;
        }

        public int getRoomId() {
            return this.roomId;
        }
    }
}

