/*
 * Decompiled with CFR 0.152.
 */
package com.tim.tombshelper;

import com.tim.tombshelper.TombsHelperPlugin;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TombsHelperPanel
extends PluginPanel {
    private static final Logger log = LoggerFactory.getLogger(TombsHelperPanel.class);
    private final JTabbedPane jtp = new JTabbedPane();
    private final JLabel title = new JLabel();
    private final JPanel imageKephriLightSwitches = new JPanel(new GridBagLayout());
    private final JPanel imageKephriSum = new JPanel(new GridBagLayout());
    private static final BufferedImage kephriLightSwitchesBImg = ImageUtil.loadImageResource(TombsHelperPlugin.class, (String)"/com/tim/tombshelper/puzzles/kephri_light_switches.png");
    private static final BufferedImage kephriSumBImg = ImageUtil.loadImageResource(TombsHelperPlugin.class, (String)"/com/tim/tombshelper/puzzles/kephri_sums.png");
    private static final JLabel kephriLightSwitchesLabel = new JLabel(new ImageIcon(kephriLightSwitchesBImg));
    private static final JLabel kephriSumLabel = new JLabel(new ImageIcon(kephriSumBImg));
    private final JPanel imageBabaWaveSolo = new JPanel(new GridBagLayout());
    private static final BufferedImage babaWaveSoloBImg = ImageUtil.loadImageResource(TombsHelperPlugin.class, (String)"/com/tim/tombshelper/puzzles/baba_wave_spawns_solo.png");
    private static final JLabel babaWaveSoloLabel = new JLabel(new ImageIcon(babaWaveSoloBImg));
    private static GridBagConstraints constraints = new GridBagConstraints();

    public TombsHelperPanel(TombsHelperPlugin plugin) {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        JPanel northPanel = new JPanel(new BorderLayout());
        northPanel.setBorder(new EmptyBorder(1, 0, 10, 0));
        this.title.setText("Tombs of Amascut Helper");
        this.title.setForeground(Color.WHITE);
        northPanel.add((Component)this.title, "Center");
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.setBackground(ColorScheme.DARK_GRAY_COLOR);
        this.jtp.setBackground(ColorScheme.DARK_GRAY_COLOR);
        TombsHelperPanel.constraints.fill = 2;
        TombsHelperPanel.constraints.weightx = 1.0;
        TombsHelperPanel.constraints.gridx = 0;
        TombsHelperPanel.constraints.gridy = 0;
        this.imageKephriLightSwitches.add((Component)kephriLightSwitchesLabel, constraints);
        this.imageKephriSum.add((Component)kephriSumLabel, constraints);
        this.imageBabaWaveSolo.add((Component)babaWaveSoloLabel, constraints);
        centerPanel.add(this.jtp);
        this.add(northPanel, "North");
        this.add(centerPanel, "Center");
    }

    public void update(TombsHelperPlugin.PuzzleRoom currentRoom) {
        SwingUtilities.invokeLater(() -> this.updatePanel(currentRoom));
    }

    private void updatePanel(TombsHelperPlugin.PuzzleRoom currentRoom) {
        this.jtp.removeAll();
        this.title.setText("Tombs of Amascut Helper");
        this.jtp.setBounds(0, 0, 200, 500);
        switch (currentRoom) {
            case KEPHRI: {
                this.title.setText("Kephri Helper");
                this.jtp.add("Lights", this.imageKephriLightSwitches);
                this.jtp.add("Sum", this.imageKephriSum);
                break;
            }
            case BABA: {
                this.title.setText("Ba-Ba Helper");
                this.jtp.add("Solo", this.imageBabaWaveSolo);
                break;
            }
        }
        this.repaint();
        this.revalidate();
    }
}

