/*
 * Decompiled with CFR 0.152.
 */
package io.ryoung.areamute;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Provides;
import io.ryoung.areamute.AreaMuteConfig;
import io.ryoung.areamute.AreaMuteOverlay;
import java.awt.Rectangle;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.api.Point;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.CommandExecuted;
import net.runelite.api.events.MenuOpened;
import net.runelite.api.events.OverheadTextChanged;
import net.runelite.api.events.ScriptCallbackEvent;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.api.worldmap.WorldMap;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Area Mute", description="Mute player chat within regions of the game")
public class AreaMutePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(AreaMutePlugin.class);
    public static final int REGION_SIZE = 64;
    private static final Type TOKEN = new TypeToken<HashSet<Integer>>(){}.getType();
    @Inject
    private Client client;
    @Inject
    private AreaMuteConfig config;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private Gson gson;
    private final Set<Integer> regions = new HashSet<Integer>();
    private final LinkedHashMap<Integer, Boolean> chatCache = new LinkedHashMap<Integer, Boolean>(){
        private static final int MAX_ENTRIES = 2000;

        @Override
        protected boolean removeEldestEntry(Map.Entry<Integer, Boolean> eldest) {
            return this.size() > 2000;
        }
    };
    @Inject
    private AreaMuteOverlay overlay;

    protected void startUp() {
        this.overlayManager.add((Overlay)this.overlay);
        this.loadRegions();
    }

    protected void shutDown() {
        this.overlayManager.remove((Overlay)this.overlay);
        this.chatCache.clear();
        this.regions.clear();
    }

    public void loadRegions() {
        this.regions.clear();
        this.regions.addAll((Collection)this.gson.fromJson(this.config.regions(), TOKEN));
    }

    public void saveRegions() {
        this.config.regions(this.gson.toJson(this.regions));
    }

    public void muteArea(int regionId) {
        log.debug("adding region {}", (Object)regionId);
        this.regions.add(regionId);
        this.saveRegions();
    }

    public void unmuteArea(int regionId) {
        log.debug("unmuting region {}", (Object)regionId);
        this.regions.remove(regionId);
        this.saveRegions();
    }

    public boolean shouldFilter(Player actor) {
        if (actor == null) {
            return false;
        }
        if (actor == this.client.getLocalPlayer() && !this.config.filterSelf()) {
            return false;
        }
        if (actor.isFriend() && !this.config.filterFriends()) {
            return false;
        }
        if (actor.isClanMember() && !this.config.filterClanMates()) {
            return false;
        }
        if (actor.isFriendsChatMember() && !this.config.filterFriendChat()) {
            return false;
        }
        return this.regions.contains(actor.getWorldLocation().getRegionID());
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if ("areamute".equals(event.getGroup()) && "regions".equals(event.getKey())) {
            this.loadRegions();
        }
    }

    @Subscribe
    public void onCommandExecuted(CommandExecuted event) {
        switch (event.getCommand()) {
            case "mutearea": {
                this.muteArea(this.client.getLocalPlayer().getWorldLocation().getRegionID());
                break;
            }
            case "unmutearea": {
                this.unmuteArea(this.client.getLocalPlayer().getWorldLocation().getRegionID());
            }
        }
    }

    @Subscribe(priority=-999999.0f)
    public void onOverheadTextChanged(OverheadTextChanged event) {
        if (!(event.getActor() instanceof Player) || !this.shouldFilter((Player)event.getActor())) {
            return;
        }
        event.getActor().setOverheadText(" ");
    }

    @Subscribe(priority=999999.0f)
    public void onChatMessage(ChatMessage chatMessage) {
        String name = Text.toJagexName((String)Text.removeTags((String)chatMessage.getName()));
        int messageId = chatMessage.getMessageNode().getId();
        Player actor = null;
        for (Player p : this.client.getPlayers()) {
            if (!name.equalsIgnoreCase(p.getName())) continue;
            actor = p;
            break;
        }
        if (actor == null && name.equalsIgnoreCase(this.client.getLocalPlayer().getName())) {
            actor = this.client.getLocalPlayer();
        }
        if (this.shouldFilter(actor)) {
            this.chatCache.put(messageId, true);
        }
    }

    @Subscribe
    public void onScriptCallbackEvent(ScriptCallbackEvent event) {
        if (!"chatFilterCheck".equals(event.getEventName())) {
            return;
        }
        int[] intStack = this.client.getIntStack();
        int intStackSize = this.client.getIntStackSize();
        String[] stringStack = this.client.getStringStack();
        int stringStackSize = this.client.getStringStackSize();
        int messageType = intStack[intStackSize - 2];
        int messageId = intStack[intStackSize - 1];
        ChatMessageType chatMessageType = ChatMessageType.of((int)messageType);
        switch (chatMessageType) {
            case PUBLICCHAT: 
            case AUTOTYPER: {
                if (!this.chatCache.containsKey(messageId)) break;
                intStack[intStackSize - 3] = 0;
                stringStack[stringStackSize - 1] = null;
            }
        }
    }

    @Subscribe
    public void onMenuOpened(MenuOpened event) {
        Point p;
        Widget map = this.client.getWidget(WidgetInfo.WORLD_MAP_VIEW);
        if (map == null) {
            return;
        }
        Rectangle worldMapRect = map.getBounds();
        if (worldMapRect.contains((p = this.client.getMouseCanvasPosition()).getX(), p.getY())) {
            int regionId = this.getRegionIdFromCursor();
            boolean muted = this.regions.contains(regionId);
            String option = muted ? "Unmute" : "Mute";
            this.client.createMenuEntry(-1).setOption(option).setTarget("Region").onClick(e -> {
                if (muted) {
                    this.unmuteArea(regionId);
                } else {
                    this.muteArea(regionId);
                }
            });
        }
    }

    public int getRegionIdFromCursor() {
        Widget map = this.client.getWidget(WidgetInfo.WORLD_MAP_VIEW);
        if (map == null) {
            return 0;
        }
        WorldMap worldMap = this.client.getWorldMap();
        float pixelsPerTile = worldMap.getWorldMapZoom();
        Rectangle worldMapRect = map.getBounds();
        int widthInTiles = (int)Math.ceil(worldMapRect.getWidth() / (double)pixelsPerTile);
        int heightInTiles = (int)Math.ceil(worldMapRect.getHeight() / (double)pixelsPerTile);
        Point worldMapPosition = worldMap.getWorldMapPosition();
        Point mp = this.client.getMouseCanvasPosition();
        if (worldMapRect.contains(mp.getX(), mp.getY())) {
            int rXO = (mp.getX() - (int)worldMapRect.getX()) / (int)pixelsPerTile;
            int x = rXO + worldMapPosition.getX() - widthInTiles / 2;
            int rYO = (-mp.getY() + (int)worldMapRect.getY() + worldMapRect.height) / (int)pixelsPerTile;
            int y = rYO - heightInTiles / 2 + worldMapPosition.getY();
            return x >>> 6 << 8 | y >> 6;
        }
        return 0;
    }

    @Provides
    AreaMuteConfig provideConfig(ConfigManager configManager) {
        return (AreaMuteConfig)configManager.getConfig(AreaMuteConfig.class);
    }

    public Set<Integer> getRegions() {
        return this.regions;
    }
}

