/*
 * Decompiled with CFR 0.152.
 */
package io.ryoung.areamute;

import io.ryoung.areamute.AreaMuteConfig;
import io.ryoung.areamute.AreaMutePlugin;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.api.worldmap.WorldMap;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AreaMuteOverlay
extends Overlay {
    private static final Logger log = LoggerFactory.getLogger(AreaMuteOverlay.class);
    private static final float STROKE_WIDTH = 2.0f;
    private static final Stroke STROKE = new BasicStroke(2.0f);
    private final AreaMutePlugin plugin;
    private final Client client;
    private final AreaMuteConfig config;

    @Inject
    public AreaMuteOverlay(Client client, AreaMutePlugin plugin, AreaMuteConfig config) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.HIGH);
        this.setLayer(OverlayLayer.MANUAL);
        this.drawAfterInterface(595);
        this.client = client;
        this.plugin = plugin;
        this.config = config;
    }

    public Dimension render(Graphics2D graphics) {
        Widget map = this.client.getWidget(WidgetInfo.WORLD_MAP_VIEW);
        if (map == null) {
            return null;
        }
        WorldMap worldMap = this.client.getWorldMap();
        Rectangle worldMapRect = map.getBounds();
        graphics.setClip(worldMapRect);
        graphics.setStroke(STROKE);
        Point mp = this.client.getMouseCanvasPosition();
        if (worldMapRect.contains(mp.getX(), mp.getY())) {
            int regionId = this.plugin.getRegionIdFromCursor();
            this.drawRegrion(graphics, map, worldMap, regionId, this.config.hoveredColor());
        }
        for (Integer regionId : this.plugin.getRegions()) {
            this.drawRegrion(graphics, map, worldMap, regionId, this.config.mutedColor());
        }
        return null;
    }

    void drawRegrion(Graphics2D graphics, Widget map, WorldMap worldMap, int regionId, Color color) {
        float pixelsPerTile = worldMap.getWorldMapZoom();
        Rectangle worldMapRect = map.getBounds();
        int widthInTiles = (int)Math.ceil(worldMapRect.getWidth() / (double)pixelsPerTile);
        int heightInTiles = (int)Math.ceil(worldMapRect.getHeight() / (double)pixelsPerTile);
        int regionPixelSize = (int)Math.ceil(64.0f * pixelsPerTile);
        Point worldMapPosition = worldMap.getWorldMapPosition();
        graphics.setColor(color);
        int x = regionId >>> 8 << 6;
        int y = (regionId & 0xFF) << 6;
        int yTileOffset = -(worldMapPosition.getY() - heightInTiles / 2 - y);
        int xTileOffset = x + widthInTiles / 2 - worldMapPosition.getX();
        int xPos = (int)((float)xTileOffset * pixelsPerTile) + (int)worldMapRect.getX();
        int yPos = worldMapRect.height - (int)((float)yTileOffset * pixelsPerTile) + (int)worldMapRect.getY() - regionPixelSize;
        graphics.drawRect(xPos, yPos, regionPixelSize, regionPixelSize);
    }
}

