/*
 * Decompiled with CFR 0.152.
 */
package com.lmsnotifier;

import com.lmsnotifier.BotIdentification;
import com.lmsnotifier.LMSPlugin;
import com.lmsnotifier.PlayerSnapshot;
import java.awt.Color;
import net.runelite.api.ChatMessageType;
import net.runelite.api.HeadIcon;
import net.runelite.client.util.ColorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlayerTracker {
    private static final Logger log = LoggerFactory.getLogger(PlayerTracker.class);
    private static final int TOTAL = 500;
    private final LMSPlugin plugin;
    String name;
    PlayerSnapshot[] snapshots;
    int snapshotIndex;
    BotIdentification.Status status;
    String statusReason;

    PlayerTracker(String name, LMSPlugin plugin) {
        this.name = name;
        this.plugin = plugin;
        this.snapshots = new PlayerSnapshot[500];
        this.snapshotIndex = 0;
        this.status = null;
    }

    void addSnapshot(PlayerSnapshot snapshot) {
        if (this.snapshotIndex >= 500) {
            return;
        }
        this.snapshots[this.snapshotIndex++] = snapshot;
    }

    public BotIdentification.Status getStatus() {
        if (this.status == null) {
            return BotIdentification.Status.UNSURE;
        }
        return this.status;
    }

    public void setStatus(BotIdentification.Status status, String reason) {
        this.status = status;
        this.statusReason = reason;
        log.debug("{} is a {} reason: {}", new Object[]{this.name, status, this.statusReason});
        if (this.plugin.getConfig().putNamesInChat() && status == BotIdentification.Status.BOT) {
            this.plugin.getClient().addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Bot: " + ColorUtil.wrapWithColorTag((String)this.name, (Color)Color.RED), "");
        }
    }

    public void updateStatus() {
        if (this.status != null) {
            return;
        }
        int total = 0;
        int exact2t = 0;
        int exact1T = 0;
        int n = this.snapshotIndex - 2;
        for (int i = 1; i < n; ++i) {
            PlayerSnapshot prev = this.snapshots[i - 1];
            PlayerSnapshot cur = this.snapshots[i];
            PlayerSnapshot next = this.snapshots[i + 1];
            PlayerSnapshot next2 = this.snapshots[i + 2];
            if (prev.headIcon == null) continue;
            if (next2.tick - next.tick > 1) {
                i += 4;
                continue;
            }
            HeadIcon prevStyle = this.getStyleFor(prev.opponentWeapon);
            HeadIcon curStyle = this.getStyleFor(cur.opponentWeapon);
            HeadIcon nextStyle = this.getStyleFor(next.opponentWeapon);
            if (prevStyle == null || curStyle == null || nextStyle == null) continue;
            if (curStyle != nextStyle && next.headIcon == nextStyle && cur.headIcon != nextStyle && prevStyle != next.headIcon) {
                this.setStatus(BotIdentification.Status.HUMAN, "Same tick switch");
                return;
            }
            if (curStyle == prevStyle) continue;
            if (next.headIcon != curStyle && next2.headIcon == curStyle) {
                ++exact2t;
            } else if (next.headIcon == curStyle) {
                ++exact1T;
            }
            ++total;
        }
        double proportion = (double)(exact1T + exact2t) / (double)total;
        if (total > 3) {
            log.debug("{} 1t:{} 2t:{} total:{} {}%", new Object[]{this.name, exact1T, exact2t, total, String.format("%.2f", 100.0 * proportion)});
        }
        if (total > 6) {
            if (proportion >= 0.85) {
                this.setStatus(BotIdentification.Status.BOT, "85%+ 2t switches");
            } else if (proportion < 0.5) {
                this.setStatus(BotIdentification.Status.HUMAN, "50%- 2t switches");
            }
        }
    }

    private HeadIcon getStyleFor(int weaponItemId) {
        switch (weaponItemId) {
            case 23613: 
            case 23617: 
            case 23626: 
            case 23653: 
            case 25517: {
                return HeadIcon.MAGIC;
            }
            case 20408: 
            case 23601: 
            case 23611: 
            case 23619: 
            case 23630: {
                return HeadIcon.RANGED;
            }
        }
        return HeadIcon.MELEE;
    }
}

