/*
 * Decompiled with CFR 0.152.
 */
package com.lmsnotifier;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Provides;
import com.lmsnotifier.BotIdentification;
import com.lmsnotifier.DeathTracker;
import com.lmsnotifier.LMSConfig;
import com.lmsnotifier.LMSHiscores;
import com.lmsnotifier.LMSOverlay;
import com.lmsnotifier.LMSPlayer;
import com.lmsnotifier.LMSRank;
import com.lmsnotifier.LMSUtil;
import com.lmsnotifier.LootCrateHightlight;
import com.lmsnotifier.RankVisual;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.Player;
import net.runelite.api.TileObject;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldArea;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.AnimationChanged;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.GroundObjectDespawned;
import net.runelite.api.events.GroundObjectSpawned;
import net.runelite.api.events.InteractingChanged;
import net.runelite.api.events.WidgetClosed;
import net.runelite.api.events.WidgetLoaded;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.Notifier;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ClientShutdown;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Last Man Standing")
public class LMSPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(LMSPlugin.class);
    static final String CONFIG_GROUP_KEY = "lmsconfig";
    private static final int LOOT_CRATE = 29081;
    private static final WorldArea lmsCompetitiveLobby = new WorldArea(3138, 3639, 8, 7, 0);
    private static final WorldArea lmsCasualLobby = new WorldArea(3139, 3639, 6, 6, 1);
    private static final WorldArea lmsHighStakesLobby = new WorldArea(3138, 3639, 8, 7, 2);
    private static final Set<Integer> chestIds = ImmutableSet.of((Object)29069, (Object)29072);
    static final int FEROX_REGION_ID = 12600;
    boolean inGame = false;
    Map<WorldPoint, TileObject> chests = new HashMap<WorldPoint, TileObject>();
    Map<WorldPoint, TileObject> lootCrates = new HashMap<WorldPoint, TileObject>();
    List<LMSPlayer> localLMSPlayers = new LinkedList<LMSPlayer>();
    private boolean inLobby = false;
    @Inject
    private LMSHiscores lmsHiscores;
    @Inject
    private Client client;
    @Inject
    private LMSConfig config;
    @Inject
    private Notifier notifier;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private LMSOverlay overlay;
    @Inject
    DeathTracker deathTracker;
    @Inject
    BotIdentification botIdentification;

    protected void startUp() throws Exception {
        log.info("Lms Notifier started!");
        this.overlayManager.add((Overlay)this.overlay);
        this.deathTracker.load();
    }

    protected void shutDown() throws Exception {
        log.info("Lms Notifier stopped!");
        this.overlayManager.remove((Overlay)this.overlay);
        this.deathTracker.save();
    }

    @Subscribe
    public void onClientShutdown(ClientShutdown event) {
        CompletableFuture<Void> future = CompletableFuture.runAsync(this.deathTracker::save);
        event.waitFor(future);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() != GameState.LOADING) {
            return;
        }
        this.chests.clear();
        this.lootCrates.clear();
        if (this.inLobby && this.config.notifiesGameStart()) {
            this.notifier.notify("Last Man Standing has started!");
        }
    }

    @Subscribe
    public void onInteractingChanged(InteractingChanged event) {
        if (!this.inGame || this.client.getLocalPlayer().getWorldLocation().getRegionID() == 12600) {
            return;
        }
        if (event.getSource() instanceof Player && event.getTarget() instanceof Player) {
            Player s = (Player)event.getSource();
            Player t = (Player)event.getTarget();
            this.botIdentification.interaction(s, t);
            this.deathTracker.interactChanged(s, t);
        }
    }

    @Subscribe
    public void onAnimationChanged(AnimationChanged event) {
        if (!this.inGame || this.client.getLocalPlayer().getWorldLocation().getRegionID() == 12600) {
            return;
        }
        this.deathTracker.animationChanged(event.getActor());
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.inLobby = this.client.getLocalPlayer().getWorldLocation().distanceTo(lmsCompetitiveLobby) == 0 || this.client.getLocalPlayer().getWorldLocation().distanceTo(lmsCasualLobby) == 0 || this.client.getLocalPlayer().getWorldLocation().distanceTo(lmsHighStakesLobby) == 0;
        this.refreshNearbyPlayerRanks();
        this.botIdentification.tick();
    }

    private void refreshNearbyPlayerRanks() {
        if (!this.inGame || this.client.getLocalPlayer().getWorldLocation().getRegionID() == 12600 || this.config.rankVisual().equals((Object)RankVisual.NONE)) {
            this.localLMSPlayers.clear();
            return;
        }
        ArrayList<Player> players = new ArrayList<Player>(this.client.getPlayers());
        LocalPoint localPoint = this.client.getLocalPlayer().getLocalLocation();
        players.sort(Comparator.comparingInt(o -> LMSUtil.distSquared(o.getLocalLocation(), localPoint)));
        this.localLMSPlayers.clear();
        for (Player player : players) {
            LMSRank lmsRank;
            String name = player.getName();
            if (this.client.getLocalPlayer().getName().equals(name) || (lmsRank = this.lmsHiscores.getRankFor(name)) == null) continue;
            this.localLMSPlayers.add(new LMSPlayer(player, lmsRank));
        }
    }

    @Subscribe
    public void onWidgetClosed(WidgetClosed ev) {
        if (ev.getGroupId() == WidgetInfo.LMS_KDA.getGroupId()) {
            this.inGame = false;
            this.chests.clear();
            this.lootCrates.clear();
            this.botIdentification.reset();
        }
    }

    @Subscribe
    public void onWidgetLoaded(WidgetLoaded widgetLoaded) {
        if (widgetLoaded.getGroupId() == WidgetInfo.LMS_KDA.getGroupId()) {
            this.inGame = true;
        }
    }

    @Provides
    LMSConfig provideConfig(ConfigManager configManager) {
        return (LMSConfig)configManager.getConfig(LMSConfig.class);
    }

    boolean highlightChests() {
        switch (this.config.highlightChests()) {
            case NEVER: {
                return false;
            }
            case HAS_KEY: {
                return this.client.getItemContainer(InventoryID.INVENTORY).contains(20526) || this.client.getItemContainer(InventoryID.INVENTORY).contains(20608);
            }
        }
        return true;
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned event) {
        this.onTileObject(null, (TileObject)event.getGameObject());
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned event) {
        this.onTileObject((TileObject)event.getGameObject(), null);
    }

    @Subscribe
    public void onGroundObjectSpawned(GroundObjectSpawned event) {
        this.onTileObject(null, (TileObject)event.getGroundObject());
    }

    @Subscribe
    public void onGroundObjectDespawned(GroundObjectDespawned event) {
        this.onTileObject((TileObject)event.getGroundObject(), null);
    }

    private void onTileObject(TileObject oldObject, TileObject newObject) {
        if (oldObject != null) {
            WorldPoint oldLocation = oldObject.getWorldLocation();
            this.chests.remove(oldLocation);
            this.lootCrates.remove(oldLocation);
        }
        if (newObject == null) {
            return;
        }
        if (chestIds.contains(newObject.getId())) {
            this.chests.put(newObject.getWorldLocation(), newObject);
            return;
        }
        if (newObject.getId() == 29081) {
            this.lootCrates.put(newObject.getWorldLocation(), newObject);
        }
    }

    boolean highlightLootCrates() {
        return this.lootCrates.size() > 0 && !this.config.lootCrateHighlightType().equals((Object)LootCrateHightlight.NONE);
    }

    public Client getClient() {
        return this.client;
    }

    public LMSConfig getConfig() {
        return this.config;
    }
}

