/*
 * Decompiled with CFR 0.152.
 */
package com.lmsnotifier;

import com.lmsnotifier.BotDisplay;
import com.lmsnotifier.BotIdentification;
import com.lmsnotifier.ChestHightlightType;
import com.lmsnotifier.ColourUtil;
import com.lmsnotifier.DeathTracker;
import com.lmsnotifier.LMSConfig;
import com.lmsnotifier.LMSPlayer;
import com.lmsnotifier.LMSPlugin;
import com.lmsnotifier.LMSUtil;
import com.lmsnotifier.LootCrateHightlight;
import com.lmsnotifier.RankMetric;
import com.lmsnotifier.RankVisual;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.Point;
import net.runelite.api.TileObject;
import net.runelite.api.coords.LocalPoint;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;
import net.runelite.client.ui.overlay.OverlayUtil;
import net.runelite.client.util.ColorUtil;

class LMSOverlay
extends Overlay {
    private static final int MIN_SCORE = 500;
    private static final int MAX_SCORE = 3000;
    private final Client client;
    private final LMSConfig config;
    private final LMSPlugin plugin;

    @Inject
    private LMSOverlay(Client client, LMSConfig config, LMSPlugin plugin) {
        this.client = client;
        this.config = config;
        this.plugin = plugin;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.LOW);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.plugin.inGame) {
            return null;
        }
        if (this.plugin.highlightChests()) {
            this.renderChests(graphics);
        }
        if (this.plugin.highlightLootCrates()) {
            this.renderLootCrates(graphics);
        }
        if (!this.config.rankVisual().equals((Object)RankVisual.NONE)) {
            this.renderRanks(graphics);
        }
        if (this.config.getBotDisplay() != BotDisplay.NONE) {
            this.renderBots(graphics);
        }
        if (this.config.overlayKillDeaths()) {
            this.renderKillDeaths(graphics);
        }
        return null;
    }

    private void renderKillDeaths(Graphics2D graphics) {
        for (LMSPlayer lmsPlayer : this.plugin.localLMSPlayers) {
            String text;
            Point textLocation;
            DeathTracker.KD kd = this.plugin.deathTracker.getKD(lmsPlayer.player.getName());
            if (kd.kills <= 0 && kd.deaths <= 0 || (textLocation = lmsPlayer.player.getCanvasTextLocation(graphics, text = kd.kills + "-" + kd.deaths, 0)) == null) continue;
            OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)new Point(textLocation.getX(), textLocation.getY() + 12), (String)text, (Color)Color.WHITE);
        }
    }

    private void renderBots(Graphics2D graphics) {
        for (LMSPlayer lmsPlayer : this.plugin.localLMSPlayers) {
            Point textLocation;
            String text;
            Color color;
            BotIdentification.Status status = this.plugin.botIdentification.statusFor(lmsPlayer.player.getName());
            if (this.config.getBotDisplay() == BotDisplay.BOTS_ONLY && status != BotIdentification.Status.BOT) continue;
            switch (status) {
                case BOT: {
                    color = Color.RED;
                    text = "Bot";
                    break;
                }
                case HUMAN: {
                    color = Color.GREEN;
                    text = "Human";
                    break;
                }
                default: {
                    color = Color.WHITE;
                    text = "?";
                }
            }
            if ((textLocation = lmsPlayer.player.getCanvasTextLocation(graphics, text, 0)) == null) continue;
            OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)new Point(textLocation.getX(), textLocation.getY() + 24), (String)text, (Color)color);
        }
    }

    private void renderRanks(Graphics2D graphics) {
        for (LMSPlayer lmsPlayer : this.plugin.localLMSPlayers) {
            Point textLocation;
            Color colour;
            if (this.config.metricHeatmap()) {
                int clampedScore = Math.max(500, Math.min(lmsPlayer.lmsRank.score, 3000));
                double proportion = (double)(clampedScore - 500) / 2500.0;
                colour = new Color(ColourUtil.interpolateBetweenRgbs(65280, 0xFF0000, proportion));
            } else {
                colour = this.config.metricColour();
            }
            String text = "";
            if (this.config.rankMetric().equals((Object)RankMetric.RANK)) {
                text = lmsPlayer.lmsRank.rank < 0 ? "n/a" : Integer.toString(lmsPlayer.lmsRank.rank);
            } else if (this.config.rankMetric().equals((Object)RankMetric.SCORE)) {
                String string = text = lmsPlayer.lmsRank.score < 0 ? "n/a" : Integer.toString(lmsPlayer.lmsRank.score);
            }
            if ((textLocation = lmsPlayer.player.getCanvasTextLocation(graphics, text, 0)) == null) continue;
            OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)textLocation, (String)text, (Color)colour);
        }
    }

    private void renderLootCrates(Graphics2D graphics) {
        int max = this.config.lootCrateRadius() * this.config.lootCrateRadius() * 128 * 128;
        LocalPoint playerLocation = this.client.getLocalPlayer().getLocalLocation();
        for (TileObject object : this.plugin.lootCrates.values()) {
            Shape shape;
            if (LMSUtil.distSquared(object.getLocalLocation(), playerLocation) >= max) continue;
            if (this.config.lootCrateHighlightType().equals((Object)LootCrateHightlight.CLICK_BOX)) {
                shape = object.getClickbox();
                if (shape == null) continue;
                Color color = this.config.lootCrateColour();
                Color clickBoxColor = ColorUtil.colorWithAlpha((Color)color, (int)(color.getAlpha() / 12));
                graphics.setColor(color);
                graphics.draw(shape);
                graphics.setColor(clickBoxColor);
                graphics.fill(shape);
                continue;
            }
            if (this.config.lootCrateHighlightType().equals((Object)LootCrateHightlight.TILE)) {
                shape = object.getCanvasTilePoly();
                if (shape == null) continue;
                OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)shape, (Color)this.config.lootCrateColour());
                continue;
            }
            if (!this.config.lootCrateHighlightType().equals((Object)LootCrateHightlight.HULL) || (shape = ((GameObject)object).getConvexHull()) == null) continue;
            OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)shape, (Color)this.config.lootCrateColour());
        }
    }

    private void renderChests(Graphics2D graphics) {
        int max = this.config.chestRadius() * this.config.chestRadius() * 128 * 128;
        LocalPoint playerLocation = this.client.getLocalPlayer().getLocalLocation();
        for (TileObject object : this.plugin.chests.values()) {
            Shape shape;
            if (object.getPlane() != this.client.getPlane() || LMSUtil.distSquared(object.getLocalLocation(), playerLocation) >= max) continue;
            if (this.config.highlightChestType().equals((Object)ChestHightlightType.CLICK_BOX)) {
                shape = object.getClickbox();
                if (shape == null) continue;
                Color color = this.config.chestColour();
                Color clickBoxColor = ColorUtil.colorWithAlpha((Color)color, (int)(color.getAlpha() / 12));
                graphics.setColor(color);
                graphics.draw(shape);
                graphics.setColor(clickBoxColor);
                graphics.fill(shape);
                continue;
            }
            if (this.config.highlightChestType().equals((Object)ChestHightlightType.TILE)) {
                shape = object.getCanvasTilePoly();
                if (shape == null) continue;
                OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)shape, (Color)this.config.chestColour());
                continue;
            }
            if (!this.config.highlightChestType().equals((Object)ChestHightlightType.HULL) || (shape = ((GameObject)object).getConvexHull()) == null) continue;
            OverlayUtil.renderPolygon((Graphics2D)graphics, (Shape)shape, (Color)this.config.chestColour());
        }
    }
}

