/*
 * Decompiled with CFR 0.152.
 */
package com.lmsnotifier;

import com.lmsnotifier.LMSRank;
import javax.inject.Inject;
import net.runelite.client.hiscore.HiscoreEndpoint;
import net.runelite.client.hiscore.HiscoreManager;
import net.runelite.client.hiscore.HiscoreResult;
import net.runelite.client.hiscore.HiscoreSkill;
import net.runelite.client.hiscore.Skill;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LMSHiscores {
    private static final Logger log = LoggerFactory.getLogger(LMSHiscores.class);
    @Inject
    private HiscoreManager hiscoreManager;

    LMSHiscores() {
    }

    LMSRank getRankFor(String username) {
        String name = Text.sanitize((String)username);
        log.debug("Looking up hiscores for {}", (Object)username);
        HiscoreEndpoint endPoint = HiscoreEndpoint.NORMAL;
        HiscoreResult result = this.hiscoreManager.lookupAsync(name, endPoint);
        if (result != null) {
            Skill hiscoreSkill = result.getSkill(HiscoreSkill.LAST_MAN_STANDING);
            int score = hiscoreSkill.getLevel();
            int rank = hiscoreSkill.getRank();
            log.debug("Retrieved hiscores for {} {} {}", new Object[]{username, rank, score});
            return new LMSRank(rank, score);
        }
        return null;
    }
}

