/*
 * Decompiled with CFR 0.152.
 */
package com.lmsnotifier;

import com.lmsnotifier.BotDisplay;
import com.lmsnotifier.ChestHightlight;
import com.lmsnotifier.ChestHightlightType;
import com.lmsnotifier.LootCrateHightlight;
import com.lmsnotifier.RankMetric;
import com.lmsnotifier.RankVisual;
import java.awt.Color;
import net.runelite.client.config.Config;
import net.runelite.client.config.ConfigGroup;
import net.runelite.client.config.ConfigItem;
import net.runelite.client.config.ConfigSection;
import net.runelite.client.config.Range;

@ConfigGroup(value="lmsconfig")
public interface LMSConfig
extends Config {
    @ConfigSection(name="Chests", description="Chest highlighting options", position=4, closedByDefault=false)
    public static final String chestList = "chestList";
    @ConfigSection(name="Loot Crates", description="Loot Crate highlighting options", position=5, closedByDefault=false)
    public static final String lootCrateList = "lootCrateList";
    @ConfigSection(name="Player Ranks", description="Show Lms ranks/scores of players", position=6, closedByDefault=false)
    public static final String playerRanks = "playerRanks";
    @ConfigSection(name="Bot Detection", description="Options for showing potential bots", position=7, closedByDefault=false)
    public static final String botDetection = "botDetection";

    @ConfigItem(keyName="overlayKillDeaths", name="Overlay kills/deaths", description="3-0 means 3 kills and 0 deaths", position=1)
    default public boolean overlayKillDeaths() {
        return true;
    }

    @ConfigItem(keyName="fightResultInChat", name="Chatbox fight outcome", description="Display name of opponent you defeated / got killed by", position=2)
    default public boolean fightResultInChat() {
        return true;
    }

    @ConfigItem(keyName="notifyGameStart", name="Game Start Notification", description="Notifies you when LMS starts", position=3)
    default public boolean notifiesGameStart() {
        return true;
    }

    @ConfigItem(keyName="highlightChests", name="Highlight", description="When to highlight chests", section="chestList", position=0)
    default public ChestHightlight highlightChests() {
        return ChestHightlight.HAS_KEY;
    }

    @ConfigItem(keyName="highlightChestsType", name="Highlight Type", description="Tile, Hull, or Clickbox highlight for chests", section="chestList", position=1)
    default public ChestHightlightType highlightChestType() {
        return ChestHightlightType.CLICK_BOX;
    }

    @ConfigItem(keyName="chestColour", name="Colour", description="Chest highlight colour", section="chestList", position=2)
    default public Color chestColour() {
        return Color.CYAN;
    }

    @Range(min=1, max=50)
    @ConfigItem(keyName="chestRadius", name="Radius", description="Radius of squares to highlight chests within", section="chestList", position=3)
    default public int chestRadius() {
        return 25;
    }

    @ConfigItem(keyName="lootCrateHighlight", name="Highlight", description="Options for highlighting loot crates", section="lootCrateList", position=0)
    default public LootCrateHightlight lootCrateHighlightType() {
        return LootCrateHightlight.CLICK_BOX;
    }

    @ConfigItem(keyName="lootCrateColour", name="Colour", description="Loot Crate highlight colour", section="lootCrateList", position=1)
    default public Color lootCrateColour() {
        return Color.GREEN;
    }

    @Range(min=1, max=50)
    @ConfigItem(keyName="lootCrateRadius", name="Radius", description="Radius of squares to highlight loot crates within", section="lootCrateList", position=2)
    default public int lootCrateRadius() {
        return 25;
    }

    @ConfigItem(keyName="showPlayerRank", name="Rank Visual", description="Options for displaying other players lms rank", section="playerRanks", position=0)
    default public RankVisual rankVisual() {
        return RankVisual.NONE;
    }

    @ConfigItem(keyName="metricColour", name="Text Colour", description="Colour of the metric text", section="playerRanks", position=1)
    default public Color metricColour() {
        return Color.RED;
    }

    @ConfigItem(keyName="metricHeatmap", name="Heatmap", description="Colour metrics differently based on score", section="playerRanks", position=2)
    default public boolean metricHeatmap() {
        return true;
    }

    @ConfigItem(keyName="rankMetric", name="Metric", description="Display the LMS Score or Rank of players", section="playerRanks", position=3)
    default public RankMetric rankMetric() {
        return RankMetric.SCORE;
    }

    @ConfigItem(keyName="showBots", name="Text Overlay", description="Shows players who might be bots", section="botDetection", position=1)
    default public BotDisplay getBotDisplay() {
        return BotDisplay.BOTS_ONLY;
    }

    @ConfigItem(keyName="summarizeBots", name="Summarize bots", description="Displays the number of humans/bots encountered at the end of the game", section="botDetection", position=2)
    default public boolean summarizeBots() {
        return true;
    }

    @ConfigItem(keyName="botsInChat", name="Add bots to chat", description="Displays names of bots detected in the game chat", section="botDetection", position=3)
    default public boolean putNamesInChat() {
        return false;
    }
}

