/*
 * Decompiled with CFR 0.152.
 */
package com.lmsnotifier;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.lmsnotifier.AttackAnimation;
import com.lmsnotifier.LMSConfig;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Actor;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.client.RuneLite;

public class DeathTracker {
    private static final File SAVE_FILE = new File(RuneLite.RUNELITE_DIR, "lms-kd.json");
    @Inject
    private Client client;
    @Inject
    private LMSConfig config;
    private int lastAttackTick;
    private Player opponent;
    private Player potentialOpponent;
    private final Map<String, KD> deathMap = new HashMap<String, KD>();

    public void interactChanged(Player source, Player target) {
        if (source.equals(this.client.getLocalPlayer())) {
            this.potentialOpponent = target;
        } else if (target.equals(this.client.getLocalPlayer())) {
            this.potentialOpponent = source;
        }
    }

    public void animationChanged(Actor actor) {
        if (!(actor instanceof Player)) {
            return;
        }
        this.checkDeath(actor);
        if (!AttackAnimation.contains(actor.getAnimation())) {
            return;
        }
        Player player = (Player)actor;
        if (player.getName() == null) {
            return;
        }
        if (this.opponent != null && player.getName().equals(this.opponent.getName())) {
            this.lastAttackTick = this.client.getTickCount();
            return;
        }
        if (this.potentialOpponent != null && this.client.getTickCount() - this.lastAttackTick > 5 && player.getName().equals(this.potentialOpponent.getName())) {
            this.lastAttackTick = this.client.getTickCount();
            this.opponent = this.potentialOpponent;
        }
    }

    private void checkDeath(Actor actor) {
        KD kd;
        if (actor.getAnimation() != 836 || actor.getName() == null || this.opponent == null) {
            return;
        }
        if (actor.getName().equals(this.opponent.getName())) {
            kd = new KD(1, 0);
            if (this.config.fightResultInChat()) {
                this.client.addChatMessage(ChatMessageType.CONSOLE, "", "You killed " + this.opponent.getName(), "");
            }
        } else if (actor.getName().equals(this.client.getLocalPlayer().getName())) {
            kd = new KD(0, 1);
            if (this.config.fightResultInChat()) {
                this.client.addChatMessage(ChatMessageType.CONSOLE, "", "You died to " + this.opponent.getName(), "");
            }
        } else {
            return;
        }
        this.deathMap.merge(this.opponent.getName(), kd, KD::sum);
        this.opponent = null;
        this.lastAttackTick = 0;
    }

    public void load() {
        if (!SAVE_FILE.exists()) {
            return;
        }
        try {
            String json = new String(Files.readAllBytes(SAVE_FILE.toPath()));
            this.deathMap.putAll((Map)new Gson().fromJson(json, new TypeToken<Map<String, KD>>(){}.getType()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void save() {
        String json = new Gson().toJson(this.deathMap);
        try {
            Files.write(SAVE_FILE.toPath(), json.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public KD getKD(String name) {
        return this.deathMap.getOrDefault(name, new KD(0, 0));
    }

    public static final class KD {
        public final int kills;
        public final int deaths;

        public static KD sum(KD kd, KD kd1) {
            return new KD(kd.kills + kd1.kills, kd.deaths + kd1.deaths);
        }

        public int getKills() {
            return this.kills;
        }

        public int getDeaths() {
            return this.deaths;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof KD)) {
                return false;
            }
            KD other = (KD)o;
            if (this.getKills() != other.getKills()) {
                return false;
            }
            return this.getDeaths() == other.getDeaths();
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getKills();
            result = result * 59 + this.getDeaths();
            return result;
        }

        public String toString() {
            return "DeathTracker.KD(kills=" + this.getKills() + ", deaths=" + this.getDeaths() + ")";
        }

        public KD(int kills, int deaths) {
            this.kills = kills;
            this.deaths = deaths;
        }
    }
}

