/*
 * Decompiled with CFR 0.152.
 */
package com.lmsnotifier;

class ColourUtil {
    ColourUtil() {
    }

    static int interpolateBetweenRgbs(int rgb1, int rgb2, double proportion) {
        HsvColour first = ColourUtil.RgbToHsv(new RgbColour(rgb1));
        HsvColour second = ColourUtil.RgbToHsv(new RgbColour(rgb2));
        HsvColour result = new HsvColour(first.h + (int)(proportion * (double)(second.h - first.h)), first.s + (int)(proportion * (double)(second.s - first.s)), first.v + (int)(proportion * (double)(second.v - first.v)));
        RgbColour converted = ColourUtil.HsvToRgb(result);
        return (converted.r & 0xFF) << 16 | (converted.g & 0xFF) << 8 | converted.b & 0xFF;
    }

    private static RgbColour HsvToRgb(HsvColour hsv) {
        RgbColour rgb = new RgbColour(1, 1, 1);
        if (hsv.s == 0) {
            rgb.r = hsv.v;
            rgb.g = hsv.v;
            rgb.b = hsv.v;
            return rgb;
        }
        int region = hsv.h / 43;
        int remainder = (hsv.h - region * 43) * 6;
        int p = hsv.v * (255 - hsv.s) >> 8;
        int q = hsv.v * (255 - (hsv.s * remainder >> 8)) >> 8;
        int t = hsv.v * (255 - (hsv.s * (255 - remainder) >> 8)) >> 8;
        switch (region) {
            case 0: {
                rgb.r = hsv.v;
                rgb.g = t;
                rgb.b = p;
                break;
            }
            case 1: {
                rgb.r = q;
                rgb.g = hsv.v;
                rgb.b = p;
                break;
            }
            case 2: {
                rgb.r = p;
                rgb.g = hsv.v;
                rgb.b = t;
                break;
            }
            case 3: {
                rgb.r = p;
                rgb.g = q;
                rgb.b = hsv.v;
                break;
            }
            case 4: {
                rgb.r = t;
                rgb.g = p;
                rgb.b = hsv.v;
                break;
            }
            default: {
                rgb.r = hsv.v;
                rgb.g = p;
                rgb.b = q;
            }
        }
        return rgb;
    }

    private static HsvColour RgbToHsv(RgbColour rgb) {
        int rgbMax;
        int rgbMin;
        HsvColour hsv = new HsvColour(0, 0, 0);
        int n = rgb.r < rgb.g ? (rgb.r < rgb.b ? rgb.r : rgb.b) : (rgbMin = rgb.g < rgb.b ? rgb.g : rgb.b);
        hsv.v = rgbMax = rgb.r > rgb.g ? (rgb.r > rgb.b ? rgb.r : rgb.b) : (rgb.g > rgb.b ? rgb.g : rgb.b);
        if (hsv.v == 0) {
            hsv.h = 0;
            hsv.s = 0;
            return hsv;
        }
        hsv.s = 255 * (rgbMax - rgbMin) / hsv.v;
        if (hsv.s == 0) {
            hsv.h = 0;
            return hsv;
        }
        hsv.h = rgbMax == rgb.r ? 43 * (rgb.g - rgb.b) / (rgbMax - rgbMin) : (rgbMax == rgb.g ? 85 + 43 * (rgb.b - rgb.r) / (rgbMax - rgbMin) : 171 + 43 * (rgb.r - rgb.g) / (rgbMax - rgbMin));
        return hsv;
    }

    static class HsvColour {
        int h;
        int s;
        int v;

        HsvColour(int h, int s, int v) {
            this.h = h;
            this.s = s;
            this.v = v;
        }
    }

    static class RgbColour {
        int r;
        int g;
        int b;

        RgbColour(int r, int g, int b) {
            this.r = r;
            this.g = g;
            this.b = b;
        }

        RgbColour(int rgb) {
            this.r = rgb >> 16 & 0xFF;
            this.g = rgb >> 8 & 0xFF;
            this.b = rgb & 0xFF;
        }
    }
}

