/*
 * Decompiled with CFR 0.152.
 */
package com.lmsnotifier;

import com.lmsnotifier.BotDisplay;
import com.lmsnotifier.LMSConfig;
import com.lmsnotifier.LMSPlugin;
import com.lmsnotifier.PlayerSnapshot;
import com.lmsnotifier.PlayerTracker;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.Player;
import net.runelite.client.util.ColorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BotIdentification {
    private static final Logger log = LoggerFactory.getLogger(BotIdentification.class);
    private final Client client;
    private final LMSConfig config;
    private final LMSPlugin plugin;
    private final Map<String, PlayerTracker> playerToTracker = new HashMap<String, PlayerTracker>();
    private final Map<String, String> attackerToVictim = new HashMap<String, String>();
    private int tick;

    @Inject
    private BotIdentification(Client client, LMSConfig config, LMSPlugin plugin) {
        this.client = client;
        this.config = config;
        this.plugin = plugin;
    }

    public void reset() {
        if (this.config.summarizeBots()) {
            this.displaySummary();
        }
        this.playerToTracker.clear();
        this.attackerToVictim.clear();
        this.tick = 0;
    }

    private void displaySummary() {
        int bots = 0;
        int humans = 0;
        int unknowns = 0;
        for (PlayerTracker tracker : this.playerToTracker.values()) {
            if (tracker.status == null) {
                ++unknowns;
                continue;
            }
            switch (tracker.status) {
                case UNSURE: {
                    ++unknowns;
                    break;
                }
                case BOT: {
                    ++bots;
                    break;
                }
                case HUMAN: {
                    ++humans;
                }
            }
        }
        String message = "You saw " + ColorUtil.wrapWithColorTag((String)Integer.toString(humans), (Color)Color.RED) + " humans, " + ColorUtil.wrapWithColorTag((String)Integer.toString(bots), (Color)Color.RED) + " bots, and " + ColorUtil.wrapWithColorTag((String)Integer.toString(unknowns), (Color)Color.RED) + " unknowns that game.";
        this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", message, "");
    }

    private void dumpInfo() {
        this.playerToTracker.forEach((name, playerTracker) -> {
            System.out.println((String)name);
            for (PlayerSnapshot snapshot : playerTracker.snapshots) {
                if (snapshot == null) continue;
                System.out.println(snapshot);
            }
        });
    }

    public void tick() {
        if (!this.shouldAnalyze() || !this.plugin.inGame || this.client.getLocalPlayer().getWorldLocation().getRegionID() == 12600) {
            return;
        }
        ArrayList players = new ArrayList(this.client.getPlayers());
        for (Player player : players) {
            if (this.client.getLocalPlayer().getName().equals(player.getName())) continue;
            Player opponent = this.getOpponent(player);
            PlayerSnapshot snapshot = new PlayerSnapshot(player, opponent, this.tick);
            PlayerTracker tracker = this.playerToTracker.computeIfAbsent(player.getName(), name -> new PlayerTracker(player.getName(), this.plugin));
            tracker.addSnapshot(snapshot);
            tracker.updateStatus();
        }
        ++this.tick;
    }

    private boolean shouldAnalyze() {
        return this.config.putNamesInChat() || this.config.summarizeBots() || this.config.getBotDisplay() != BotDisplay.NONE;
    }

    private Player getOpponent(Player player) {
        String victim = this.attackerToVictim.get(player.getName());
        if (victim == null) {
            return null;
        }
        String victimsAttacker = this.attackerToVictim.get(victim);
        if (victimsAttacker == null) {
            return null;
        }
        return this.findPlayerByName(victim);
    }

    public Player findPlayerByName(String name) {
        for (Player player : this.client.getPlayers()) {
            if (!player.getName().equals(name)) continue;
            return player;
        }
        return null;
    }

    public Status statusFor(String name) {
        if (!this.playerToTracker.containsKey(name)) {
            return Status.UNSURE;
        }
        return this.playerToTracker.get(name).getStatus();
    }

    public void interaction(Player source, Player target) {
        this.attackerToVictim.put(source.getName(), target.getName());
    }

    static enum Status {
        UNSURE,
        BOT,
        HUMAN;

    }
}

