/*
 * Decompiled with CFR 0.152.
 */
package hsj.external.nexsoundreplacer;

import com.google.inject.Provides;
import hsj.external.nexsoundreplacer.nexSoundReplacerConfig;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Paths;
import javax.inject.Inject;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.runelite.api.Client;
import net.runelite.api.events.AreaSoundEffectPlayed;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Nex Sound Replacer")
public class nexSoundReplacerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(nexSoundReplacerPlugin.class);
    private static Clip teleportSound;
    @Inject
    private Client client;
    @Inject
    private nexSoundReplacerConfig config;

    protected void startUp() throws Exception {
        teleportSound = this.generateSoundClip(this.config.soundFile(), this.config.soundVolume());
    }

    protected void shutDown() throws Exception {
        teleportSound = null;
    }

    @Subscribe
    public void onAreaSoundEffectPlayed(AreaSoundEffectPlayed areaSoundEffectPlayed) {
        int soundId = areaSoundEffectPlayed.getSoundId();
        if (soundId == 5291 && teleportSound != null) {
            areaSoundEffectPlayed.consume();
            teleportSound.setFramePosition(0);
            teleportSound.start();
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("nexSoundReplacer")) {
            if (event.getKey().equals("teleportSoundFile")) {
                teleportSound = this.generateSoundClip(this.config.soundFile(), this.config.soundVolume());
            }
            if (event.getKey().equals("teleportSoundVolume") && teleportSound != null) {
                FloatControl control = (FloatControl)teleportSound.getControl(FloatControl.Type.MASTER_GAIN);
                if (control != null) {
                    control.setValue(this.config.soundVolume() / 2 - 45);
                }
                teleportSound.setFramePosition(0);
                teleportSound.start();
            }
        }
    }

    public Clip generateSoundClip(String soundFile, int volume) {
        Clip soundClip = null;
        AudioInputStream inputStream = null;
        try {
            URL url = Paths.get(soundFile, new String[0]).toUri().toURL();
            inputStream = AudioSystem.getAudioInputStream(url);
        }
        catch (IOException | UnsupportedAudioFileException e) {
            log.warn("Unable to create audio input stream: ", (Throwable)e);
        }
        if (inputStream == null) {
            return null;
        }
        try {
            soundClip = AudioSystem.getClip();
            soundClip.open(inputStream);
        }
        catch (IOException | LineUnavailableException e) {
            log.warn("Could not load sound file: ", (Throwable)e);
        }
        if (soundClip == null) {
            return null;
        }
        FloatControl control = (FloatControl)soundClip.getControl(FloatControl.Type.MASTER_GAIN);
        control.setValue(volume / 2 - 45);
        return soundClip;
    }

    @Provides
    nexSoundReplacerConfig provideConfig(ConfigManager configManager) {
        return (nexSoundReplacerConfig)configManager.getConfig(nexSoundReplacerConfig.class);
    }
}

