/*
 * Decompiled with CFR 0.152.
 */
package melky.resourcepacks.hub;

import com.google.common.reflect.TypeToken;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import javax.inject.Inject;
import melky.resourcepacks.ResourcePacksPlugin;
import melky.resourcepacks.hub.ResourcePackManifest;
import net.runelite.http.api.RuneLiteAPI;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcePacksClient {
    private static final Logger log = LoggerFactory.getLogger(ResourcePacksClient.class);
    private final OkHttpClient cachingClient;

    @Inject
    public ResourcePacksClient(OkHttpClient cachingClient) {
        this.cachingClient = cachingClient;
    }

    public List<ResourcePackManifest> downloadManifest() throws IOException {
        HttpUrl manifest = ResourcePacksPlugin.RAW_GITHUB.newBuilder().addPathSegment("github-actions").addPathSegment("manifest.js").build();
        try (Response res = this.cachingClient.newCall(new Request.Builder().url(manifest).build()).execute();){
            if (res.code() != 200) {
                throw new IOException("Non-OK response code: " + res.code());
            }
            String data = res.body().string();
            List list = (List)RuneLiteAPI.GSON.fromJson(data, new TypeToken<List<ResourcePackManifest>>(){}.getType());
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage downloadIcon(ResourcePackManifest plugin) throws IOException {
        if (!plugin.isHasIcon()) {
            return null;
        }
        HttpUrl url = ResourcePacksPlugin.RAW_GITHUB.newBuilder().addPathSegment(plugin.getCommit()).addPathSegment("icon.png").build();
        try (Response res = this.cachingClient.newCall(new Request.Builder().url(url).build()).execute();){
            byte[] bytes = res.body().bytes();
            Class<ImageIO> clazz = ImageIO.class;
            synchronized (ImageIO.class) {
                BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(bytes));
                // ** MonitorExit[var5_6] (shouldn't be in output)
                return bufferedImage;
            }
        }
    }
}

