/*
 * Decompiled with CFR 0.152.
 */
package melky.resourcepacks;

import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.reflect.Type;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import melky.resourcepacks.ResourcePacksConfig;
import melky.resourcepacks.ResourcePacksManager;
import melky.resourcepacks.WidgetOverride;
import melky.resourcepacks.event.ResourcePacksChanged;
import melky.resourcepacks.hub.ResourcePacksHubPanel;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.events.BeforeRender;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.client.RuneLite;
import net.runelite.client.callback.ClientThread;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.events.SessionClose;
import net.runelite.client.events.SessionOpen;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.plugins.interfacestyles.Skin;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import okhttp3.HttpUrl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Resource packs")
public class ResourcePacksPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(ResourcePacksPlugin.class);
    public static final File RESOURCEPACKS_DIR = new File(RuneLite.RUNELITE_DIR.getPath() + File.separator + "resource-packs-repository");
    public static final File NOTICE_FILE = new File(RESOURCEPACKS_DIR.getPath() + File.separator + "DO_NOT_EDIT_CHANGES_WILL_BE_OVERWRITTEN");
    public static final String BRANCH = "github-actions";
    public static final String OVERLAY_COLOR_CONFIG = "overlayBackgroundColor";
    public static final HttpUrl GITHUB = HttpUrl.parse((String)"https://github.com/melkypie/resource-packs");
    public static final HttpUrl RAW_GITHUB = HttpUrl.parse((String)"https://raw.githubusercontent.com/melkypie/resource-packs");
    public static final HttpUrl API_GITHUB = HttpUrl.parse((String)"https://api.github.com/repos/melkypie/resource-packs");
    private static boolean ignoreOverlayConfig = false;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private Client client;
    @Inject
    private ClientThread clientThread;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    private ResourcePacksConfig config;
    @Inject
    private ConfigManager configManager;
    @Inject
    private ResourcePacksManager resourcePacksManager;
    @Inject
    private ScheduledExecutorService executor;
    private ResourcePacksHubPanel resourcePacksHubPanel;
    private NavigationButton navButton;

    @Provides
    ResourcePacksConfig provideConfig(ConfigManager configManager) {
        return (ResourcePacksConfig)configManager.getConfig(ResourcePacksConfig.class);
    }

    protected void startUp() throws Exception {
        if (!RESOURCEPACKS_DIR.exists()) {
            RESOURCEPACKS_DIR.mkdirs();
        }
        if (!NOTICE_FILE.exists()) {
            NOTICE_FILE.createNewFile();
        }
        if (this.client.getGameState() == GameState.LOGGED_IN && !this.configManager.getConfiguration("interfaceStyles", "gameframe", (Type)Skin.DEFAULT.getDeclaringClass()).equals(Skin.DEFAULT) && !this.config.disableInterfaceStylesPrompt()) {
            this.setInterfaceStylesGameframeOption();
        }
        this.executor.submit(() -> {
            this.resourcePacksManager.refreshPlugins();
            this.clientThread.invokeLater(this.resourcePacksManager::updateAllOverrides);
        });
        this.resourcePacksHubPanel = (ResourcePacksHubPanel)((Object)this.injector.getInstance(ResourcePacksHubPanel.class));
        BufferedImage icon = ImageUtil.loadImageResource(((Object)((Object)this)).getClass(), (String)"/panel.png");
        this.navButton = NavigationButton.builder().tooltip("Resource packs hub").icon(icon).priority(10).panel((PluginPanel)this.resourcePacksHubPanel).build();
        if (!this.config.hideSidePanelButton()) {
            this.clientToolbar.addNavigation(this.navButton);
        }
    }

    protected void shutDown() throws Exception {
        this.clientThread.invokeLater(() -> {
            this.resourcePacksManager.adjustWidgetDimensions(false);
            this.resourcePacksManager.removeGameframe();
            this.resourcePacksManager.resetWidgetOverrides();
            this.resourcePacksManager.resetCrossSprites();
        });
        if (this.config.allowLoginScreen()) {
            this.resourcePacksManager.resetLoginScreen();
        }
        if (this.config.allowOverlayColor()) {
            this.resourcePacksManager.resetOverlayColor();
        }
        this.clientToolbar.removeNavigation(this.navButton);
    }

    @Subscribe
    public void onBeforeRender(BeforeRender event) {
        this.resourcePacksManager.adjustWidgetDimensions(true);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("resourcepacks")) {
            switch (event.getKey()) {
                case "allowSpellsPrayers": 
                case "allowColorPack": 
                case "colorPackOverlay": 
                case "colorPack": 
                case "resourcePack": {
                    this.clientThread.invokeLater(this.resourcePacksManager::updateAllOverrides);
                    break;
                }
                case "allowOverlayColor": {
                    if (this.config.allowOverlayColor()) {
                        this.clientThread.invokeLater(this.resourcePacksManager::updateAllOverrides);
                        break;
                    }
                    this.resourcePacksManager.resetOverlayColor();
                    break;
                }
                case "allowCrossSprites": {
                    if (this.config.allowCrossSprites()) {
                        this.clientThread.invokeLater(this.resourcePacksManager::changeCrossSprites);
                        break;
                    }
                    this.resourcePacksManager.resetCrossSprites();
                    break;
                }
                case "allowLoginScreen": {
                    if (this.config.allowLoginScreen()) {
                        this.clientThread.invokeLater(this.resourcePacksManager::updateAllOverrides);
                        break;
                    }
                    this.resourcePacksManager.resetLoginScreen();
                    break;
                }
                case "hideSidePanelButton": {
                    this.clientThread.invokeLater(this::toggleSidePanelButton);
                }
            }
        } else if (event.getGroup().equals("banktags") && event.getKey().equals("useTabs")) {
            this.clientThread.invoke(this.resourcePacksManager::reloadBankTagSprites);
        } else if (this.config.allowOverlayColor() && !ignoreOverlayConfig && event.getGroup().equals("runelite") && event.getKey().equals(OVERLAY_COLOR_CONFIG)) {
            this.configManager.setConfiguration("resourcepacks", "originalOverlayColor", event.getNewValue());
        }
    }

    @Subscribe
    public void onResourcePacksChanged(ResourcePacksChanged packsChanged) {
        SwingUtilities.invokeLater(() -> this.resourcePacksHubPanel.reloadResourcePackList(packsChanged.getNewManifest()));
    }

    @Subscribe
    public void onSessionOpen(SessionOpen event) {
        this.executor.submit(this.resourcePacksManager::refreshPlugins);
    }

    @Subscribe
    public void onSessionClose(SessionClose event) {
        this.executor.submit(this.resourcePacksManager::refreshPlugins);
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGIN_SCREEN) {
            this.resourcePacksManager.changeCrossSprites();
        }
        if (this.client.getGameState() == GameState.LOGGED_IN && !this.configManager.getConfiguration("interfaceStyles", "gameframe", (Type)Skin.DEFAULT.getDeclaringClass()).equals(Skin.DEFAULT) && !this.config.disableInterfaceStylesPrompt()) {
            this.setInterfaceStylesGameframeOption();
            this.clientThread.invokeLater(this.resourcePacksManager::updateAllOverrides);
        }
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired event) {
        if (!this.resourcePacksManager.getColorProperties().isEmpty() && WidgetOverride.scriptWidgetOverrides.containsKey((Object)event.getScriptId())) {
            for (WidgetOverride widgetOverride : WidgetOverride.scriptWidgetOverrides.get((Object)event.getScriptId())) {
                this.resourcePacksManager.addPropertyToWidget(widgetOverride);
            }
        }
    }

    private void toggleSidePanelButton() {
        if (this.config.hideSidePanelButton()) {
            this.clientToolbar.removeNavigation(this.navButton);
            this.navButton.setSelected(false);
        } else {
            this.clientToolbar.addNavigation(this.navButton);
        }
    }

    private void setInterfaceStylesGameframeOption() {
        String message = new ChatMessageBuilder().append(ChatColorType.NORMAL).append("[").append(ChatColorType.HIGHLIGHT).append("Resource Packs").append(ChatColorType.NORMAL).append("] Your interface styles gameframe option was set to default to fix interfaces being misaligned. You can disable Resource packs changing it to default inside it's config").build();
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(message).build());
        this.configManager.setConfiguration("interfaceStyles", "gameframe", (Object)Skin.DEFAULT);
    }

    public static void setIgnoreOverlayConfig(boolean ignoreOverlayConfig) {
        ResourcePacksPlugin.ignoreOverlayConfig = ignoreOverlayConfig;
    }
}

