/*
 * Decompiled with CFR 0.152.
 */
package dekvall.bronzeman;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import com.google.gson.reflect.TypeToken;
import com.google.inject.Provides;
import dekvall.bronzeman.BronzemanModeConfig;
import dekvall.bronzeman.BronzemanModeOverlay;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.InventoryID;
import net.runelite.api.Item;
import net.runelite.api.MessageNode;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.ItemContainerChanged;
import net.runelite.api.events.ScriptPostFired;
import net.runelite.api.widgets.Widget;
import net.runelite.client.Notifier;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatCommandManager;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.http.api.RuneLiteAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Bronzeman Mode", description="Unlock items as you acquire them (by dekvall)")
public class BronzemanModePlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(BronzemanModePlugin.class);
    static final String CONFIG_GROUP = "bronzemanmode";
    public static final String CONFIG_KEY = "unlockeditems";
    private static final int AMOUNT_OF_TICKS_TO_SHOW_OVERLAY = 8;
    private static final int GE_SEARCH_BUILD_SCRIPT = 751;
    private static final String UNLOCKED_ITEMS_STRING = "!bronzemanunlocks";
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private Client client;
    @Inject
    private Notifier notifier;
    @Inject
    private BronzemanModeConfig config;
    @Inject
    private BronzemanModeOverlay overlay;
    @Inject
    private ConfigManager configManager;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private ChatCommandManager chatCommandManager;
    @Inject
    ItemManager itemManager;
    private final Set<Integer> unlockedItems = Sets.newHashSet();
    private List<BufferedImage> recentUnlockedImages;
    private boolean itemsRecentlyUnlocked;
    private int ticksToLastUnlock;

    @Provides
    BronzemanModeConfig provideConfig(ConfigManager configManager) {
        return (BronzemanModeConfig)configManager.getConfig(BronzemanModeConfig.class);
    }

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
        this.chatCommandManager.registerCommand(UNLOCKED_ITEMS_STRING, this::unlockedItemsLookup);
        if (this.client.getGameState() == GameState.LOGGED_IN) {
            this.loadUnlockedItems();
            this.unlockBond();
        }
        log.info("Bronzeman Mode started!");
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        this.chatCommandManager.unregisterCommand(UNLOCKED_ITEMS_STRING);
        this.unlockedItems.clear();
        log.info("Bronzeman Mode stopped!");
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN) {
            this.loadUnlockedItems();
        }
    }

    @Subscribe
    public void onItemContainerChanged(ItemContainerChanged event) {
        if (event.getItemContainer() != this.client.getItemContainer(InventoryID.INVENTORY)) {
            return;
        }
        Set recentUnlocks = Arrays.stream(this.client.getItemContainer(InventoryID.INVENTORY).getItems()).map(Item::getId).map(arg_0 -> ((ItemManager)this.itemManager).canonicalize(arg_0)).filter(id -> id != -1 && this.client.getItemDefinition(id.intValue()).isTradeable() && !this.unlockedItems.contains(id)).collect(Collectors.toSet());
        if (recentUnlocks.isEmpty()) {
            return;
        }
        log.info("Unlocked {} item(s), the id(s) were {}", (Object)recentUnlocks.size(), recentUnlocks);
        this.unlockedItems.addAll(recentUnlocks);
        this.recentUnlockedImages = recentUnlocks.stream().map(arg_0 -> ((ItemManager)this.itemManager).getImage(arg_0)).collect(Collectors.toList());
        this.ticksToLastUnlock = 0;
        this.itemsRecentlyUnlocked = true;
        this.saveUnlockedItems();
        if (this.config.sendNotification()) {
            this.notifier.notify("New bronzeman unlock!");
        }
        if (this.config.sendChatMessage()) {
            Iterator iterator = recentUnlocks.iterator();
            while (iterator.hasNext()) {
                int id2 = (Integer)iterator.next();
                this.sendChatMessage("You have unlocked a new item: " + this.client.getItemDefinition(id2).getName() + ".");
            }
        }
    }

    private void saveUnlockedItems() {
        String key = this.client.getUsername() + ".unlockeditems";
        if (this.unlockedItems == null || this.unlockedItems.isEmpty()) {
            this.configManager.unsetConfiguration(CONFIG_GROUP, key);
            return;
        }
        String json = RuneLiteAPI.GSON.toJson(this.unlockedItems);
        this.configManager.setConfiguration(CONFIG_GROUP, key, json);
    }

    private void loadUnlockedItems() {
        String key = this.client.getUsername() + ".unlockeditems";
        String json = this.configManager.getConfiguration(CONFIG_GROUP, key);
        this.unlockedItems.clear();
        if (!Strings.isNullOrEmpty((String)json)) {
            this.unlockedItems.addAll((Collection)RuneLiteAPI.GSON.fromJson(json, new TypeToken<List<Integer>>(){}.getType()));
        }
    }

    private void unlockBond() {
        this.unlockedItems.add(13190);
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        if (this.ticksToLastUnlock > 8) {
            this.itemsRecentlyUnlocked = false;
        }
        ++this.ticksToLastUnlock;
    }

    @Subscribe
    public void onScriptPostFired(ScriptPostFired event) {
        if (event.getScriptId() == 751) {
            this.killSearchResults();
        }
    }

    void killSearchResults() {
        Widget grandExchangeSearchResults = this.client.getWidget(162, 53);
        if (grandExchangeSearchResults == null) {
            return;
        }
        Widget[] children = grandExchangeSearchResults.getDynamicChildren();
        if (children == null || children.length < 2) {
            return;
        }
        for (int i = 0; i < children.length; i += 3) {
            if (this.unlockedItems.contains(children[i + 2].getItemId())) continue;
            children[i].setHidden(true);
            children[i + 1].setOpacity(170);
            children[i + 2].setOpacity(170);
        }
    }

    private void sendChatMessage(String chatMessage) {
        String message = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append(chatMessage).build();
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(message).build());
    }

    private void unlockedItemsLookup(ChatMessage chatMessage, String message) {
        MessageNode messageNode = chatMessage.getMessageNode();
        if (!messageNode.getName().equals(this.client.getLocalPlayer().getName())) {
            return;
        }
        ChatMessageBuilder builder = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append("You have unlocked ").append(ChatColorType.NORMAL).append(Integer.toString(this.unlockedItems.size())).append(ChatColorType.HIGHLIGHT).append(" items.");
        String response = builder.build();
        messageNode.setRuneLiteFormatMessage(response);
        this.chatMessageManager.update(messageNode);
        this.client.refreshChat();
    }

    List<BufferedImage> getRecentUnlockedImages() {
        return this.recentUnlockedImages;
    }

    boolean isItemsRecentlyUnlocked() {
        return this.itemsRecentlyUnlocked;
    }
}

