/*
 * Decompiled with CFR 0.152.
 */
package dekvall.bronzeman;

import dekvall.bronzeman.BronzemanModePlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.inject.Inject;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.OverlayPanel;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.components.ComponentOrientation;
import net.runelite.client.ui.overlay.components.ImageComponent;
import net.runelite.client.ui.overlay.components.LineComponent;
import net.runelite.client.ui.overlay.components.PanelComponent;

public class BronzemanModeOverlay
extends OverlayPanel {
    private static final int WIDTH = 72;
    private final BronzemanModePlugin plugin;
    private final PanelComponent panelComponent = new PanelComponent();

    @Inject
    public BronzemanModeOverlay(BronzemanModePlugin plugin) {
        super((Plugin)plugin);
        this.plugin = plugin;
        this.setPosition(OverlayPosition.TOP_CENTER);
    }

    public Dimension render(Graphics2D graphics) {
        this.panelComponent.getChildren().clear();
        if (!this.plugin.isItemsRecentlyUnlocked() || this.plugin.getRecentUnlockedImages().isEmpty()) {
            return null;
        }
        this.panelComponent.setOrientation(ComponentOrientation.VERTICAL);
        this.panelComponent.getChildren().add(LineComponent.builder().left("Unlocked:").leftColor(Color.GREEN).build());
        this.panelComponent.setPreferredSize(new Dimension(72, 0));
        for (BufferedImage image : this.plugin.getRecentUnlockedImages()) {
            this.panelComponent.getChildren().add(new ImageComponent(image));
        }
        return this.panelComponent.render(graphics);
    }
}

