/*
 * Decompiled with CFR 0.152.
 */
package com.scainburger.partyreadycheck;

import com.google.inject.Provides;
import com.scainburger.partyreadycheck.PartyReadyCheckConfig;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameTick;
import net.runelite.api.widgets.Widget;
import net.runelite.client.RuneLite;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.Text;
import net.runelite.client.util.WildcardMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Party Ready Check", description="Display an alert to check ready status of your party in ToB or ToA", tags={"tob", "theatre", "theater", "blood", "toa", "tombs", "amascut", "party", "ready", "check"})
public class PartyReadyCheckPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(PartyReadyCheckPlugin.class);
    final int TOB_HEADER_WIDGET_ID = 1835019;
    final int TOA_HEADER_WIDGET_ID = 50659332;
    final int TOB_PARTY_WIDGET_ID = 0x1C000C;
    final int TOA_PARTY_WIDGET_ID = 0x3050005;
    Widget tobRaidingPartyHeader;
    Widget toaRaidingPartyHeader;
    Widget raidingPartyWidget = null;
    private List<String> readyMessages = new ArrayList<String>();
    private List<String> unreadyMessages = new ArrayList<String>();
    @Inject
    private Client client;
    @Inject
    private PartyReadyCheckConfig config;
    private int rcTicksRemaining = -1;
    @Inject
    private ChatMessageManager chatMessageManager;

    @Subscribe
    public void onGameTick(GameTick tick) {
        if (this.rcTicksRemaining == 0) {
            this.rcTicksRemaining = -1;
            this.playSound("fail.wav", 2663);
            this.sendChatMessage("The ready check timed out.");
            this.resetFrame();
        }
        if (this.rcTicksRemaining > 0) {
            --this.rcTicksRemaining;
        }
    }

    private void sendChatMessage(String chatMessage) {
        String message = new ChatMessageBuilder().append(ChatColorType.HIGHLIGHT).append(chatMessage).build();
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(message).build());
    }

    public void startUp() throws Exception {
        this.convertCSVConfigStringToList(this.config.readyMessages(), this.readyMessages);
        this.convertCSVConfigStringToList(this.config.unreadyMessages(), this.unreadyMessages);
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) throws IOException {
        if (event.getGroup().equals("partyreadycheck")) {
            String key = event.getKey();
            if (key.equals("useAlternateSounds") && this.config.useAlternateSounds() && !Files.isDirectory(Paths.get(RuneLite.RUNELITE_DIR + "/partyreadycheck", new String[0]), new LinkOption[0])) {
                Files.createDirectory(Paths.get(RuneLite.RUNELITE_DIR + "/partyreadycheck", new String[0]), new FileAttribute[0]);
            }
            if (key.equals("readyMessages") || key.equals("unreadyMessages")) {
                this.convertCSVConfigStringToList(this.config.readyMessages(), this.readyMessages);
                this.convertCSVConfigStringToList(this.config.unreadyMessages(), this.unreadyMessages);
            }
        }
    }

    private void convertCSVConfigStringToList(String configString, List<String> listToConvertTo) {
        listToConvertTo.clear();
        listToConvertTo.addAll(Text.fromCSV((String)Text.standardize((String)configString)));
    }

    public void playSound(String customSound, int fallbackSound) {
        File soundDir = new File(RuneLite.RUNELITE_DIR, "partyreadycheck/" + customSound);
        if (!this.config.useAlternateSounds() || !Files.exists(soundDir.toPath(), new LinkOption[0])) {
            if (this.config.useAlternateSounds()) {
                log.info("\"Use alternate sounds\" is on, but a custom sound file is missing: " + soundDir);
            }
            this.client.playSoundEffect(fallbackSound);
            return;
        }
        Clip clip = null;
        try {
            clip = AudioSystem.getClip();
            BufferedInputStream fileStream = new BufferedInputStream(new FileInputStream(soundDir));
            AudioInputStream inputStream = AudioSystem.getAudioInputStream(fileStream);
            clip.open(inputStream);
            if (clip.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
                BooleanControl muteControl = (BooleanControl)clip.getControl(BooleanControl.Type.MUTE);
                muteControl.setValue(false);
                FloatControl gainControl = (FloatControl)clip.getControl(FloatControl.Type.MASTER_GAIN);
                int soundVol = (int)Math.round((double)this.client.getPreferences().getSoundEffectVolume() / 1.27);
                float newVol = (float)(Math.log((double)soundVol / 100.0) / Math.log(10.0) * 20.0);
                gainControl.setValue(newVol);
            }
            clip.start();
            final Clip finalClip = clip;
            clip.addLineListener(new LineListener(){

                @Override
                public void update(LineEvent myLineEvent) {
                    if (myLineEvent.getType() == LineEvent.Type.STOP) {
                        finalClip.close();
                    }
                }
            });
            return;
        }
        catch (Exception e) {
            log.warn("Could not play custom sound file: " + e.getMessage() + " (" + soundDir + ")");
            clip.close();
            this.client.playSoundEffect(fallbackSound);
            return;
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        if (chatMessage.getName().equals("")) {
            return;
        }
        this.tobRaidingPartyHeader = this.client.getWidget(1835019);
        this.toaRaidingPartyHeader = this.client.getWidget(50659332);
        this.raidingPartyWidget = null;
        if (this.tobRaidingPartyHeader != null && !this.tobRaidingPartyHeader.getText().toUpperCase(Locale.ROOT).equals("NO PARTY") && !this.tobRaidingPartyHeader.isHidden()) {
            this.raidingPartyWidget = this.client.getWidget(0x1C000C);
        }
        if (this.toaRaidingPartyHeader != null && !this.toaRaidingPartyHeader.getText().toUpperCase(Locale.ROOT).equals("NO PARTY") && !this.toaRaidingPartyHeader.isHidden()) {
            this.raidingPartyWidget = this.client.getWidget(0x3050005);
        }
        if (this.raidingPartyWidget == null || this.raidingPartyWidget.isHidden()) {
            return;
        }
        String msgStandardized = Text.standardize((String)chatMessage.getMessage());
        String msg = this.getMessage(this.unreadyMessages, msgStandardized, "UN R");
        msg = this.getMessage(this.readyMessages, msgStandardized, "R");
        if (msg.equals("R") || msg.equals("UN R")) {
            String name;
            int i;
            String[] playerNames = this.raidingPartyWidget.getText().split("<br>");
            StringBuilder outputText = new StringBuilder();
            String senderName = chatMessage.getName().replace("\u00a0", " ");
            senderName = senderName.replaceAll("\\<img=[0-9]+\\>", "");
            for (i = 0; i < playerNames.length; ++i) {
                name = playerNames[i];
                if (name.equals(senderName) && msg.equals("R")) {
                    outputText.append(name).append(" (R)");
                    if (this.rcTicksRemaining == -1) {
                        this.rcTicksRemaining = 100;
                        this.sendChatMessage(name + " has started a ready check.");
                        this.playSound("start.wav", 3925);
                    }
                } else if (name.equals(senderName + " (R)") && msg.equals("UN R")) {
                    outputText.append(senderName);
                } else {
                    outputText.append(name);
                }
                if (i >= playerNames.length - 1) continue;
                outputText.append("<br>");
            }
            this.raidingPartyWidget.setText(outputText.toString());
            playerNames = this.raidingPartyWidget.getText().split("<br>");
            for (i = 0; i < playerNames.length; ++i) {
                name = playerNames[i];
                if (name.equals("-") || name.endsWith(" (R)")) continue;
                return;
            }
            this.sendChatMessage("All party members are ready!");
            this.playSound("success.wav", 3924);
            this.resetFrame();
            this.rcTicksRemaining = -1;
        }
    }

    private String getMessage(List<String> configList, String input, String output) {
        for (String pattern : configList) {
            if (!WildcardMatcher.matches((String)pattern, (String)input)) continue;
            return output;
        }
        return input;
    }

    private void resetFrame() {
        String[] playerNames = this.raidingPartyWidget.getText().split("<br>");
        Object outputText = "";
        for (int i = 0; i < playerNames.length; ++i) {
            String name = playerNames[i];
            if (name.endsWith(" (R)")) {
                name = name.substring(0, name.length() - 4);
            }
            outputText = (String)outputText + name;
            if (i >= playerNames.length - 1) continue;
            outputText = (String)outputText + "<br>";
        }
        this.raidingPartyWidget.setText((String)outputText);
    }

    @Provides
    PartyReadyCheckConfig getConfig(ConfigManager configManager) {
        return (PartyReadyCheckConfig)configManager.getConfig(PartyReadyCheckConfig.class);
    }

    public Client getClient() {
        return this.client;
    }
}

