/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.runiterocks.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.EnumSet;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.EmptyBorder;
import net.runelite.client.ui.ColorScheme;
import net.runelite.client.ui.FontManager;
import net.runelite.http.api.worlds.World;
import net.runelite.http.api.worlds.WorldType;
import thestonedturtle.runiterocks.Rock;
import thestonedturtle.runiterocks.RuniteRock;

public class TableRow
extends JPanel {
    private static final int WORLD_COLUMN_WIDTH = 55;
    private static final int LOCATION_COLUMN_WIDTH = 45;
    private static final int TIME_COLUMN_WIDTH = 70;
    private static final Color RUNITE_COLOR = new Color(113, 160, 167);
    private static final Color CURRENT_WORLD = new Color(66, 227, 17);
    private static final Color DANGEROUS_WORLD = new Color(251, 62, 62);
    private static final Color MEMBERS_WORLD = new Color(210, 193, 53);
    private static final Color FREE_WORLD = new Color(200, 200, 200);
    private static final DateFormat TIME_FORMATTER = new SimpleDateFormat("h:mm:ss a");
    private JLabel worldLabel;
    private JLabel locationLabel;
    private final JLabel respawnLabel = new JLabel();
    private final JLabel lastVisitedLabel = new JLabel();
    private final World world;
    private final RuniteRock runiteRock;
    private final boolean respawnCounter;
    private final boolean visitCounter;
    private int updatedPlayerCount;
    private Color lastBackground;
    private boolean current = false;
    private long lastTimeClicked = System.currentTimeMillis();

    public TableRow(final World world, RuniteRock rock, final Consumer<World> hopToWorld, BiConsumer<Integer, Rock> removeRock, boolean respawnCounter, boolean visitCounter, final boolean doubleLeftClickToHop) {
        this.world = world;
        this.runiteRock = rock;
        this.updatedPlayerCount = world.getPlayers();
        this.respawnCounter = respawnCounter;
        this.visitCounter = visitCounter;
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(2, 0, 2, 0));
        this.setForeground(this.getWorldColor());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
                TableRow.this.lastBackground = TableRow.this.getBackground();
                TableRow.this.setBackground(TableRow.this.getBackground().brighter());
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
                TableRow.this.setBackground(TableRow.this.lastBackground);
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (doubleLeftClickToHop && System.currentTimeMillis() - TableRow.this.lastTimeClicked <= 500L) {
                    hopToWorld.accept(world);
                }
                TableRow.this.lastTimeClicked = System.currentTimeMillis();
            }
        });
        JPanel leftSide = new JPanel(new BorderLayout());
        JPanel rightSide = new JPanel(new BorderLayout());
        leftSide.setOpaque(false);
        rightSide.setOpaque(false);
        JPanel worldField = this.buildWorldField();
        worldField.setPreferredSize(new Dimension(55, 0));
        worldField.setOpaque(false);
        JPanel locationField = this.buildLocationField();
        locationField.setPreferredSize(new Dimension(45, 0));
        locationField.setOpaque(false);
        JPanel respawnField = this.buildRespawnField();
        respawnField.setPreferredSize(new Dimension(70, 0));
        respawnField.setOpaque(false);
        JPanel lastVisitedField = this.buildLastVisitedField();
        lastVisitedField.setBorder(new EmptyBorder(5, 5, 5, 5));
        lastVisitedField.setOpaque(false);
        leftSide.add((Component)worldField, "West");
        leftSide.add((Component)locationField, "Center");
        rightSide.add((Component)respawnField, "West");
        rightSide.add((Component)lastVisitedField, "Center");
        this.add((Component)leftSide, "West");
        this.add((Component)rightSide, "Center");
        JMenuItem hopTo = new JMenuItem("Hop-to world");
        hopTo.addActionListener(e -> hopToWorld.accept(world));
        JMenuItem remove = new JMenuItem("Remove entry");
        remove.addActionListener(e -> removeRock.accept(world.getId(), this.runiteRock.getRock()));
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.setBorder(new EmptyBorder(5, 5, 5, 5));
        popupMenu.add(hopTo);
        popupMenu.add(remove);
        this.setComponentPopupMenu(popupMenu);
    }

    private JPanel buildWorldField() {
        JPanel column = new JPanel(new BorderLayout(7, 0));
        column.setBorder(new EmptyBorder(0, 5, 0, 5));
        this.worldLabel = new JLabel(String.valueOf(this.world.getId()));
        column.add((Component)this.worldLabel, "Center");
        return column;
    }

    private JPanel buildLocationField() {
        JPanel column = new JPanel(new BorderLayout());
        column.setBorder(new EmptyBorder(0, 5, 0, 5));
        this.locationLabel = new JLabel(this.runiteRock.getRock().getName());
        this.locationLabel.setFont(FontManager.getRunescapeSmallFont());
        this.locationLabel.setToolTipText(this.runiteRock.getRock().getLocation());
        column.add((Component)this.locationLabel, "West");
        return column;
    }

    private JPanel buildRespawnField() {
        JPanel column = new JPanel(new BorderLayout());
        column.setBorder(new EmptyBorder(0, 5, 0, 5));
        this.respawnLabel.setFont(FontManager.getRunescapeSmallFont());
        this.updateRespawnLabel();
        column.add((Component)this.respawnLabel, "West");
        return column;
    }

    private void updateRespawnLabel() {
        if (this.runiteRock.isAvailable()) {
            this.respawnLabel.setText("Available");
            this.respawnLabel.setForeground(RUNITE_COLOR);
            return;
        }
        Instant respawn = this.runiteRock.getRespawnTime();
        if (this.respawnCounter) {
            Duration seconds = Duration.between(respawn, Instant.now());
            if (!seconds.isNegative()) {
                this.respawnLabel.setText("Available");
                this.respawnLabel.setForeground(ColorScheme.BRAND_ORANGE);
                return;
            }
            String timer = "-" + TableRow.getReadableTimeElapsed(seconds).trim();
            this.respawnLabel.setText(timer);
            this.respawnLabel.setForeground(Color.LIGHT_GRAY);
        } else {
            this.respawnLabel.setText(TIME_FORMATTER.format(Date.from(respawn)));
            this.respawnLabel.setForeground(ColorScheme.DARK_GRAY_COLOR);
        }
        if (!this.runiteRock.hasWitnessedDepletion()) {
            this.respawnLabel.setForeground(ColorScheme.BRAND_ORANGE);
        }
    }

    private JPanel buildLastVisitedField() {
        JPanel column = new JPanel(new BorderLayout());
        column.setBorder(new EmptyBorder(0, 5, 0, 5));
        this.lastVisitedLabel.setFont(FontManager.getRunescapeSmallFont());
        this.updateLastVisitedLabel();
        column.add((Component)this.lastVisitedLabel, "West");
        return column;
    }

    private void updateLastVisitedLabel() {
        Object text;
        Instant time = this.runiteRock.getLastSeenAt();
        if (time == null) {
            text = "Unknown";
        } else if (this.visitCounter) {
            Duration seconds = Duration.between(time, Instant.now());
            text = seconds.isNegative() ? "-" : "";
            text = (String)text + TableRow.getReadableTimeElapsed(seconds).trim();
        } else {
            text = TIME_FORMATTER.format(Date.from(time));
        }
        this.lastVisitedLabel.setText((String)text);
    }

    public void setCurrent(boolean current) {
        this.current = current;
        Color foreground = this.getWorldColor();
        this.worldLabel.setForeground(foreground);
        this.locationLabel.setForeground(foreground);
    }

    public void refresh() {
        this.updateRespawnLabel();
        this.updateLastVisitedLabel();
        this.revalidate();
        this.repaint();
    }

    private Color getWorldColor() {
        return this.current ? CURRENT_WORLD : TableRow.getWorldColor(this.world);
    }

    private static Color getWorldColor(World world) {
        EnumSet types = world.getTypes();
        if (types.contains(WorldType.PVP) || types.contains(WorldType.HIGH_RISK) || types.contains(WorldType.DEADMAN)) {
            return DANGEROUS_WORLD;
        }
        return types.contains(WorldType.MEMBERS) ? MEMBERS_WORLD : FREE_WORLD;
    }

    private static String getReadableTimeElapsed(Duration duration) {
        double seconds = Math.abs(duration.getSeconds());
        if (seconds <= 60.0) {
            return String.format("%2.0f", seconds) + "s";
        }
        double s = seconds % 3600.0 % 60.0;
        double m = Math.floor(seconds % 3600.0 / 60.0);
        double h = Math.floor(seconds / 3600.0);
        return h < 1.0 ? String.format("%2.0f:%02.0f", m, s) : String.format("%2.0f:%02.0f:%02.0f", h, m, s);
    }

    public World getWorld() {
        return this.world;
    }

    public RuniteRock getRuniteRock() {
        return this.runiteRock;
    }

    int getUpdatedPlayerCount() {
        return this.updatedPlayerCount;
    }
}

