/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.runiterocks;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.runelite.api.GameObject;
import net.runelite.api.coords.WorldPoint;
import net.runelite.http.api.worlds.World;
import thestonedturtle.runiterocks.Rock;
import thestonedturtle.runiterocks.RuniteRock;

public class WorldTracker {
    private final Map<Rock, RuniteRock> rockMap = new HashMap<Rock, RuniteRock>();
    private final World world;

    public WorldTracker(World world) {
        this.world = world;
    }

    @Nullable
    public RuniteRock updateRockState(WorldPoint worldPoint, GameObject gameObject) {
        Rock rock = Rock.getByWorldPoint(worldPoint);
        if (rock == null) {
            return null;
        }
        RuniteRock runeRock = this.rockMap.getOrDefault((Object)rock, new RuniteRock(this.world, rock));
        runeRock.setAvailable(gameObject.getId());
        this.rockMap.put(rock, runeRock);
        return runeRock;
    }

    public void removeRock(Rock rock) {
        this.rockMap.remove((Object)rock);
    }

    public void clear() {
        this.rockMap.clear();
    }

    public Collection<RuniteRock> getRuniteRocks() {
        return this.rockMap.values();
    }

    public World getWorld() {
        return this.world;
    }
}

