/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.runiterocks;

import com.google.inject.Provides;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.swing.SwingUtilities;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.GameObject;
import net.runelite.api.GameState;
import net.runelite.api.World;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.chat.ChatColorType;
import net.runelite.client.chat.ChatMessageBuilder;
import net.runelite.client.chat.ChatMessageManager;
import net.runelite.client.chat.QueuedMessage;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.game.WorldService;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.ClientToolbar;
import net.runelite.client.ui.NavigationButton;
import net.runelite.client.ui.PluginPanel;
import net.runelite.client.util.ImageUtil;
import net.runelite.client.util.WorldUtil;
import net.runelite.http.api.worlds.WorldResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thestonedturtle.runiterocks.Rock;
import thestonedturtle.runiterocks.RuniteRock;
import thestonedturtle.runiterocks.RuniteRocksConfig;
import thestonedturtle.runiterocks.RuniteRocksPanel;
import thestonedturtle.runiterocks.WorldTracker;

@PluginDescriptor(name="Runite Rocks")
public class RuniteRocksPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(RuniteRocksPlugin.class);
    private static final int DISPLAY_SWITCHER_MAX_ATTEMPTS = 3;
    @Inject
    private ChatMessageManager chatMessageManager;
    @Inject
    private Client client;
    @Inject
    private ClientToolbar clientToolbar;
    @Inject
    public RuniteRocksConfig config;
    @Inject
    private WorldService worldService;
    @Inject
    private ScheduledExecutorService executorService;
    private ScheduledFuture panelUpdateFuture;
    private final Map<WorldPoint, GameObject> spawnedRocks = new HashMap<WorldPoint, GameObject>();
    private final Map<WorldPoint, GameObject> queue = new HashMap<WorldPoint, GameObject>();
    private final Map<Integer, WorldTracker> worldMap = new HashMap<Integer, WorldTracker>();
    private WorldTracker tracker;
    private NavigationButton navButton;
    private RuniteRocksPanel panel;
    private World quickHopTargetWorld;
    private int displaySwitcherAttempts = 0;
    private boolean isHopping = true;

    @Provides
    RuniteRocksConfig provideConfig(ConfigManager configManager) {
        return (RuniteRocksConfig)configManager.getConfig(RuniteRocksConfig.class);
    }

    protected void startUp() throws Exception {
        this.panel = new RuniteRocksPanel(this);
        BufferedImage icon = ImageUtil.getResourceStreamFromClass(((Object)((Object)this)).getClass(), (String)"icon.png");
        this.navButton = NavigationButton.builder().tooltip("Runite Rocks").icon(icon).priority(10).panel((PluginPanel)this.panel).build();
        this.clientToolbar.addNavigation(this.navButton);
        if (this.client.getGameState().equals((Object)GameState.LOGGED_IN)) {
            net.runelite.http.api.worlds.World world = this.getWorld(this.client.getWorld());
            if (world == null) {
                log.warn("couldn't find world for id: {}", (Object)this.client.getWorld());
                return;
            }
            this.tracker = new WorldTracker(world);
            this.worldMap.put(this.client.getWorld(), this.tracker);
        }
        this.isHopping = this.client.getGameState().equals((Object)GameState.HOPPING);
        this.panelUpdateFuture = this.executorService.scheduleAtFixedRate(this::updatePanel, 1000L, 500L, TimeUnit.MILLISECONDS);
    }

    protected void shutDown() throws Exception {
        if (this.panelUpdateFuture != null) {
            this.panelUpdateFuture.cancel(true);
            this.panelUpdateFuture = null;
        }
        this.clientToolbar.removeNavigation(this.navButton);
        this.panel = null;
        this.queue.clear();
        this.worldMap.clear();
        this.tracker = null;
        this.spawnedRocks.clear();
        this.isHopping = false;
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        net.runelite.http.api.worlds.World world;
        switch (gameStateChanged.getGameState()) {
            case LOADING: {
                this.spawnedRocks.clear();
                if (!this.isHopping) break;
                return;
            }
            case HOPPING: {
                this.isHopping = true;
            }
            case LOGIN_SCREEN: {
                this.processSpawnedRocks();
                break;
            }
            case LOGGING_IN: 
            case CONNECTION_LOST: {
                this.spawnedRocks.clear();
                return;
            }
            case LOGGED_IN: {
                this.isHopping = false;
                break;
            }
            default: {
                return;
            }
        }
        int currentWorld = this.client.getWorld();
        if (this.tracker != null) {
            if (currentWorld == this.tracker.getWorld().getId()) {
                return;
            }
            int oldWorld = this.tracker.getWorld().getId();
            SwingUtilities.invokeLater(() -> this.panel.switchCurrentHighlight(currentWorld, oldWorld));
        }
        if ((world = this.getWorld(currentWorld)) == null) {
            log.warn("couldn't find world for id: {}", (Object)currentWorld);
            return;
        }
        this.tracker = this.worldMap.getOrDefault(currentWorld, new WorldTracker(world));
        this.worldMap.put(currentWorld, this.tracker);
    }

    @Subscribe
    public void onGameObjectSpawned(GameObjectSpawned e) {
        if (this.tracker == null) {
            return;
        }
        WorldPoint tileLocation = e.getTile().getWorldLocation();
        if (Rock.getByWorldPoint(tileLocation) != null) {
            this.queue.put(tileLocation, e.getGameObject());
        }
    }

    @Subscribe
    public void onGameObjectDespawned(GameObjectDespawned e) {
        if (this.tracker == null) {
            return;
        }
        WorldPoint tileLocation = e.getTile().getWorldLocation();
        if (Rock.getByWorldPoint(tileLocation) != null) {
            this.queue.put(tileLocation, e.getGameObject());
        }
    }

    @Subscribe
    public void onGameTick(GameTick tick) {
        if (this.quickHopTargetWorld != null) {
            if (this.client.getWidget(WidgetInfo.WORLD_SWITCHER_LIST) == null) {
                this.client.openWorldHopper();
                if (++this.displaySwitcherAttempts >= 3) {
                    String chatMessage = new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Failed to hop after ").append(ChatColorType.HIGHLIGHT).append(Integer.toString(this.displaySwitcherAttempts)).append(ChatColorType.NORMAL).append(" attempts.").build();
                    this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(chatMessage).build());
                    this.resetQuickHopper();
                }
            } else {
                this.client.hopToWorld(this.quickHopTargetWorld);
                this.resetQuickHopper();
            }
        }
        if (this.tracker != null && this.queue.size() > 0) {
            ArrayList<RuniteRock> rocks = new ArrayList<RuniteRock>();
            for (Map.Entry<WorldPoint, GameObject> entry : this.queue.entrySet()) {
                RuniteRock rock = this.tracker.updateRockState(entry.getKey(), entry.getValue());
                if (rock == null) {
                    log.warn("Error updating rock state: {} | {}", (Object)entry.getKey(), (Object)entry.getValue());
                    continue;
                }
                rocks.add(rock);
                this.spawnedRocks.put(entry.getKey(), entry.getValue());
            }
            this.queue.clear();
            SwingUtilities.invokeLater(() -> this.panel.updateRuniteRocks(rocks));
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged e) {
        if (!e.getGroup().equals("runiterocks")) {
            return;
        }
        SwingUtilities.invokeLater(this.panel::populate);
    }

    private void processSpawnedRocks() {
        if (this.spawnedRocks.size() == 0) {
            return;
        }
        ArrayList<RuniteRock> rocks = new ArrayList<RuniteRock>();
        for (Map.Entry<WorldPoint, GameObject> entry : this.spawnedRocks.entrySet()) {
            RuniteRock rock = this.tracker.updateRockState(entry.getKey(), entry.getValue());
            if (rock == null) {
                log.warn("Error updating spawned rock state: {} | {}", (Object)entry.getKey(), (Object)entry.getValue());
                continue;
            }
            rocks.add(rock);
        }
        this.spawnedRocks.clear();
        SwingUtilities.invokeLater(() -> this.panel.updateRuniteRocks(rocks));
    }

    @Subscribe
    public void onChatMessage(ChatMessage event) {
        if (event.getMessage().equals("Please finish what you're doing before using the World Switcher.")) {
            this.resetQuickHopper();
        }
    }

    @Nullable
    private net.runelite.http.api.worlds.World getWorld(int worldNumber) {
        WorldResult worldResult = this.worldService.getWorlds();
        if (worldResult != null) {
            return worldResult.findWorld(worldNumber);
        }
        return null;
    }

    void hopToWorld(net.runelite.http.api.worlds.World world) {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        if (world.getId() == this.client.getWorld()) {
            String chatMessage = new ChatMessageBuilder().append(ChatColorType.NORMAL).append("You are already in World ").append(ChatColorType.HIGHLIGHT).append(Integer.toString(world.getId())).build();
            this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(chatMessage).build());
            return;
        }
        String chatMessage = new ChatMessageBuilder().append(ChatColorType.NORMAL).append("Attempting to hop to World ").append(ChatColorType.HIGHLIGHT).append(Integer.toString(world.getId())).append(ChatColorType.NORMAL).append("..").build();
        this.chatMessageManager.queue(QueuedMessage.builder().type(ChatMessageType.CONSOLE).runeLiteFormattedMessage(chatMessage).build());
        this.quickHopTargetWorld = this.toRsWorld(world);
        this.client.changeWorld(this.quickHopTargetWorld);
        this.displaySwitcherAttempts = 0;
    }

    private World toRsWorld(net.runelite.http.api.worlds.World world) {
        World rsWorld = this.client.createWorld();
        rsWorld.setActivity(world.getActivity());
        rsWorld.setAddress(world.getAddress());
        rsWorld.setId(world.getId());
        rsWorld.setPlayerCount(world.getPlayers());
        rsWorld.setLocation(world.getLocation());
        rsWorld.setTypes(WorldUtil.toWorldTypes((EnumSet)world.getTypes()));
        return rsWorld;
    }

    private void resetQuickHopper() {
        this.displaySwitcherAttempts = 0;
        this.quickHopTargetWorld = null;
    }

    private void updatePanel() {
        if (this.tracker == null || this.panel.getRows().size() == 0) {
            return;
        }
        SwingUtilities.invokeLater(this.panel::updateList);
    }

    void removeRock(int world, Rock rock) {
        WorldTracker track = this.worldMap.get(world);
        if (track == null) {
            return;
        }
        track.removeRock(rock);
        SwingUtilities.invokeLater(this.panel::populate);
    }

    void clearRocks() {
        this.worldMap.clear();
        this.tracker.clear();
        this.worldMap.put(this.client.getWorld(), this.tracker);
        SwingUtilities.invokeLater(this.panel::populate);
    }

    public Map<Integer, WorldTracker> getWorldMap() {
        return this.worldMap;
    }

    public WorldTracker getTracker() {
        return this.tracker;
    }
}

