/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.runiterocks;

import com.google.common.collect.Ordering;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import net.runelite.client.ui.DynamicGridLayout;
import net.runelite.client.ui.PluginPanel;
import net.runelite.http.api.worlds.World;
import thestonedturtle.runiterocks.RuniteRock;
import thestonedturtle.runiterocks.RuniteRocksPlugin;
import thestonedturtle.runiterocks.WorldTracker;
import thestonedturtle.runiterocks.ui.TableHeader;
import thestonedturtle.runiterocks.ui.TableRow;

public class RuniteRocksPanel
extends PluginPanel {
    public static final int WORLD_COLUMN_WIDTH = 55;
    public static final int LOCATION_COLUMN_WIDTH = 45;
    public static final int TIME_COLUMN_WIDTH = 70;
    private static final int HEADER_HEIGHT = 20;
    private final List<TableRow> rows = new ArrayList<TableRow>();
    private final JPanel listContainer = new JPanel();
    private final RuniteRocksPlugin plugin;
    private TableHeader worldHeader;
    private TableHeader locationHeader;
    private TableHeader respawnHeader;
    private TableHeader lastVisitHeader;
    private ListOrdering sortOrder = ListOrdering.WORLD;
    private boolean ascendingOrder = false;

    RuniteRocksPanel(RuniteRocksPlugin plugin) {
        this.plugin = plugin;
        this.setBorder(null);
        this.setLayout((LayoutManager)new DynamicGridLayout(0, 1));
        JPanel headerContainer = this.buildHeader();
        this.listContainer.setLayout(new GridLayout(0, 1));
        this.add(headerContainer);
        this.add(this.listContainer);
    }

    void switchCurrentHighlight(int newWorld, int lastWorld) {
        for (TableRow row : this.rows) {
            int rowWorld = row.getWorld().getId();
            if (rowWorld == newWorld) {
                row.setCurrent(true);
                continue;
            }
            if (rowWorld != lastWorld) continue;
            row.setCurrent(false);
        }
        this.listContainer.revalidate();
        this.listContainer.repaint();
    }

    public void updateRuniteRocks(Collection<RuniteRock> runeRocks) {
        for (RuniteRock runiteRock : runeRocks) {
            this.updateRuniteRock(runiteRock);
        }
        this.updateList();
    }

    public void updateRuniteRock(@Nullable RuniteRock runeRock) {
        if (runeRock == null) {
            return;
        }
        boolean currentWorld = runeRock.getWorld() == this.plugin.getTracker().getWorld();
        for (TableRow row : this.rows) {
            if (!runeRock.matches(row.getRuniteRock())) continue;
            this.rows.remove(row);
            break;
        }
        this.rows.add(this.buildRow(runeRock.getWorld(), currentWorld, runeRock));
    }

    public void populate() {
        this.rows.clear();
        for (WorldTracker tracker : this.plugin.getWorldMap().values()) {
            World world = tracker.getWorld();
            boolean currentWorld = world == this.plugin.getTracker().getWorld();
            for (RuniteRock rock : tracker.getRuniteRocks()) {
                this.rows.add(this.buildRow(world, currentWorld, rock));
            }
        }
        this.updateList();
    }

    public void updateList() {
        Ordering<TableRow> ordering = new Ordering<TableRow>(){

            public int compare(@Nullable TableRow r1, @Nullable TableRow r2) {
                if (r1 == null || r2 == null) {
                    return 0;
                }
                switch (RuniteRocksPanel.this.sortOrder) {
                    case WORLD: {
                        return Integer.compare(r1.getRuniteRock().getWorld().getId(), r2.getRuniteRock().getWorld().getId());
                    }
                    case LOCATION: {
                        return r1.getRuniteRock().getRock().compareTo(r2.getRuniteRock().getRock());
                    }
                    case RESPAWN_TIME: {
                        if (RuniteRocksPanel.this.plugin.config.accurateRespawnPriority()) {
                            boolean r2Accurate;
                            boolean r1Accurate = r1.getRuniteRock().hasWitnessedDepletion() || r1.getRuniteRock().isAvailable();
                            boolean bl = r2Accurate = r2.getRuniteRock().hasWitnessedDepletion() || r2.getRuniteRock().isAvailable();
                            if (r1Accurate && !r2Accurate) {
                                return -1;
                            }
                            if (!r1Accurate && r2Accurate) {
                                return 1;
                            }
                        }
                        return r1.getRuniteRock().getRespawnTime().compareTo(r2.getRuniteRock().getRespawnTime());
                    }
                    case LAST_VISITED: {
                        return r1.getRuniteRock().getLastSeenAt().compareTo(r2.getRuniteRock().getLastSeenAt());
                    }
                }
                return 0;
            }
        };
        if (!this.ascendingOrder) {
            ordering = ordering.reverse();
        }
        ordering = ordering.nullsLast();
        this.rows.sort((Comparator<TableRow>)ordering);
        this.listContainer.removeAll();
        for (TableRow row : this.rows) {
            if (this.plugin.config.ignoreInaccurate() && !row.getRuniteRock().hasWitnessedDepletion() && !row.getRuniteRock().isAvailable()) continue;
            this.listContainer.add(row);
            row.refresh();
        }
        this.listContainer.revalidate();
        this.listContainer.repaint();
    }

    private void orderBy(ListOrdering order) {
        this.worldHeader.highlight(order == ListOrdering.WORLD, this.ascendingOrder);
        this.locationHeader.highlight(order == ListOrdering.LOCATION, this.ascendingOrder);
        this.respawnHeader.highlight(order == ListOrdering.RESPAWN_TIME, this.ascendingOrder);
        this.lastVisitHeader.highlight(order == ListOrdering.LAST_VISITED, this.ascendingOrder);
        this.sortOrder = order;
        this.updateList();
    }

    private JPanel buildHeader() {
        JPanel header = new JPanel((LayoutManager)new DynamicGridLayout(0, 2));
        JPanel leftSide = new JPanel(new BorderLayout());
        JPanel rightSide = new JPanel(new BorderLayout());
        this.worldHeader = new TableHeader("World", this.sortOrder == ListOrdering.WORLD, this.ascendingOrder, this::populate, this.plugin::clearRocks);
        this.worldHeader.setPreferredSize(new Dimension(55, 20));
        this.worldHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    return;
                }
                RuniteRocksPanel.this.ascendingOrder = RuniteRocksPanel.this.sortOrder != ListOrdering.WORLD || !RuniteRocksPanel.this.ascendingOrder;
                RuniteRocksPanel.this.orderBy(ListOrdering.WORLD);
            }
        });
        this.locationHeader = new TableHeader("Loc", this.sortOrder == ListOrdering.LOCATION, this.ascendingOrder, this::populate, this.plugin::clearRocks);
        this.locationHeader.setPreferredSize(new Dimension(45, 20));
        this.locationHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    return;
                }
                RuniteRocksPanel.this.ascendingOrder = RuniteRocksPanel.this.sortOrder != ListOrdering.LOCATION || !RuniteRocksPanel.this.ascendingOrder;
                RuniteRocksPanel.this.orderBy(ListOrdering.LOCATION);
            }
        });
        this.respawnHeader = new TableHeader("Respawn", this.sortOrder == ListOrdering.RESPAWN_TIME, this.ascendingOrder, this::populate, this.plugin::clearRocks);
        this.respawnHeader.setPreferredSize(new Dimension(70, 20));
        this.respawnHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    return;
                }
                RuniteRocksPanel.this.ascendingOrder = RuniteRocksPanel.this.sortOrder != ListOrdering.RESPAWN_TIME || !RuniteRocksPanel.this.ascendingOrder;
                RuniteRocksPanel.this.orderBy(ListOrdering.RESPAWN_TIME);
            }
        });
        this.lastVisitHeader = new TableHeader("Last Visit", this.sortOrder == ListOrdering.LAST_VISITED, this.ascendingOrder, this::populate, this.plugin::clearRocks);
        this.lastVisitHeader.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    return;
                }
                RuniteRocksPanel.this.ascendingOrder = RuniteRocksPanel.this.sortOrder != ListOrdering.LAST_VISITED || !RuniteRocksPanel.this.ascendingOrder;
                RuniteRocksPanel.this.orderBy(ListOrdering.LAST_VISITED);
            }
        });
        leftSide.add((Component)this.worldHeader, "West");
        leftSide.add((Component)this.locationHeader, "Center");
        rightSide.add((Component)this.respawnHeader, "West");
        rightSide.add((Component)this.lastVisitHeader, "Center");
        header.add(leftSide);
        header.add(rightSide);
        return header;
    }

    private TableRow buildRow(World world, boolean current, RuniteRock rock) {
        TableRow row = new TableRow(world, rock, this.plugin::hopToWorld, this.plugin::removeRock, this.plugin.config.respawnCounter(), this.plugin.config.visitCounter(), this.plugin.config.doubleLeftClickToHop());
        row.setCurrent(current);
        return row;
    }

    public List<TableRow> getRows() {
        return this.rows;
    }

    private static enum ListOrdering {
        WORLD,
        LOCATION,
        RESPAWN_TIME,
        LAST_VISITED;

    }
}

