/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.runiterocks;

import java.time.Instant;
import net.runelite.http.api.worlds.World;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thestonedturtle.runiterocks.Rock;

public class RuniteRock {
    private static final Logger log = LoggerFactory.getLogger(RuniteRock.class);
    private final World world;
    private final Rock rock;
    private boolean available = false;
    private Instant updatedAt = Instant.now();
    private Instant lastSeenAt = Instant.now();
    private boolean witnessedDepletion = false;

    public Instant getRespawnTime() {
        if (this.available) {
            return this.lastSeenAt;
        }
        return this.updatedAt.plus(this.rock.getRespawnDuration());
    }

    public void setAvailable(int gameObjectId) {
        this.lastSeenAt = Instant.now();
        if (gameObjectId == this.rock.getActivateState()) {
            if (this.available) {
                return;
            }
            this.available = true;
            this.updatedAt = Instant.now();
            this.witnessedDepletion = false;
        } else if (gameObjectId == this.rock.getDepletedState()) {
            if (!this.available) {
                if (this.getRespawnTime().compareTo(Instant.now()) < 0) {
                    this.updatedAt = Instant.now();
                    this.witnessedDepletion = false;
                }
                return;
            }
            this.available = false;
            this.updatedAt = Instant.now();
            this.witnessedDepletion = true;
        } else {
            log.warn("Unexpected object id for Rock: {} | {}", (Object)gameObjectId, (Object)this.rock);
        }
    }

    public boolean matches(RuniteRock other) {
        return this.getRock() == other.getRock() && this.getWorld().getId() == other.getWorld().getId();
    }

    public boolean hasWitnessedDepletion() {
        return this.witnessedDepletion;
    }

    public RuniteRock(World world, Rock rock) {
        this.world = world;
        this.rock = rock;
    }

    public World getWorld() {
        return this.world;
    }

    public Rock getRock() {
        return this.rock;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public Instant getUpdatedAt() {
        return this.updatedAt;
    }

    public Instant getLastSeenAt() {
        return this.lastSeenAt;
    }

    public void setUpdatedAt(Instant updatedAt) {
        this.updatedAt = updatedAt;
    }

    public void setLastSeenAt(Instant lastSeenAt) {
        this.lastSeenAt = lastSeenAt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RuniteRock)) {
            return false;
        }
        RuniteRock other = (RuniteRock)o;
        if (!other.canEqual(this)) {
            return false;
        }
        World this$world = this.getWorld();
        World other$world = other.getWorld();
        if (this$world == null ? other$world != null : !this$world.equals(other$world)) {
            return false;
        }
        Rock this$rock = this.getRock();
        Rock other$rock = other.getRock();
        if (this$rock == null ? other$rock != null : !((Object)((Object)this$rock)).equals((Object)other$rock)) {
            return false;
        }
        if (this.isAvailable() != other.isAvailable()) {
            return false;
        }
        Instant this$updatedAt = this.getUpdatedAt();
        Instant other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        Instant this$lastSeenAt = this.getLastSeenAt();
        Instant other$lastSeenAt = other.getLastSeenAt();
        if (this$lastSeenAt == null ? other$lastSeenAt != null : !((Object)this$lastSeenAt).equals(other$lastSeenAt)) {
            return false;
        }
        return this.witnessedDepletion == other.witnessedDepletion;
    }

    protected boolean canEqual(Object other) {
        return other instanceof RuniteRock;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        World $world = this.getWorld();
        result = result * 59 + ($world == null ? 43 : $world.hashCode());
        Rock $rock = this.getRock();
        result = result * 59 + ($rock == null ? 43 : ((Object)((Object)$rock)).hashCode());
        result = result * 59 + (this.isAvailable() ? 79 : 97);
        Instant $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        Instant $lastSeenAt = this.getLastSeenAt();
        result = result * 59 + ($lastSeenAt == null ? 43 : ((Object)$lastSeenAt).hashCode());
        result = result * 59 + (this.witnessedDepletion ? 79 : 97);
        return result;
    }

    public String toString() {
        return "RuniteRock(world=" + this.getWorld() + ", rock=" + this.getRock() + ", available=" + this.isAvailable() + ", updatedAt=" + this.getUpdatedAt() + ", lastSeenAt=" + this.getLastSeenAt() + ", witnessedDepletion=" + this.witnessedDepletion + ")";
    }
}

