/*
 * Decompiled with CFR 0.152.
 */
package thestonedturtle.runiterocks;

import com.google.common.collect.ImmutableMap;
import java.time.Duration;
import javax.annotation.Nullable;
import net.runelite.api.coords.WorldPoint;

public enum Rock {
    LAVA_MINE_1("LM1", "Lava Maze Mine (46 wildy)", new WorldPoint(3059, 3885, 0), 11376, 11390),
    LAVA_MINE_2("LM2", "Lava Maze Mine (46 wildy)", new WorldPoint(3060, 3884, 0), 11377, 11391),
    MINING_GUILD_1("MG1", "Mining Guild", new WorldPoint(3056, 9721, 0), 11376, 11390, 0.5),
    MINING_GUILD_2("MG2", "Mining Guild", new WorldPoint(3054, 9725, 0), 11377, 11391, 0.5),
    ISAFDAR_1("ELF1", "Isafdar (Outside Llyeta)", new WorldPoint(2280, 3160, 0), 11376, 11390),
    ISAFDAR_2("ELF2", "Isafdar (Outside Llyeta)", new WorldPoint(2278, 3156, 0), 11377, 11391),
    HEROES_GUILD_1("HG1", "Heroe's Guild", new WorldPoint(2941, 9884, 0), 11376, 11390),
    HEROES_GUILD_2("HG2", "Heroe's Guild", new WorldPoint(2937, 9882, 0), 11377, 11391),
    FROZEN_WASTE_PLATEAU_1("FWP1", "Frozen Waste Plateau (50+ wildy)", new WorldPoint(2948, 3914, 0), 11376, 11390),
    FROZEN_WASTE_PLATEAU_2("FWP2", "Frozen Waste Plateau (50+ wildy)", new WorldPoint(2964, 3933, 0), 11376, 11390),
    FROZEN_WASTE_PLATEAU_3("FWP3", "Frozen Waste Plateau (50+ wildy)", new WorldPoint(2976, 3937, 0), 11377, 11391),
    LAVA_MAZE_DUNGEON("LMD", "Lava Maze Dungeon", new WorldPoint(3046, 10265, 0), 11376, 11390),
    FOSSIL_ISLAND_1("FI1", "Fossil Island", new WorldPoint(3781, 3817, 0), 11376, 11390),
    FOSSIL_ISLAND_2("FI2", "Fossil Island", new WorldPoint(3779, 3814, 0), 11377, 11391),
    CENTRAL_FREMENNIK_ISLES("CFI", "Central Fremennik isles (NE Neitiznot)", new WorldPoint(2375, 3850, 0), 11376, 11390),
    MOURNER_TUNNELS("MT", "Mourner Tunnels", new WorldPoint(1993, 4664, 0), 11377, 11391),
    MYTHS_GUILD_1("MYTH1", "Myths' Guild", new WorldPoint(1937, 9020, 1), 11376, 11390),
    MYTHS_GUILD_2("MYTH2", "Myths' Guild", new WorldPoint(1939, 9019, 1), 11376, 11390),
    SOUTH_MOR_UI_REK_1("MUR1", "South Mor UI Rek (Tzhaar city)", new WorldPoint(2501, 5066, 0), 11376, 11390),
    SOUTH_MOR_UI_REK_2("MUR2", "South Mor UI Rek (Tzhaar city)", new WorldPoint(2498, 5065, 0), 11376, 11390),
    SOUTH_MOR_UI_REK_3("MUR3", "South Mor UI Rek (Tzhaar city)", new WorldPoint(2504, 5059, 0), 11376, 11390),
    TRAHAEARN_1("PRIF1", "Trahaearn (Prifddinas mine)", new WorldPoint(3284, 12459, 0), 36209, 36202),
    TRAHAEARN_2("PRIF2", "Trahaearn (Prifddinas mine)", new WorldPoint(3287, 12455, 0), 36209, 36202),
    TRAHAEARN_3("PRIF3", "Trahaearn (Prifddinas mine)", new WorldPoint(3291, 12441, 0), 36209, 36202),
    TRAHAEARN_4("PRIF4", "Trahaearn (Prifddinas mine)", new WorldPoint(3301, 12438, 0), 36209, 36202),
    ISLE_OF_SOULS("IOSD", "Isles of Souls Dungeon", new WorldPoint(2152, 9301, 0), 11376, 11390);

    public static final Duration RESPAWN_TIME;
    private static final ImmutableMap<WorldPoint, Rock> ROCK_LOCATIONS;
    private final String name;
    private final String location;
    private final WorldPoint worldPoint;
    private final int activateState;
    private final int depletedState;
    private double respawnRate = 1.0;

    public Duration getRespawnDuration() {
        if (this.respawnRate == 1.0) {
            return RESPAWN_TIME;
        }
        return Duration.ofMillis(Math.round((double)RESPAWN_TIME.toMillis() * this.respawnRate));
    }

    @Nullable
    public static Rock getByWorldPoint(WorldPoint point) {
        return (Rock)((Object)ROCK_LOCATIONS.get((Object)point));
    }

    private Rock(String name, String location, WorldPoint worldPoint, int activateState, int depletedState) {
        this.name = name;
        this.location = location;
        this.worldPoint = worldPoint;
        this.activateState = activateState;
        this.depletedState = depletedState;
    }

    private Rock(String name, String location, WorldPoint worldPoint, int activateState, int depletedState, double respawnRate) {
        this.name = name;
        this.location = location;
        this.worldPoint = worldPoint;
        this.activateState = activateState;
        this.depletedState = depletedState;
        this.respawnRate = respawnRate;
    }

    public String getName() {
        return this.name;
    }

    public String getLocation() {
        return this.location;
    }

    public WorldPoint getWorldPoint() {
        return this.worldPoint;
    }

    public int getActivateState() {
        return this.activateState;
    }

    public int getDepletedState() {
        return this.depletedState;
    }

    static {
        RESPAWN_TIME = Duration.ofMinutes(12L);
        ImmutableMap.Builder set = ImmutableMap.builder();
        for (Rock rock : Rock.values()) {
            set.put((Object)rock.getWorldPoint(), (Object)rock);
        }
        ROCK_LOCATIONS = set.build();
    }
}

