/*
 * Decompiled with CFR 0.152.
 */
package com.totalcost;

import com.google.inject.Provides;
import com.totalcost.TotalCostConfig;
import com.totalcost.models.ItemModel;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.inject.Inject;
import net.runelite.api.ChatMessageType;
import net.runelite.api.Client;
import net.runelite.api.ItemComposition;
import net.runelite.api.events.ChatMessage;
import net.runelite.api.events.MenuOptionClicked;
import net.runelite.api.widgets.Widget;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.game.ItemManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Total Cost")
public class TotalCostPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(TotalCostPlugin.class);
    private static final int SHOP_WIDGETID = 300;
    private static final Pattern TAG_REGEXP = Pattern.compile("<[^>]*>");
    private static final Pattern NUM_REGEXP = Pattern.compile("[^0-9]+");
    private static ItemModel item = new ItemModel(0, null, 0, 0, 0, 0);
    @Inject
    private Client client;
    @Inject
    private ItemManager itemManager;
    @Inject
    private TotalCostConfig config;

    @Subscribe
    public void onMenuOptionClicked(MenuOptionClicked menuOptionClicked) {
        block4: {
            if (menuOptionClicked.getMenuOption().equals("Value")) {
                item.setName(TotalCostPlugin.removeTags(menuOptionClicked.getMenuTarget(), TAG_REGEXP));
                try {
                    Widget[] shopItems;
                    if (this.client.getWidget(300, 16) == null) break block4;
                    Widget shopWidget = this.client.getWidget(300, 16);
                    for (Widget shopItem : shopItems = shopWidget.getChildren()) {
                        if (!shopItem.getName().contains(item.getName())) continue;
                        int id = this.itemManager.canonicalize(shopItem.getItemId());
                        item.setId(shopItem.getItemId());
                        item.setQuantity(shopItem.getItemQuantity());
                        item.setHaPrice(this.getHighAlchPrice(id));
                        item.setValue(TotalCostPlugin.convertHighAlchPriceToValue(item.getHaPrice()));
                        break;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Subscribe
    public void onChatMessage(ChatMessage chatMessage) {
        if (chatMessage.getMessage().contains("coins") && chatMessage.getType() == ChatMessageType.GAMEMESSAGE) {
            try {
                if (chatMessage.getMessage().contains(item.getName())) {
                    float buyTenCost = 0.0f;
                    float buyFiftyCost = 0.0f;
                    float buyAllCost = 0.0f;
                    int price = Integer.parseInt(TotalCostPlugin.removeTags(chatMessage.getMessage(), NUM_REGEXP));
                    item.setCurrentPrice(price);
                    for (int i = 1; i <= item.getQuantity(); ++i) {
                        double priceFromQuantity = (double)price + Math.floor((double)(price * i) * 0.001);
                        if (i <= 10) {
                            buyTenCost = (float)((double)buyTenCost + priceFromQuantity);
                        }
                        if (i <= 50) {
                            buyFiftyCost = (float)((double)buyFiftyCost + priceFromQuantity);
                        }
                        buyAllCost = (float)((double)buyAllCost + priceFromQuantity);
                    }
                    String itemString = this.addColorTags(item.getName());
                    String quantityString = this.addColorTags(String.valueOf(item.getQuantity()));
                    this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", "Total cost for " + itemString + " with " + quantityString + " in stock:", null);
                    if (this.config.buyTen() && item.getQuantity() >= 10) {
                        this.generateChatMessage(10, (int)buyTenCost);
                    }
                    if (this.config.buyFifty() && item.getQuantity() >= 50) {
                        this.generateChatMessage(50, (int)buyFiftyCost);
                    }
                    if (this.config.buyAll()) {
                        this.generateChatMessage(item.getQuantity(), (int)buyAllCost);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Provides
    TotalCostConfig provideConfig(ConfigManager configManager) {
        return (TotalCostConfig)configManager.getConfig(TotalCostConfig.class);
    }

    private static String removeTags(String str, Pattern pattern) {
        StringBuffer stringBuffer = new StringBuffer();
        Matcher matcher = pattern.matcher(str);
        while (matcher.find()) {
            String match;
            matcher.appendReplacement(stringBuffer, "");
            switch (match = matcher.group(0)) {
                case "<lt>": 
                case "<gt>": {
                    stringBuffer.append(match);
                }
            }
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    private int getHighAlchPrice(int itemId) {
        ItemComposition itemDef = this.itemManager.getItemComposition(itemId);
        return itemDef.getHaPrice();
    }

    private static int convertHighAlchPriceToValue(int highAlchPrice) {
        return highAlchPrice * 5 / 3;
    }

    private void generateChatMessage(int quantity, int cost) {
        if (item.getQuantity() > 0) {
            String coloredAmount = this.addColorTags(String.valueOf(quantity));
            String coloredCost = this.addColorTags(String.valueOf(cost));
            String average = String.valueOf(cost / quantity);
            average = this.addColorTags(average);
            String message = "Buy " + coloredAmount + " price: ~" + coloredCost + " coins.";
            if (this.config.showAvg()) {
                message = message + " (Avg: " + average + ")";
            }
            this.client.addChatMessage(ChatMessageType.GAMEMESSAGE, "", message, null);
        }
    }

    private String addColorTags(String string) {
        String hexColor = Integer.toHexString(this.config.highlightColor().getRGB()).substring(2);
        return "<col=" + hexColor + ">" + string + "</col>";
    }
}

