/*
 * Decompiled with CFR 0.152.
 */
package com.easyEmpty;

import com.easyEmpty.EasyEmptyConfig;
import com.google.inject.Provides;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.coords.WorldArea;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.ClientTick;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.Text;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Runecrafting Utilities", description="Provides various menu swaps to improve runecrafting", tags={"swap", "swapper", "menu", "entry", "menu entry swapper", "runecrafting", "pouch", "essence", "easy", "empty"})
public class EasyEmptyPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(EasyEmptyPlugin.class);
    int[] altars = new int[]{10571, 10315, 10827, 11339, 10059, 11083, 8523, 9035, 9803, 9547, 8779, 9291, 8508, 12875};
    int[] pouches = new int[]{5509, 5510, 5512, 5514, 26784, 5511, 5513, 5515, 26786};
    private static final WorldArea zmi = new WorldArea(new WorldPoint(3050, 5573, 0), 20, 20);
    boolean bankFill;
    boolean swapStam;
    boolean swapNeck;
    boolean emptyPouches;
    @Inject
    private Client client;
    @Inject
    private EasyEmptyConfig config;

    protected void startUp() {
        this.bankFill = this.config.bankFill();
        this.swapStam = this.config.swapStam();
        this.swapNeck = this.config.swapNeck();
        this.emptyPouches = this.config.emptyPouches();
        log.info("Easy Empty  started!");
    }

    protected void shutDown() {
        log.info("Easy Empty  stopped!");
    }

    @Subscribe
    public void onClientTick(ClientTick event) {
        if (this.client.getGameState() != GameState.LOGGED_IN || this.client.isMenuOpen() || this.client.isKeyPressed(81)) {
            return;
        }
        if (this.client.getWidget(WidgetInfo.BANK_CONTAINER) != null) {
            MenuEntry[] menuEntries = this.client.getMenuEntries();
            for (int i = menuEntries.length - 1; i >= 0; --i) {
                Widget widget = menuEntries[i].getWidget();
                MenuAction entryType = menuEntries[i].getType();
                String entryOption = menuEntries[i].getOption();
                if (widget == null || entryType != MenuAction.CC_OP_LOW_PRIORITY && entryType != MenuAction.CC_OP || !(this.bankFill && entryOption.startsWith("Fill") && ArrayUtils.contains((int[])this.pouches, (int)widget.getItemId()) || this.swapStam && entryOption.matches("Drink|Withdraw-1") && widget.getItemId() == 12631) && (!this.swapNeck || !entryOption.matches("Wear|Withdraw-1") || widget.getItemId() != 5521)) continue;
                MenuEntry entry = menuEntries[i];
                entry.setType(MenuAction.CC_OP);
                menuEntries[i] = menuEntries[menuEntries.length - 1];
                menuEntries[menuEntries.length - 1] = entry;
                this.client.setMenuEntries(menuEntries);
                break;
            }
        }
        boolean atAltar = false;
        WorldPoint playerLoc = this.client.getLocalPlayer().getWorldLocation();
        if (zmi.contains2D(playerLoc)) {
            atAltar = true;
        } else {
            for (int altarRegion : this.altars) {
                if (altarRegion != playerLoc.getRegionID()) continue;
                atAltar = true;
                break;
            }
        }
        if (atAltar) {
            MenuEntry[] menuEntryArray = this.client.getMenuEntries();
            if (this.emptyPouches && ArrayUtils.contains((int[])this.pouches, (int)menuEntryArray[menuEntryArray.length - 1].getItemId())) {
                MenuEntry entry2;
                int emptyIdx = -1;
                int topIdx = menuEntryArray.length - 1;
                for (int i = 0; i < topIdx; ++i) {
                    if (!Text.removeTags((String)menuEntryArray[i].getOption()).equals("Empty")) continue;
                    emptyIdx = i;
                    break;
                }
                if (emptyIdx == -1) {
                    return;
                }
                MenuEntry entry1 = menuEntryArray[emptyIdx];
                menuEntryArray[emptyIdx] = entry2 = menuEntryArray[topIdx];
                menuEntryArray[topIdx] = entry1;
                this.client.setMenuEntries(menuEntryArray);
            }
        }
    }

    @Subscribe
    public void onConfigChanged(ConfigChanged event) {
        if (event.getGroup().equals("easyempty")) {
            switch (event.getKey()) {
                case "bankFill": {
                    this.bankFill = this.config.bankFill();
                    break;
                }
                case "swapNeck": {
                    this.swapNeck = this.config.swapNeck();
                    break;
                }
                case "swapStam": {
                    this.swapStam = this.config.swapStam();
                    break;
                }
                case "emptyPouches": {
                    this.emptyPouches = this.config.emptyPouches();
                }
            }
        }
    }

    @Provides
    EasyEmptyConfig provideConfig(ConfigManager configManager) {
        return (EasyEmptyConfig)configManager.getConfig(EasyEmptyConfig.class);
    }
}

