/*
 * Decompiled with CFR 0.152.
 */
package MasterFarmer;

import MasterFarmer.MasterFarmerConfig;
import MasterFarmer.MasterFarmerNPC;
import MasterFarmer.MasterFarmerOverlay;
import com.google.inject.Provides;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.NPC;
import net.runelite.api.events.GameStateChanged;
import net.runelite.api.events.GameTick;
import net.runelite.api.events.NpcDespawned;
import net.runelite.api.events.NpcSpawned;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="MasterFarmer")
public class MasterFarmerPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(MasterFarmerPlugin.class);
    @Inject
    private Client client;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private MasterFarmerOverlay masterfarmeroverlay;
    private Instant lastTickUpdate;
    private final Map<Integer, MasterFarmerNPC> masterFarmers = new HashMap<Integer, MasterFarmerNPC>();

    @Provides
    MasterFarmerConfig getConfig(ConfigManager configManager) {
        return (MasterFarmerConfig)configManager.getConfig(MasterFarmerConfig.class);
    }

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.masterfarmeroverlay);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.masterfarmeroverlay);
        this.masterFarmers.clear();
    }

    @Subscribe
    public void onNpcSpawned(NpcSpawned npcSpawned) {
        NPC npc = npcSpawned.getNpc();
        String npcName = npc.getName();
        if (npcName == null) {
            return;
        }
        if (npc.getName().equals("Master Farmer")) {
            this.masterFarmers.putIfAbsent(npc.getIndex(), new MasterFarmerNPC(npc));
        }
    }

    @Subscribe
    public void onNpcDespawned(NpcDespawned npcDespawned) {
        NPC npc = npcDespawned.getNpc();
        String npcName = npc.getName();
        if (npcName == null) {
            return;
        }
        if (npc.getName().equals("Master Farmer")) {
            this.masterFarmers.remove(npc.getIndex());
        }
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged event) {
        if (event.getGameState() == GameState.LOGIN_SCREEN || event.getGameState() == GameState.HOPPING) {
            this.masterFarmers.clear();
        }
    }

    @Subscribe
    public void onGameTick(GameTick event) {
        this.lastTickUpdate = Instant.now();
        for (NPC npc : this.client.getNpcs()) {
            MasterFarmerNPC mf;
            String npcName = npc.getName();
            if (npcName == null || !npcName.equals("Master Farmer") || (mf = this.masterFarmers.get(npc.getIndex())) == null) continue;
            if (mf.getCurrentLocation().getX() != npc.getWorldLocation().getX() || mf.getCurrentLocation().getY() != npc.getWorldLocation().getY()) {
                mf.setCurrentLocation(npc.getWorldLocation());
                mf.setTimeWithoutMoving(0L);
                mf.setStoppedMovingTick(Instant.now());
                mf.setNpc(npc);
                continue;
            }
            mf.setTimeWithoutMoving(this.lastTickUpdate.getEpochSecond() - mf.getStoppedMovingTick().getEpochSecond());
        }
    }

    Instant getLastTickUpdate() {
        return this.lastTickUpdate;
    }

    Map<Integer, MasterFarmerNPC> getMasterFarmers() {
        return this.masterFarmers;
    }
}

