/*
 * Decompiled with CFR 0.152.
 */
package MasterFarmer;

import MasterFarmer.MasterFarmerConfig;
import MasterFarmer.MasterFarmerNPC;
import MasterFarmer.MasterFarmerPlugin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Point;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayUtil;

public class MasterFarmerOverlay
extends Overlay {
    private final Client client;
    private final MasterFarmerPlugin plugin;
    private final MasterFarmerConfig config;
    NumberFormat format = new DecimalFormat("#");
    int MASTER_FARMER_RESPAWN_TIME = 300;

    @Inject
    MasterFarmerOverlay(Client client, MasterFarmerPlugin plugin, MasterFarmerConfig config) {
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.plugin = plugin;
        this.config = config;
        this.client = client;
    }

    public Dimension render(Graphics2D graphics) {
        if (this.config.showOverlay()) {
            this.plugin.getMasterFarmers().forEach((id, npc) -> this.renderTimer((MasterFarmerNPC)npc, graphics));
        }
        return null;
    }

    private void renderTimer(MasterFarmerNPC npc, Graphics2D graphics) {
        double timeLeft = (long)this.MASTER_FARMER_RESPAWN_TIME - npc.getTimeWithoutMoving();
        if (timeLeft < 0.0) {
            timeLeft = 0.0;
        }
        String timeLeftString = String.valueOf(this.format.format(timeLeft));
        Point canvasPoint = npc.getNpc().getCanvasTextLocation(graphics, timeLeftString, npc.getNpc().getLogicalHeight() + this.config.timerHeight());
        if (canvasPoint != null && (double)this.config.maxDisplay() >= timeLeft) {
            OverlayUtil.renderTextLocation((Graphics2D)graphics, (Point)canvasPoint, (String)timeLeftString, (Color)this.config.timerColor());
        }
    }
}

