/*
 * Decompiled with CFR 0.152.
 */
package com.trevor.greenscreen;

import com.google.inject.Provides;
import com.trevor.greenscreen.GreenScreenConfig;
import com.trevor.greenscreen.GreenScreenOverlay;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.HotkeyListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Green Screen")
public class GreenScreenPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(GreenScreenPlugin.class);
    @Inject
    private Client client;
    @Inject
    private GreenScreenConfig config;
    @Inject
    private GreenScreenOverlay overlay;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private KeyManager keyManager;
    private boolean renderGreenscreen;
    private final HotkeyListener hotkeyListener = new HotkeyListener(() -> this.config.hotkey()){

        public void hotkeyPressed() {
            GreenScreenPlugin.this.renderGreenscreen = !GreenScreenPlugin.this.renderGreenscreen;
        }
    };

    protected void startUp() throws Exception {
        this.overlayManager.add((Overlay)this.overlay);
        this.renderGreenscreen = this.config.defaultState();
        this.keyManager.registerKeyListener((KeyListener)this.hotkeyListener);
    }

    protected void shutDown() throws Exception {
        this.overlayManager.remove((Overlay)this.overlay);
        this.keyManager.unregisterKeyListener((KeyListener)this.hotkeyListener);
    }

    @Provides
    GreenScreenConfig provideConfig(ConfigManager configManager) {
        return (GreenScreenConfig)configManager.getConfig(GreenScreenConfig.class);
    }

    public boolean isRenderGreenscreen() {
        return this.renderGreenscreen;
    }
}

