/*
 * Decompiled with CFR 0.152.
 */
package com.trevor.greenscreen;

import com.trevor.greenscreen.GreenScreenConfig;
import com.trevor.greenscreen.GreenScreenPlugin;
import com.trevor.greenscreen.Triangle;
import com.trevor.greenscreen.Vertex;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.Model;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;

public class GreenScreenOverlay
extends Overlay {
    private Client client;
    private GreenScreenConfig config;
    private GreenScreenPlugin plugin;

    @Inject
    public GreenScreenOverlay(Client client, GreenScreenPlugin plugin, GreenScreenConfig config) {
        super((Plugin)plugin);
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setLayer(OverlayLayer.ABOVE_SCENE);
        this.client = client;
        this.config = config;
        this.plugin = plugin;
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.plugin.isRenderGreenscreen()) {
            return null;
        }
        BufferedImage image = new BufferedImage(this.client.getCanvasWidth(), this.client.getCanvasHeight(), 6);
        Graphics g = image.getGraphics();
        g.setColor(this.config.greenscreenColor());
        g.fillRect(0, 0, image.getWidth(), image.getHeight());
        Polygon[] polygons = this.client.getLocalPlayer().getPolygons();
        Triangle[] triangles = this.getTriangles(this.client.getLocalPlayer().getModel());
        for (int i = 0; i < polygons.length; ++i) {
            Triangle t = triangles[i];
            if (t.getA().getY() == 6 && t.getB().getY() == 6 && t.getC().getY() == 6) continue;
            this.clearPolygon(image, polygons[i]);
        }
        graphics.drawImage((Image)image, 0, 0, null);
        return null;
    }

    private void clearPolygon(BufferedImage image, Polygon p) {
        Rectangle bounds = p.getBounds();
        for (double y = bounds.getMinY(); y < bounds.getMaxY(); y += 1.0) {
            for (double x = bounds.getMinX(); x < bounds.getMaxX(); x += 1.0) {
                if (!p.contains(x, y) || !(x >= 0.0) || !(x < (double)this.client.getCanvasWidth()) || !(y >= 0.0) || !(y < (double)this.client.getCanvasHeight())) continue;
                image.setRGB((int)x, (int)y, 0);
            }
        }
    }

    private List<Vertex> getVertices(Model model) {
        int[] verticesX = model.getVerticesX();
        int[] verticesY = model.getVerticesY();
        int[] verticesZ = model.getVerticesZ();
        int count = model.getVerticesCount();
        ArrayList<Vertex> vertices = new ArrayList<Vertex>(count);
        for (int i = 0; i < count; ++i) {
            Vertex v = new Vertex(verticesX[i], verticesY[i], verticesZ[i]);
            vertices.add(v);
        }
        return vertices;
    }

    private Triangle[] getTriangles(Model model) {
        int[] trianglesX = model.getFaceIndices1();
        int[] trianglesY = model.getFaceIndices2();
        int[] trianglesZ = model.getFaceIndices3();
        List<Vertex> vertices = this.getVertices(model);
        int count = model.getFaceCount();
        Triangle[] triangles = new Triangle[count];
        for (int i = 0; i < count; ++i) {
            Triangle triangle;
            int triangleX = trianglesX[i];
            int triangleY = trianglesY[i];
            int triangleZ = trianglesZ[i];
            triangles[i] = triangle = new Triangle(vertices.get(triangleX), vertices.get(triangleY), vertices.get(triangleZ));
        }
        return triangles;
    }
}

