/*
 * Decompiled with CFR 0.152.
 */
package com.meepspeak;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Provides;
import com.meepspeak.meepspeakConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.MenuAction;
import net.runelite.api.MenuEntry;
import net.runelite.api.NPC;
import net.runelite.api.events.BeforeRender;
import net.runelite.api.events.MenuEntryAdded;
import net.runelite.api.widgets.Widget;
import net.runelite.api.widgets.WidgetInfo;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.events.ConfigChanged;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="meepspeak", description="Changes NPC/item/widget names to meepspeak", tags={"meep"}, enabledByDefault=true, hidden=false)
public class meepspeakPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(meepspeakPlugin.class);
    private static final Set<MenuAction> NPC_MENU_ACTIONS = ImmutableSet.of((Object)MenuAction.NPC_FIRST_OPTION, (Object)MenuAction.NPC_SECOND_OPTION, (Object)MenuAction.NPC_THIRD_OPTION, (Object)MenuAction.NPC_FOURTH_OPTION, (Object)MenuAction.NPC_FIFTH_OPTION, (Object)MenuAction.WIDGET_TARGET_ON_NPC, (Object[])new MenuAction[]{MenuAction.EXAMINE_NPC, MenuAction.EXAMINE_OBJECT});
    private static final Set<MenuAction> ITEM_MENU_ACTIONS = ImmutableSet.of((Object)MenuAction.GROUND_ITEM_FIRST_OPTION, (Object)MenuAction.GROUND_ITEM_SECOND_OPTION, (Object)MenuAction.GROUND_ITEM_THIRD_OPTION, (Object)MenuAction.GROUND_ITEM_FOURTH_OPTION, (Object)MenuAction.GROUND_ITEM_FIFTH_OPTION, (Object)MenuAction.EXAMINE_ITEM_GROUND, (Object[])new MenuAction[]{MenuAction.CC_OP, MenuAction.CC_OP_LOW_PRIORITY, MenuAction.WIDGET_TARGET, MenuAction.WIDGET_TARGET_ON_PLAYER, MenuAction.WIDGET_TARGET_ON_NPC, MenuAction.WIDGET_TARGET_ON_GAME_OBJECT, MenuAction.WIDGET_TARGET_ON_GROUND_ITEM, MenuAction.WIDGET_TARGET_ON_WIDGET});
    private static final ImmutableMap<String, String> ItemNameRemap = ImmutableMap.builder().put((Object)"Dragon warhammer", (Object)"bonky hammer").put((Object)"Dinh's bulwark", (Object)"stompy eye ball shield").put((Object)"Zaryte crossbow", (Object)"kitty ear crossbow").build();
    private static final ImmutableMap<String, String> NPCNameRemap = ImmutableMap.builder().put((Object)"Tekton", (Object)"stompy rock man").put((Object)"Tekton (enraged)", (Object)"stompy rock man (enraged)").put((Object)"Vasa Nistirio", (Object)"mean stompy skele stone spider").put((Object)"Vespula", (Object)"ouchies sting bug").put((Object)"Abyssal Portal", (Object)"ouchies sting bug portal").put((Object)"Muttadile", (Object)"puppy dile").put((Object)"Skeletal Mystic", (Object)"ouchie skele mage").put((Object)"Baby Muttadile", (Object)"puppy dile").put((Object)"Big Muttadile", (Object)"puppy dile").put((Object)"Vanguard", (Object)"crawlie ouchie trio").put((Object)"Guardian", (Object)"rock throwing ouchie stone man").put((Object)"TzKal-Zuk", (Object)"poops ouch balls").put((Object)"Tzkal-Zuk", (Object)"poops ouch balls").put((Object)"The Maiden of Sugadinti", (Object)"creepy ouchie blood lady").put((Object)"Pestilent Bloat", (Object)"stinky stompy fat man").put((Object)"The Nylocas", (Object)"confusing switchy ouchie spooders").put((Object)"Nylocas Vasilias", (Object)"confusing switchy ouchie spooders").put((Object)"Xarpus", (Object)"flappy poison throw up bat").put((Object)"Sotetseg", (Object)"stompy rhino puppy wiff a death rune").put((Object)"Verzik Vitur", (Object)"yuck youchie fat spider lady").put((Object)"Verzik Vitur's Vault", (Object)"with a purple, imagine? po chew").put((Object)"The Final Challenge", (Object)"yuck youchie fat spider lady").put((Object)"Ice demon", (Object)"snowball throwing ouchie ice man").put((Object)"Corrupted Hunllef", (Object)"baby stompy moose puppy").put((Object)"Crystalline Hunllef", (Object)"baby stompy moose puppy").put((Object)"The Corrupted Gauntlet", (Object)"The baby stompy moose puppy (Corrupted)").put((Object)"The Gauntlet", (Object)"The baby stompy moose puppy").put((Object)"Great Olm", (Object)"lizard goat").put((Object)"Great Olm - Head", (Object)"lizard goat - Head").put((Object)"Great Olm - Left Hand", (Object)"lizard goat - Left Hand").put((Object)"Great Olm - Right Hand", (Object)"lizard goat - Right Hand").put((Object)"Great Olm (Right claw)", (Object)"lizard goat (Right claw)").put((Object)"Great Olm (Left claw)", (Object)"lizard goat (Left claw)").put((Object)"Corrupted scavenger", (Object)"sleepy alien").put((Object)"Zulrah", (Object)"punchy fire snake").put((Object)"Vorkath", (Object)"blue dragon puppy wiff wiffle horns").put((Object)"Kree'arra", (Object)"flappy ouchi birb man").put((Object)"K'ril Tsutsaroth", (Object)"stompy spipey red demon wiff lil goat feet").put((Object)"Commander Zilyana", (Object)"uglee godsword lady wiff wings").put((Object)"General Graardor", (Object)"ouchi unicorn ogre man").put((Object)"Nex", (Object)"yuck speedy winged demon lady thing wiff goat feet").put((Object)"Black dragon", (Object)"down ear dragon puppy wiff spipey tail").put((Object)"Blue dragon", (Object)"unicorn dragon wiff a ball on his tail").put((Object)"Cerberus", (Object)"three headed awoo lava puppy").put((Object)"Corporeal Beast", (Object)"giant mummy puppy").put((Object)"The Nightmare", (Object)"yucky crouchie nasty sleep lady").put((Object)"Phosani's Nightmare", (Object)"yucky crouchie nasty sleep lady").put((Object)"Chaos Elemental", (Object)"cotton candy monster").put((Object)"Giant Mole", (Object)"diggy scratchy feet baby wiff whiskers").put((Object)"Kalphite Queen", (Object)"spipey crawly flying bug wiff pinchers").put((Object)"Penance Queen", (Object)"one eyed creepy alien wiff a tummy bump").put((Object)"Demonic gorilla", (Object)"angry monkee").put((Object)"Brawler", (Object)"elephant man").put((Object)"Torcher", (Object)"worm bat").put((Object)"Ravager", (Object)"mole scratch man").put((Object)"Defiler", (Object)"kitty meow").put((Object)"Splatter", (Object)"bouncy ball").put((Object)"Jelly", (Object)"squishy marshmallow").put((Object)"King Black Dragon", (Object)"three headed uppy eardragon puppy").put((Object)"Scorpia", (Object)"pokey poison ouch bug").put((Object)"Callisto", (Object)"stompy ouchie wildy bear").put((Object)"Abyssal Sire", (Object)"creepy whippy spider demon wiff tails on his back").put((Object)"Kraken", (Object)"five legged yucky mouf octopus man").put((Object)"Thermonuclear Smoke Devil", (Object)"baby squid").put((Object)"Alchemical Hydra", (Object)"so muches heads ouchie slayer dragon (BUT EW ITS TOES)").put((Object)"Tempoross", (Object)"fishy whirlpool man").put((Object)"Zalcano", (Object)"sad angry stone lady wiff horse feet").put((Object)"Mimic", (Object)"treasure chest octopus man wiff his tongue out").put((Object)"Vet'ion", (Object)"purple tanky wildy boi who changes colors").put((Object)"Venenatis", (Object)"giant wildy spider wiff pointy teefs").put((Object)"Sarachnis", (Object)"big red spider wiff a weird head").put((Object)"Jal-MejRah", (Object)"big mouf stone bat").put((Object)"Jal-Ak", (Object)"blobby man").put((Object)"Jal-ImKot", (Object)"bat winged punchy worm").put((Object)"Jal-Xil", (Object)"ranger wiff boxing glubs").put((Object)"Jal-Zek", (Object)"flippy mager wiff lizard feets").put((Object)"JalTok-Jad", (Object)"froggy stone jad").put((Object)"Yt-Hurkot", (Object)"punchy healer mans").put((Object)"Jal-MejJak", (Object)"lil tree branch mans").put((Object)"Tz-Kih", (Object)"fiery bat man").put((Object)"Tz-Kek", (Object)"stripey blob man").put((Object)"Tok-Xil", (Object)"ranger wiff a yelling face").put((Object)"Yt-MejKot", (Object)"super slow punchy man").put((Object)"Ket-Zek", (Object)"spipey baby lizard mager").put((Object)"TzTok-Jad", (Object)"stompy fire spipey man").put((Object)"Inferno", (Object)"Inferno (poops ouch balls)").put((Object)"The Inferno", (Object)"Inferno (poops ouch balls)").put((Object)"The Fight Caves", (Object)"The Fight Caves (stompy fire spipey man)").put((Object)"TzHaar Fight Cave", (Object)"TzHaar Fight Cave (stompy fire spipey man)").build();
    private static final ImmutableMap<String, Set<Integer>> NPCFilterList = ImmutableMap.builder().put((Object)"Black dragon", (Object)ImmutableSet.of((Object)254)).put((Object)"Blue dragon", (Object)ImmutableSet.of((Object)268)).build();
    private final HashMap<String, String> CustomNPCRemap = new HashMap();
    private final HashMap<String, String> CustomItemRemap = new HashMap();
    @Inject
    private Client client;
    @Inject
    private meepspeakConfig meepspeakConfig;
    @Inject
    private ConfigManager configManager;

    @Provides
    meepspeakConfig getConfig(ConfigManager configManager) {
        return (meepspeakConfig)configManager.getConfig(meepspeakConfig.class);
    }

    protected void startUp() {
        this.parseConfig();
    }

    protected void shutDown() {
    }

    @Subscribe
    protected void onConfigChanged(ConfigChanged event) {
        if (!event.getGroup().equals("meepspeakConfig")) {
            return;
        }
        this.parseConfig();
    }

    private void parseConfig() {
        String[] kv;
        String[] pairs;
        this.CustomItemRemap.clear();
        this.CustomNPCRemap.clear();
        try {
            String customNPCs = this.meepspeakConfig.customNPCList();
            if (customNPCs.isEmpty()) {
                return;
            }
            for (String pair : pairs = customNPCs.split("\n")) {
                kv = pair.split(",");
                if (kv.length != 2) continue;
                this.CustomNPCRemap.put(kv[0], kv[1]);
            }
        }
        catch (Exception customNPCs) {
            // empty catch block
        }
        try {
            String customItems = this.meepspeakConfig.customItemList();
            if (customItems.isEmpty()) {
                return;
            }
            for (String pair : pairs = customItems.split("\n")) {
                kv = pair.split(",");
                if (kv.length != 2) continue;
                this.CustomItemRemap.put(kv[0], kv[1]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Subscribe
    private void onBeforeRender(BeforeRender event) {
        if (this.client.getGameState() != GameState.LOGGED_IN) {
            return;
        }
        for (Widget widgetRoot : this.client.getWidgetRoots()) {
            this.remapWidget(widgetRoot);
        }
    }

    private void remapWidget(Widget widget) {
        int groupId = WidgetInfo.TO_GROUP((int)widget.getId());
        int CHAT_MESSAGE = 162;
        int PRIVATE_MESSAGE = 163;
        int FRIENDS_LIST = 429;
        if (groupId == 162 || groupId == 163 || groupId == 429) {
            return;
        }
        Widget[] children = widget.getDynamicChildren();
        if (children == null) {
            return;
        }
        Widget[] childComponents = widget.getDynamicChildren();
        if (childComponents != null) {
            this.mapWidgetText(childComponents);
        }
        if ((childComponents = widget.getStaticChildren()) != null) {
            this.mapWidgetText(childComponents);
        }
        if ((childComponents = widget.getNestedChildren()) != null) {
            this.mapWidgetText(childComponents);
        }
    }

    private void mapWidgetText(Widget[] childComponents) {
        for (Widget component : childComponents) {
            this.remapWidget(component);
            String text = component.getText();
            if (text.isEmpty()) continue;
            if (this.meepspeakConfig.npcNameToggle()) {
                this.RemapWidgetText(component, text, NPCNameRemap);
            }
            if (this.meepspeakConfig.itemNameToggle()) {
                this.RemapWidgetText(component, text, ItemNameRemap);
            }
            this.RemapWidgetText(component, text, this.CustomNPCRemap);
            this.RemapWidgetText(component, text, this.CustomItemRemap);
        }
    }

    private void RemapWidgetText(Widget component, String text, HashMap<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!text.equalsIgnoreCase(entry.getKey())) continue;
            component.setText(text.replace(entry.getKey(), entry.getValue()));
            return;
        }
    }

    private void RemapWidgetText(Widget component, String text, ImmutableMap<String, String> map) {
        for (Map.Entry entry : map.entrySet()) {
            if (!text.equalsIgnoreCase((String)entry.getKey())) continue;
            component.setText(text.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue()));
            return;
        }
    }

    @Subscribe
    protected void onMenuEntryAdded(MenuEntryAdded event) {
        MenuEntry entry = event.getMenuEntry();
        if (NPC_MENU_ACTIONS.contains(entry.getType())) {
            if (this.meepspeakConfig.npcNameToggle() && this.shouldRemapName(entry)) {
                this.RemapMenuEntryText(entry, NPCNameRemap);
            }
            this.RemapMenuEntryText(entry, this.CustomNPCRemap);
        } else if (ITEM_MENU_ACTIONS.contains(entry.getType())) {
            if (this.meepspeakConfig.itemNameToggle()) {
                this.RemapMenuEntryText(entry, ItemNameRemap);
            }
            this.RemapMenuEntryText(entry, this.CustomItemRemap);
        }
    }

    private void RemapMenuEntryText(MenuEntry menuEntry, Map<String, String> map) {
        String target = menuEntry.getTarget();
        NPC npc = menuEntry.getNpc();
        String cleanTarget = null;
        cleanTarget = npc != null ? Text.removeTags((String)npc.getName()) : Text.removeTags((String)target);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!cleanTarget.equals(entry.getKey())) continue;
            menuEntry.setTarget(target.replace(entry.getKey(), entry.getValue()));
        }
    }

    private void RemapMenuEntryText(MenuEntry menuEntry, ImmutableMap<String, String> map) {
        this.RemapMenuEntryText(menuEntry, (Map<String, String>)map);
    }

    private boolean shouldRemapName(MenuEntry entry) {
        NPC npc = entry.getNpc();
        if (npc == null) {
            return true;
        }
        Set ids = (Set)NPCFilterList.get((Object)npc.getName());
        if (ids == null) {
            return true;
        }
        return ids.contains(npc.getId());
    }
}

