/*
 * Decompiled with CFR 0.152.
 */
package com.canvas;

import com.canvas.CanvasConfig;
import com.canvas.CanvasOverlay;
import com.canvas.Curve;
import com.google.inject.Provides;
import java.awt.Color;
import java.awt.event.MouseEvent;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import javax.inject.Inject;
import net.runelite.api.Client;
import net.runelite.api.GameState;
import net.runelite.api.Point;
import net.runelite.api.events.GameStateChanged;
import net.runelite.client.config.ConfigManager;
import net.runelite.client.eventbus.Subscribe;
import net.runelite.client.input.KeyListener;
import net.runelite.client.input.KeyManager;
import net.runelite.client.input.MouseAdapter;
import net.runelite.client.input.MouseListener;
import net.runelite.client.input.MouseManager;
import net.runelite.client.plugins.Plugin;
import net.runelite.client.plugins.PluginDescriptor;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayManager;
import net.runelite.client.util.HotkeyListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PluginDescriptor(name="Canvas")
public class CanvasPlugin
extends Plugin {
    private static final Logger log = LoggerFactory.getLogger(CanvasPlugin.class);
    @Inject
    private Client client;
    @Inject
    private KeyManager keyManager;
    @Inject
    private CanvasConfig config;
    private CanvasOverlay overlay;
    @Inject
    private OverlayManager overlayManager;
    @Inject
    private MouseManager mouseManager;
    private Deque<Curve> curve;
    private Point temp = null;
    public boolean isDrawing = false;
    public List<Deque<Curve>> curveList = new ArrayList<Deque<Curve>>();
    public List<Color> colorList = new ArrayList<Color>();
    public List<Integer> sizeList = new ArrayList<Integer>();
    private HotkeyListener[] hotkeys = new HotkeyListener[2];
    private boolean hotkeysEnabled = false;
    private final MouseAdapter mouseAdapter = new MouseAdapter(){

        public MouseEvent mouseMoved(MouseEvent e) {
            if (CanvasPlugin.this.isDrawing) {
                CanvasPlugin.this.updateMousePositions(new Point(e.getX(), e.getY()));
            }
            return e;
        }
    };

    private void initHotkeys() {
        this.hotkeys[0] = new HotkeyListener(() -> this.config.drawKey()){

            public void hotkeyPressed() {
                CanvasPlugin.this.colorList.add(CanvasPlugin.this.config.getColor());
                CanvasPlugin.this.sizeList.add(CanvasPlugin.this.config.getBrushSize());
                CanvasPlugin.this.curve = new ArrayDeque<Curve>();
                CanvasPlugin.this.isDrawing = true;
            }

            public void hotkeyReleased() {
                CanvasPlugin.this.isDrawing = false;
                CanvasPlugin.this.temp = null;
                CanvasPlugin.this.curveList.add(CanvasPlugin.this.curve);
                CanvasPlugin.this.curve = null;
            }
        };
        this.hotkeys[1] = new HotkeyListener(() -> this.config.undoKey()){

            public void hotkeyPressed() {
                if (CanvasPlugin.this.curveList.size() > 0 && CanvasPlugin.this.colorList.size() > 0 && CanvasPlugin.this.sizeList.size() > 0) {
                    CanvasPlugin.this.curveList.remove(CanvasPlugin.this.curveList.size() - 1);
                    CanvasPlugin.this.colorList.remove(CanvasPlugin.this.colorList.size() - 1);
                    CanvasPlugin.this.sizeList.remove(CanvasPlugin.this.sizeList.size() - 1);
                }
            }
        };
    }

    protected void startUp() throws Exception {
        if (this.overlay == null) {
            this.overlay = new CanvasOverlay(this, this.config);
        }
        this.overlayManager.add((Overlay)this.overlay);
        this.initHotkeys();
        this.toggleHotkeys();
    }

    protected void shutDown() throws Exception {
        if (this.hotkeysEnabled) {
            this.toggleHotkeys();
        }
        this.overlayManager.remove((Overlay)this.overlay);
        this.curveList.clear();
        this.colorList.clear();
        this.sizeList.clear();
    }

    @Subscribe
    public void onGameStateChanged(GameStateChanged gameStateChanged) {
        if (gameStateChanged.getGameState() == GameState.LOGGED_IN) {
            this.setMouseListenerEnabled(true);
        }
    }

    public void setMouseListenerEnabled(boolean enabled) {
        if (enabled) {
            this.mouseManager.registerMouseListener((MouseListener)this.mouseAdapter);
        } else {
            this.mouseManager.unregisterMouseListener((MouseListener)this.mouseAdapter);
        }
    }

    public void updateMousePositions(Point point) {
        if (this.temp != null) {
            Curve current = new Curve(this.temp, point);
            this.curve.add(current);
        }
        this.temp = point;
    }

    private void toggleHotkeys() {
        for (HotkeyListener hotkey : this.hotkeys) {
            if (this.hotkeysEnabled) {
                this.keyManager.unregisterKeyListener((KeyListener)hotkey);
                continue;
            }
            this.keyManager.registerKeyListener((KeyListener)hotkey);
        }
        this.hotkeysEnabled = !this.hotkeysEnabled;
    }

    public Deque<Curve> getTrail() {
        return this.curve;
    }

    @Provides
    CanvasConfig provideConfig(ConfigManager configManager) {
        return (CanvasConfig)configManager.getConfig(CanvasConfig.class);
    }
}

