/*
 * Decompiled with CFR 0.152.
 */
package com.canvas;

import com.canvas.CanvasConfig;
import com.canvas.CanvasPlugin;
import com.canvas.Curve;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import net.runelite.api.Point;
import net.runelite.client.ui.overlay.Overlay;
import net.runelite.client.ui.overlay.OverlayLayer;
import net.runelite.client.ui.overlay.OverlayPosition;
import net.runelite.client.ui.overlay.OverlayPriority;

public class CanvasOverlay
extends Overlay {
    private final CanvasPlugin plugin;
    private final CanvasConfig config;
    public List<Deque<Curve>> curveList;
    public List<Color> colorList;
    public List<Integer> sizeList;

    public CanvasOverlay(CanvasPlugin plugin, CanvasConfig config) {
        this.plugin = plugin;
        this.config = config;
        this.curveList = plugin.curveList;
        this.colorList = plugin.colorList;
        this.sizeList = plugin.sizeList;
        this.setPosition(OverlayPosition.DYNAMIC);
        this.setPriority(OverlayPriority.HIGH);
        this.setLayer(OverlayLayer.ABOVE_WIDGETS);
    }

    public Dimension render(Graphics2D graphics) {
        if (!this.config.showOverlay()) {
            return null;
        }
        this.drawCurvesFromList(this.curveList, this.colorList, graphics);
        ArrayList<Curve> trail = new ArrayList<Curve>(this.plugin.getTrail());
        Point midBefore = null;
        Point midAfter = null;
        graphics.setStroke(new BasicStroke(this.sizeList.get(this.sizeList.size() - 1).intValue(), 0, 1));
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setColor(this.colorList.get(this.colorList.size() - 1));
        for (int i = 0; i < trail.size(); ++i) {
            List<Point> points = ((Curve)trail.get(i)).getCurve();
            for (int j = 0; j < points.size(); ++j) {
                Point before = null;
                Point after = null;
                Point previous = null;
                Point current = null;
                if (i != 0 && j == 0) {
                    List<Point> previousPoints = ((Curve)trail.get(i - 1)).getCurve();
                    before = previousPoints.get(previousPoints.size() - 2);
                    after = points.get(j + 1);
                    previous = previousPoints.get(previousPoints.size() - 1);
                    current = points.get(j);
                } else if (j > 1) {
                    before = points.get(j - 2);
                    previous = points.get(j - 1);
                    current = points.get(j);
                    if (i < trail.size() - 1 && j == points.size() - 1) {
                        after = ((Curve)trail.get(i + 1)).getCurve().get(1);
                    }
                }
                if (j == 4) {
                    if (midBefore == null) {
                        midBefore = points.get(j);
                    }
                } else if (j == 2 && midBefore != null) {
                    midAfter = points.get(j);
                }
                if (previous != null && current != null) {
                    graphics.drawLine(previous.getX(), previous.getY(), current.getX(), current.getY());
                }
                if (before != null && after != null) {
                    graphics.drawLine(before.getX(), before.getY(), after.getX(), after.getY());
                }
                if (midBefore == null || midAfter == null) continue;
                graphics.drawLine(midBefore.getX(), midBefore.getY(), midAfter.getX(), midAfter.getY());
                midBefore = midAfter;
                midAfter = null;
            }
        }
        return null;
    }

    public void drawCurvesFromList(List<Deque<Curve>> curveList, List<Color> colorList, Graphics2D graphics) {
        for (int k = 0; k < curveList.size(); ++k) {
            Deque<Curve> currentCurve = curveList.get(k);
            ArrayList<Curve> trail = new ArrayList<Curve>(currentCurve);
            Point midBefore = null;
            Point midAfter = null;
            graphics.setStroke(new BasicStroke(this.sizeList.get(k).intValue(), 0, 1));
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setColor(colorList.get(k));
            for (int i = 0; i < trail.size(); ++i) {
                List<Point> points = ((Curve)trail.get(i)).getCurve();
                for (int j = 0; j < points.size(); ++j) {
                    Point before = null;
                    Point after = null;
                    Point previous = null;
                    Point current = null;
                    if (i != 0 && j == 0) {
                        List<Point> previousPoints = ((Curve)trail.get(i - 1)).getCurve();
                        before = previousPoints.get(previousPoints.size() - 2);
                        after = points.get(j + 1);
                        previous = previousPoints.get(previousPoints.size() - 1);
                        current = points.get(j);
                    } else if (j > 1) {
                        before = points.get(j - 2);
                        previous = points.get(j - 1);
                        current = points.get(j);
                        if (i < trail.size() - 1 && j == points.size() - 1) {
                            after = ((Curve)trail.get(i + 1)).getCurve().get(1);
                        }
                    }
                    if (j == 4) {
                        if (midBefore == null) {
                            midBefore = points.get(j);
                        }
                    } else if (j == 2 && midBefore != null) {
                        midAfter = points.get(j);
                    }
                    if (previous != null && current != null) {
                        graphics.drawLine(previous.getX(), previous.getY(), current.getX(), current.getY());
                    }
                    if (before != null && after != null) {
                        graphics.drawLine(before.getX(), before.getY(), after.getX(), after.getY());
                    }
                    if (midBefore == null || midAfter == null) continue;
                    graphics.drawLine(midBefore.getX(), midBefore.getY(), midAfter.getX(), midAfter.getY());
                    midBefore = midAfter;
                    midAfter = null;
                }
            }
        }
    }
}

